/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.application;

import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class ConfigGenerator {
    private static final Pattern PLUGIN_LINE_PATTERN = Pattern.compile("\\s*<plugin id=\"(\\S*)\".*");
    private static final Map<String, String> PLUGINS_WITH_START_LEVEL = new HashMap<String, String>();
    private static final Set<String> PLUGINS_NOT_IN_SCRIPT_VERSION = new HashSet<String>();

    static {
        PLUGINS_WITH_START_LEVEL.put("org.apache.felix.scr", "@1\\:start");
        PLUGINS_WITH_START_LEVEL.put("org.eclipse.equinox.common", "@2\\:start");
        PLUGINS_WITH_START_LEVEL.put("org.eclipse.core.runtime", "@start");
        PLUGINS_NOT_IN_SCRIPT_VERSION.add("org.eclipse.update.configurator");
        PLUGINS_NOT_IN_SCRIPT_VERSION.add("org.eclipse.equinox.p2.ui");
        PLUGINS_NOT_IN_SCRIPT_VERSION.add("org.eclipse.equinox.p2.ui.sdk");
    }

    public static void main(String[] args) {
        String productFilePath;
        List<String> pluginList;
        if (args.length < 4) {
            ConfigGenerator.printUsage();
            System.exit(1);
        }
        if ((pluginList = ConfigGenerator.parsePluginList(productFilePath = args[1])).isEmpty()) {
            System.err.println("No plugins. Something must have gone wrong.");
            System.exit(1);
        }
        Path configOutputPath = Paths.get(args[3], new String[0]);
        ConfigGenerator.generateConfigIni(pluginList, configOutputPath);
        System.exit(0);
    }

    private static void generateConfigIni(List<String> pluginList, Path configOutputPath) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileWriter r = new FileWriter(configOutputPath.toFile());){
                r.write("osgi.install.area=file\\:$eclipse.home$\n");
                r.write("osgi.framework=file\\:$eclipse.home$/plugins/$osgi.jar$\n");
                r.write("osgi.bundles=");
                int i = 0;
                while (i < pluginList.size()) {
                    String pluginName = pluginList.get(i);
                    if (!PLUGINS_NOT_IN_SCRIPT_VERSION.contains(pluginName)) {
                        r.write(pluginName);
                        if (PLUGINS_WITH_START_LEVEL.containsKey(pluginName)) {
                            r.write(PLUGINS_WITH_START_LEVEL.get(pluginName));
                        }
                        r.write(44);
                    }
                    ++i;
                }
                r.write(10);
                r.write("osgi.configuration.cascaded=false\n");
                r.write("osgi.bundles.defaultStartLevel=4\n");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static List<String> parsePluginList(String productPath) {
        ArrayList<String> pluginList = new ArrayList<String>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<String> stream = Files.lines(Paths.get(productPath, new String[0]));){
                stream.forEach(line -> {
                    Matcher m = PLUGIN_LINE_PATTERN.matcher((CharSequence)line);
                    if (m.matches()) {
                        pluginList.add(m.group(1));
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
        return pluginList;
    }

    private static void printUsage() {
        System.err.println("Usage:");
        System.err.println("  ConfigGenerator -product /path/to/foo.product -out /path/to/config.ini");
    }
}

