/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.launching;

import java.io.IOException;
import org.eclipse.cdt.dsf.gdb.launching.LaunchMessages;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.core.target.ILaunchTargetManager;
import org.eclipse.launchbar.core.target.ILaunchTargetProvider;
import org.eclipse.launchbar.core.target.TargetStatus;

public class GDBRemoteSerialLaunchTargetProvider
implements ILaunchTargetProvider {
    public static final String TYPE_ID = "org.eclipse.cdt.dsf.gdb.remoteSerialLaunchTargetType";

    public void init(ILaunchTargetManager targetManager) {
    }

    public TargetStatus getStatus(ILaunchTarget target) {
        String device = target.getAttribute("org.eclipse.cdt.dsf.gdb.DEV", "");
        if (device.isEmpty()) {
            return new TargetStatus(TargetStatus.Code.ERROR, LaunchMessages.getString("GDBRemoteSerialLaunchTargetProvider_NoPort"));
        }
        try {
            String[] stringArray = SerialPort.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String port = stringArray[n2];
                if (device.equals(port)) {
                    return TargetStatus.OK_STATUS;
                }
                ++n2;
            }
            return new TargetStatus(TargetStatus.Code.ERROR, String.format(LaunchMessages.getString("GDBRemoteSerialLaunchTargetProvider_NotFound"), device));
        }
        catch (IOException e) {
            return new TargetStatus(TargetStatus.Code.ERROR, e.getLocalizedMessage());
        }
    }
}

