/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.Immutable;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIFrame;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MITuple;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;

@Immutable
public class MIThread {
    public static final String MI_THREAD_STATE_RUNNING = "running";
    public static final String MI_THREAD_STATE_STOPPED = "stopped";
    private final String fThreadId;
    private final String fTargetId;
    private final String fOsId;
    private final String fParentId;
    private final MIFrame fTopFrame;
    private final String fDetails;
    private final String fState;
    private final String fCore;
    private final String fName;
    private static Pattern fgOsIdPattern1 = Pattern.compile("([Tt][Hh][Rr][Ee][Aa][Dd]\\s*)(0x[0-9a-fA-F]+|-?\\d+)(\\s*\\([Ll][Ww][Pp]\\s*)(\\d*)", 0);
    private static Pattern fgOsIdPattern2 = Pattern.compile("[Tt][Hh][Rr][Ee][Aa][Dd]\\s*\\d+\\.(\\d+)", 0);
    private static Pattern fgOsIdPattern3 = Pattern.compile("[Tt][Hh][Rr][Ee][Aa][Dd]\\s*(\\S+)", 0);
    private static Pattern fgOsIdPattern4 = Pattern.compile("[Pp][Rr][Oo][Cc][Ee][Ss][Ss]\\s*(\\S+)", 0);
    private static Pattern fgIdPattern = Pattern.compile("[Tt][Hh][Rr][Ee][Aa][Dd]\\s*(\\d+)\\.\\d+", 0);

    protected MIThread(String threadId, String targetId, String osId, String parentId, MIFrame topFrame, String details, String state, String core) {
        this(threadId, targetId, osId, parentId, topFrame, details, state, core, null);
    }

    protected MIThread(String threadId, String targetId, String osId, String parentId, MIFrame topFrame, String details, String state, String core, String name) {
        this.fThreadId = threadId;
        this.fTargetId = targetId;
        this.fOsId = osId;
        this.fParentId = parentId;
        this.fTopFrame = topFrame;
        this.fDetails = details;
        this.fState = state;
        this.fCore = core;
        this.fName = name;
    }

    public String getThreadId() {
        return this.fThreadId;
    }

    public String getTargetId() {
        return this.fTargetId;
    }

    public String getOsId() {
        return this.fOsId;
    }

    public String getParentId() {
        return this.fParentId;
    }

    public MIFrame getTopFrame() {
        return this.fTopFrame;
    }

    public String getDetails() {
        return this.fDetails;
    }

    public String getState() {
        return this.fState;
    }

    public String getCore() {
        return this.fCore;
    }

    public String getName() {
        return this.fName;
    }

    public static MIThread parse(MITuple tuple) {
        MIResult[] results = tuple.getMIResults();
        String threadId = null;
        String targetId = null;
        String osId = null;
        String parentId = null;
        MIFrame topFrame = null;
        String state = null;
        String details = null;
        String core = null;
        String name = null;
        MIResult[] mIResultArray = results;
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            MIValue val;
            MIResult result = mIResultArray[n2];
            String var = result.getVariable();
            if (var.equals("id")) {
                val = result.getMIValue();
                if (val instanceof MIConst) {
                    threadId = ((MIConst)val).getCString().trim();
                }
            } else if (var.equals("target-id")) {
                val = result.getMIValue();
                if (val instanceof MIConst) {
                    targetId = ((MIConst)val).getCString().trim();
                    osId = MIThread.parseOsId(targetId);
                    parentId = MIThread.parseParentId(targetId);
                }
            } else if (var.equals("frame")) {
                val = (MITuple)result.getMIValue();
                topFrame = new MIFrame((MITuple)val);
            } else if (var.equals("state")) {
                val = result.getMIValue();
                if (val instanceof MIConst) {
                    state = ((MIConst)val).getCString().trim();
                }
            } else if (var.equals("details")) {
                val = result.getMIValue();
                if (val instanceof MIConst) {
                    details = ((MIConst)val).getCString().trim();
                }
            } else if (var.equals("core")) {
                val = result.getMIValue();
                if (val instanceof MIConst) {
                    core = ((MIConst)val).getCString().trim();
                }
            } else if (var.equals("name") && (val = result.getMIValue()) instanceof MIConst) {
                name = ((MIConst)val).getCString().trim();
            }
            ++n2;
        }
        return new MIThread(threadId, targetId, osId, parentId, topFrame, details, state, core, name);
    }

    protected static String parseOsId(String str) {
        Matcher matcher = fgOsIdPattern1.matcher(str);
        if (matcher.find()) {
            return matcher.group(4);
        }
        matcher = fgOsIdPattern2.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = fgOsIdPattern3.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        matcher = fgOsIdPattern4.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    protected static String parseParentId(String str) {
        Matcher matcher = fgIdPattern.matcher(str);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

