/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.lsp.LanguageProtocolExtension;
import org.eclipse.cdt.lsp.LanguageServerConfiguration;
import org.eclipse.cdt.lsp.SupportedProtocolExtensions;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public final class ContributedProtocolExtensions
implements SupportedProtocolExtensions {
    private final Map<String, List<LanguageProtocolExtension>> extensions = new LinkedHashMap<String, List<LanguageProtocolExtension>>();

    @Override
    public Collection<LanguageProtocolExtension> all() {
        return this.extensions.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public Collection<LanguageProtocolExtension> applicable(LanguageServerConfiguration server) {
        return new ArrayList<LanguageProtocolExtension>(this.extensions.getOrDefault(server.identifier(), Collections.emptyList()));
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void register(LanguageProtocolExtension extension) {
        List list = this.extensions.computeIfAbsent(extension.targetIdentifier(), x -> new ArrayList());
        if (!list.contains(extension)) {
            list.add(extension);
        }
    }

    public void unregister(LanguageProtocolExtension extension) {
        Optional<List<LanguageProtocolExtension>> optional = Optional.ofNullable(this.extensions.get(extension.targetIdentifier()));
        if (optional.isPresent()) {
            List<LanguageProtocolExtension> list = optional.get();
            list.remove(extension);
            if (list.isEmpty()) {
                this.extensions.remove(extension.targetIdentifier());
            }
        }
    }
}

