/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.ui.commands;

import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.BuildConfigurationsJob;
import org.eclipse.cdt.managedbuilder.internal.ui.commands.Messages;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIImages;
import org.eclipse.cdt.managedbuilder.ui.properties.ManagedBuilderUIPlugin;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class RebuildConfigurationsDialog
extends MessageDialog {
    private static final String DIALOG_SETTINGS_SECTION = "RebuildConfigurationsDialogSettings";
    private static final String DIALOG_ORIGIN_X = "DIALOG_X_ORIGIN";
    private static final String DIALOG_ORIGIN_Y = "DIALOG_Y_ORIGIN";
    private static final String DIALOG_WIDTH = "DIALOG_WIDTH";
    private static final String DIALOG_HEIGHT = "DIALOG_HEIGHT";
    private Button cleanCheckbox;
    private Button buildCheckbox;
    private ContainerCheckedTreeViewer cfgCheckboxViewer;
    private IProject[] projects;
    private Object[] selected;
    private int cleanKind;
    private int buildKind;

    public RebuildConfigurationsDialog(IProject[] projects) {
        super(CUIPlugin.getActiveWorkbenchShell(), Messages.RebuildConfigurationsDialog_RebuildConfigurations, null, Messages.RebuildConfigurationsDialog_SelectConfigurations, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.projects = projects;
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId != 0) {
            return;
        }
        BuildUtilities.saveEditors(null);
        if (this.selected != null) {
            ArrayList<ICConfigurationDescription> cfgDescriptions = new ArrayList<ICConfigurationDescription>();
            Object[] objectArray = this.selected;
            int n = this.selected.length;
            int n2 = 0;
            while (n2 < n) {
                Object sel = objectArray[n2];
                if (sel instanceof ICConfigurationDescription) {
                    cfgDescriptions.add((ICConfigurationDescription)sel);
                }
                ++n2;
            }
            if (this.cleanKind != 0 || this.buildKind != 0) {
                ICConfigurationDescription[] cfgdArray = cfgDescriptions.toArray(new ICConfigurationDescription[cfgDescriptions.size()]);
                BuildConfigurationsJob buildJob = new BuildConfigurationsJob(cfgdArray, this.cleanKind, this.buildKind);
                buildJob.schedule();
            }
        }
    }

    protected Control createCustomArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        area.setLayout((Layout)layout);
        area.setLayoutData((Object)new GridData(1808));
        SelectionAdapter updateEnablement = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RebuildConfigurationsDialog.this.updateEnablement();
            }
        };
        this.createProjectSelectionTable(area);
        this.cleanCheckbox = new Button(parent, 32);
        this.cleanCheckbox.setText(Messages.RebuildConfigurationsDialog_CleanConfigurations);
        this.cleanCheckbox.setSelection(true);
        this.cleanCheckbox.setLayoutData((Object)new GridData(32));
        this.cleanCheckbox.addSelectionListener((SelectionListener)updateEnablement);
        this.cleanKind = this.cleanCheckbox.getSelection() ? 15 : 0;
        this.buildCheckbox = new Button(parent, 32);
        this.buildCheckbox.setText(Messages.RebuildConfigurationsDialog_BuildConfigurations);
        this.buildCheckbox.setSelection(true);
        this.buildCheckbox.setLayoutData((Object)new GridData(32));
        this.buildCheckbox.addSelectionListener((SelectionListener)updateEnablement);
        this.buildKind = this.buildCheckbox.getSelection() ? 10 : 0;
        return area;
    }

    private void createProjectSelectionTable(Composite area) {
        this.cfgCheckboxViewer = new ContainerCheckedTreeViewer(area, 2048);
        this.cfgCheckboxViewer.setContentProvider((IContentProvider)new ConfigurationContentProvider());
        this.cfgCheckboxViewer.setLabelProvider((IBaseLabelProvider)new ConfigurationLabelProvider());
        this.cfgCheckboxViewer.setInput((Object)this.projects);
        GridData data = new GridData(1808);
        data.horizontalSpan = 2;
        data.widthHint = 200;
        data.heightHint = 200;
        this.cfgCheckboxViewer.getControl().setLayoutData((Object)data);
        ArrayList<ICConfigurationDescription> initialSelection = new ArrayList<ICConfigurationDescription>(this.projects.length);
        IProject[] iProjectArray = this.projects;
        int n = this.projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject prj = iProjectArray[n2];
            ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(prj, false);
            if (prjd != null) {
                this.cfgCheckboxViewer.setChecked((Object)prjd.getActiveConfiguration(), true);
                initialSelection.add(prjd.getActiveConfiguration());
            }
            ++n2;
        }
        this.cfgCheckboxViewer.expandAll();
        this.cfgCheckboxViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                RebuildConfigurationsDialog.this.updateEnablement();
                RebuildConfigurationsDialog.this.selected = RebuildConfigurationsDialog.this.cfgCheckboxViewer.getCheckedElements();
            }
        });
        this.selected = this.cfgCheckboxViewer.getCheckedElements();
        this.selected = initialSelection.toArray(new ICConfigurationDescription[initialSelection.size()]);
    }

    protected void updateEnablement() {
        this.cleanKind = this.cleanCheckbox.getSelection() ? 15 : 0;
        this.buildKind = this.buildCheckbox.getSelection() ? 10 : 0;
        boolean enabled = this.cfgCheckboxViewer.getCheckedElements().length > 0 && (this.cleanKind != 0 || this.buildKind != 0);
        this.getButton(0).setEnabled(enabled);
    }

    public boolean close() {
        this.persistDialogSettings(this.getShell(), DIALOG_SETTINGS_SECTION);
        return super.close();
    }

    protected Point getInitialLocation(Point initialSize) {
        Point p = this.getInitialLocation(DIALOG_SETTINGS_SECTION);
        return p != null ? p : super.getInitialLocation(initialSize);
    }

    protected Point getInitialSize() {
        Point p = super.getInitialSize();
        return this.getInitialSize(DIALOG_SETTINGS_SECTION, p);
    }

    private Point getInitialLocation(String dialogSettingsSectionName) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_ORIGIN_X);
            int y = settings.getInt(DIALOG_ORIGIN_Y);
            return new Point(x, y);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    private IDialogSettings getDialogSettings(String dialogSettingsSectionName) {
        IDialogSettings settings = ManagedBuilderUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(dialogSettingsSectionName);
        if (section == null) {
            section = settings.addNewSection(dialogSettingsSectionName);
        }
        return section;
    }

    private void persistDialogSettings(Shell shell, String dialogSettingsSectionName) {
        Point shellLocation = shell.getLocation();
        Point shellSize = shell.getSize();
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        settings.put(DIALOG_ORIGIN_X, shellLocation.x);
        settings.put(DIALOG_ORIGIN_Y, shellLocation.y);
        settings.put(DIALOG_WIDTH, shellSize.x);
        settings.put(DIALOG_HEIGHT, shellSize.y);
    }

    private Point getInitialSize(String dialogSettingsSectionName, Point initialSize) {
        IDialogSettings settings = this.getDialogSettings(dialogSettingsSectionName);
        try {
            int x = settings.getInt(DIALOG_WIDTH);
            int y = settings.getInt(DIALOG_HEIGHT);
            return new Point(Math.max(x, initialSize.x), Math.max(y, initialSize.y));
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected boolean isResizable() {
        return true;
    }

    private class ConfigurationContentProvider
    implements ITreeContentProvider {
        private ConfigurationContentProvider() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IProject[]) {
                return ((IProject[])element).length > 0;
            }
            if (element instanceof IProject) {
                IProject project = (IProject)element;
                ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(project, false);
                if (prjd == null) {
                    return false;
                }
                ICConfigurationDescription[] cfgDescriptions = prjd.getConfigurations();
                return cfgDescriptions != null && cfgDescriptions.length > 0;
            }
            return false;
        }

        public Object getParent(Object element) {
            if (element instanceof IProject) {
                return RebuildConfigurationsDialog.this.projects;
            }
            if (element instanceof ICConfigurationDescription) {
                ICConfigurationDescription cfgDescription = (ICConfigurationDescription)element;
                return cfgDescription.getProjectDescription().getProject();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IProject[]) {
                return (IProject[])parentElement;
            }
            if (parentElement instanceof IProject) {
                IProject project = (IProject)parentElement;
                ICProjectDescription prjd = CoreModel.getDefault().getProjectDescription(project, false);
                if (prjd != null) {
                    Object[] cfgDescriptions = prjd.getConfigurations();
                    return cfgDescriptions;
                }
            }
            return new Object[0];
        }
    }

    private static class ConfigurationLabelProvider
    implements ILabelProvider {
        WorkbenchLabelProvider workbenchLabelProvider = new WorkbenchLabelProvider();

        private ConfigurationLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
            this.workbenchLabelProvider.addListener(listener);
        }

        public void dispose() {
            this.workbenchLabelProvider.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.workbenchLabelProvider.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.workbenchLabelProvider.removeListener(listener);
        }

        public Image getImage(Object element) {
            if (element instanceof ICConfigurationDescription) {
                return ManagedBuilderUIImages.get(ManagedBuilderUIImages.IMG_BUILD_CONFIG);
            }
            return this.workbenchLabelProvider.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof ICConfigurationDescription) {
                ICConfigurationDescription cfgDescription = (ICConfigurationDescription)element;
                String name = cfgDescription.getName();
                if (cfgDescription.isActive()) {
                    return String.valueOf(name) + ' ' + Messages.RebuildConfigurationsDialog_Active;
                }
                return name;
            }
            return this.workbenchLabelProvider.getText(element);
        }
    }
}

