/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.ui.assist;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.corext.template.c.CContextType;
import org.eclipse.cdt.internal.qt.core.index.IQProperty;
import org.eclipse.cdt.internal.qt.core.parser.QtParser;
import org.eclipse.cdt.internal.qt.ui.Activator;
import org.eclipse.cdt.internal.qt.ui.assist.QPropertyAttributeProposal;
import org.eclipse.cdt.internal.qt.ui.assist.QtProposalContext;
import org.eclipse.cdt.internal.qt.ui.assist.QtTemplateProposal;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;

public class QPropertyExpansion {
    private final String expansion;
    private final int startOfAttrs;
    private final int cursor;
    private final IType type;
    private final String name;
    private final Identifier currIdentifier;
    private final Identifier prevIdentifier;
    private static final Pattern TYPENAME_REGEX;

    static {
        StringBuilder regexBuilder = new StringBuilder();
        regexBuilder.append("^(?:Q_PROPERTY\\s*\\()?\\s*(.*?)(\\s+)(?:");
        IQProperty.Attribute[] attributeArray = IQProperty.Attribute.values();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQProperty.Attribute attr = attributeArray[n2];
            if (attr.ordinal() > 0) {
                regexBuilder.append('|');
            }
            regexBuilder.append("(?:");
            regexBuilder.append(attr.identifier);
            regexBuilder.append(")");
            ++n2;
        }
        regexBuilder.append(").*$");
        TYPENAME_REGEX = Pattern.compile(regexBuilder.toString());
    }

    public static QPropertyExpansion create(ICEditorContentAssistInvocationContext context) {
        int closingParen;
        int offset = context.getContextInformationOffset();
        if (offset < 0) {
            return null;
        }
        IDocument doc = context.getDocument();
        CHeuristicScanner scanner = new CHeuristicScanner(doc);
        int lowerBound = Math.max(0, offset - 64);
        int upperBound = Math.min(doc.getLength(), offset + 512);
        int openingParen = scanner.findOpeningPeer(offset, lowerBound, '(', ')');
        if (openingParen == -1) {
            return null;
        }
        int token = scanner.previousToken(scanner.getPosition() - 1, lowerBound);
        if (token != 2000) {
            return null;
        }
        int begin = scanner.getPosition();
        if (begin != 0) {
            ++begin;
        }
        String identifier = null;
        try {
            identifier = doc.get(begin, openingParen - begin);
        }
        catch (BadLocationException e) {
            Activator.log(e);
        }
        if (!"Q_PROPERTY".equals(identifier)) {
            return null;
        }
        String expansion = null;
        if ((closingParen = scanner.findClosingPeer(++openingParen, upperBound, '(', ')')) != -1 && context.getInvocationOffset() > scanner.getPosition()) {
            return null;
        }
        try {
            expansion = closingParen != -1 ? doc.get(openingParen, closingParen - openingParen) : doc.get(openingParen, context.getInvocationOffset() - openingParen);
        }
        catch (BadLocationException e) {
            Activator.log(e);
        }
        if (expansion == null) {
            return null;
        }
        int cursor = context.getInvocationOffset();
        Identifier currIdentifier = QPropertyExpansion.identifier(doc, scanner, cursor, lowerBound, upperBound);
        if (currIdentifier == null) {
            return null;
        }
        Identifier prevIdentifier = QPropertyExpansion.identifier(doc, scanner, currIdentifier.start - 1, lowerBound, upperBound);
        IType type = null;
        String name = null;
        int endOfTypeName = 0;
        Matcher m = TYPENAME_REGEX.matcher(expansion);
        if (m.matches()) {
            endOfTypeName = openingParen + m.end(2);
            ICPPASTTypeId typeId = QtParser.parseTypeId((String)m.group(1));
            type = CPPVisitor.createType((IASTTypeId)typeId);
            IASTDeclarator declarator = typeId.getAbstractDeclarator();
            if (declarator != null && declarator.getName() != null) {
                name = declarator.getName().toString();
            }
        }
        return new QPropertyExpansion(expansion, endOfTypeName, cursor, type, name, prevIdentifier, currIdentifier);
    }

    private QPropertyExpansion(String expansion, int startOfAttrs, int cursor, IType type, String name, Identifier prev, Identifier curr) {
        this.expansion = expansion;
        this.startOfAttrs = startOfAttrs;
        this.cursor = cursor;
        this.type = type;
        this.name = name;
        this.prevIdentifier = prev;
        this.currIdentifier = curr;
    }

    public String getCurrIdentifier() {
        return this.currIdentifier.ident;
    }

    public String getPrevIdentifier() {
        return this.prevIdentifier.ident;
    }

    public String getPrefix() {
        if (this.currIdentifier.ident == null) {
            return null;
        }
        if (this.cursor > this.currIdentifier.start + this.currIdentifier.ident.length()) {
            return null;
        }
        return this.currIdentifier.ident.substring(0, this.cursor - this.currIdentifier.start);
    }

    private static ICompletionProposal templateProposal(String contextId, ICEditorContentAssistInvocationContext context, String display, String replacement, int relevance) {
        Template template = new Template(display, "Q_PROPERTY declaration parameter", contextId, replacement, true);
        CContextType ctxType = new CContextType();
        ctxType.setId(contextId);
        QtProposalContext templateCtx = new QtProposalContext(context, (TemplateContextType)ctxType);
        Region region = new Region(templateCtx.getCompletionOffset(), templateCtx.getCompletionLength());
        return new QtTemplateProposal(template, (TemplateContext)templateCtx, (IRegion)region, relevance);
    }

    public List<ICompletionProposal> getProposals(String contextId, ICEditorContentAssistInvocationContext context) {
        if (this.currIdentifier.start < this.startOfAttrs) {
            return Collections.emptyList();
        }
        if (this.prevIdentifier.start < this.startOfAttrs) {
            return Collections.singletonList(new Attribute(IQProperty.Attribute.READ).getProposal(contextId, context));
        }
        String prefix = this.getPrefix();
        ArrayList<Attribute> unspecifiedAttributes = new ArrayList<Attribute>();
        IQProperty.Attribute[] attributeArray = IQProperty.Attribute.values();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQProperty.Attribute attr = attributeArray[n2];
            if (attr.hasValue && this.prevIdentifier != null && attr.identifier.equals(this.prevIdentifier.ident)) {
                Collection<QPropertyAttributeProposal> attrProposals = QPropertyAttributeProposal.buildProposals(attr, context, this.type, this.name);
                if (attrProposals != null) {
                    ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
                    for (QPropertyAttributeProposal value : attrProposals) {
                        if (prefix != null && !value.getIdentifier().startsWith(prefix)) continue;
                        proposals.add(value.createProposal(prefix, context.getInvocationOffset()));
                    }
                    return proposals;
                }
                return Collections.emptyList();
            }
            if (prefix != null) {
                if (attr.identifier.startsWith(prefix) && (!this.expansion.matches(".*\\s+" + attr.identifier + "\\s+.*") || attr.identifier.equals(this.currIdentifier.ident))) {
                    unspecifiedAttributes.add(new Attribute(attr));
                }
            } else if (!this.expansion.matches(".*\\s+" + attr.identifier + "\\s+.*")) {
                unspecifiedAttributes.add(new Attribute(attr));
            }
            ++n2;
        }
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (Attribute attr : unspecifiedAttributes) {
            ICompletionProposal proposal = attr.getProposal(contextId, context);
            if (proposal == null) continue;
            proposals.add(proposal);
        }
        return proposals;
    }

    private static Identifier identifier(IDocument doc, CHeuristicScanner scanner, int cursor, int lower, int upper) {
        int begin;
        block6: {
            int tok;
            block5: {
                try {
                    if (Character.isWhitespace(doc.getChar(cursor - 1))) {
                        int prev = scanner.findNonWhitespaceBackward(cursor, lower);
                        return new Identifier(Math.min(cursor, prev + 1), null);
                    }
                    tok = scanner.previousToken(cursor, lower);
                    if (tok == 2000) break block5;
                    return null;
                }
                catch (BadLocationException e) {
                    Activator.log(e);
                    return null;
                }
            }
            begin = scanner.getPosition() + 1;
            tok = scanner.nextToken(begin, upper);
            if (tok == 2000) break block6;
            return null;
        }
        int end = scanner.getPosition();
        return new Identifier(begin, doc.get(begin, end - begin));
    }

    public String toString() {
        if (this.expansion == null) {
            return super.toString();
        }
        if (this.cursor >= this.expansion.length()) {
            return String.valueOf(this.expansion) + '|';
        }
        if (this.cursor < 0) {
            return "|" + this.expansion;
        }
        return String.valueOf(this.expansion.substring(0, this.cursor)) + '|' + this.expansion.substring(this.cursor);
    }

    private static class Attribute {
        public final IQProperty.Attribute attribute;
        public final int relevance;

        public Attribute(IQProperty.Attribute attribute) {
            this.attribute = attribute;
            switch (attribute) {
                case READ: {
                    this.relevance = 11;
                    break;
                }
                case WRITE: {
                    this.relevance = 10;
                    break;
                }
                case RESET: {
                    this.relevance = 9;
                    break;
                }
                case NOTIFY: {
                    this.relevance = 8;
                    break;
                }
                case REVISION: {
                    this.relevance = 7;
                    break;
                }
                case DESIGNABLE: {
                    this.relevance = 6;
                    break;
                }
                case SCRIPTABLE: {
                    this.relevance = 5;
                    break;
                }
                case STORED: {
                    this.relevance = 4;
                    break;
                }
                case USER: {
                    this.relevance = 3;
                    break;
                }
                case CONSTANT: {
                    this.relevance = 2;
                    break;
                }
                case FINAL: {
                    this.relevance = 1;
                    break;
                }
                default: {
                    this.relevance = 0;
                }
            }
        }

        public ICompletionProposal getProposal(String contextId, ICEditorContentAssistInvocationContext context) {
            if (!this.attribute.hasValue) {
                return new CCompletionProposal(this.attribute.identifier, context.getInvocationOffset(), 0, Activator.getQtLogo(), String.valueOf(this.attribute.identifier) + " - Q_PROPERTY declaration parameter", this.relevance);
            }
            String display = String.valueOf(this.attribute.identifier) + ' ' + this.attribute.paramName;
            String replacement = this.attribute.identifier;
            if ("bool".equals(this.attribute.paramName)) {
                replacement = String.valueOf(replacement) + " ${true}";
            } else if ("int".equals(this.attribute.paramName)) {
                replacement = String.valueOf(replacement) + " ${0}";
            } else if (this.attribute.paramName != null) {
                replacement = String.valueOf(replacement) + " ${" + this.attribute.paramName + '}';
            }
            return QPropertyExpansion.templateProposal(contextId, context, display, replacement, this.relevance);
        }
    }

    private static class Identifier {
        public final int start;
        public final String ident;

        public Identifier(int start, String ident) {
            this.start = start;
            this.ident = ident;
        }

        public String toString() {
            return String.valueOf(Integer.toString(this.start)) + ':' + this.ident;
        }
    }
}

