/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.callhierarchy;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunction;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.core.util.TextUtil;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.actions.CopyTreeAction;
import org.eclipse.cdt.internal.ui.callhierarchy.CHContentProvider;
import org.eclipse.cdt.internal.ui.callhierarchy.CHDropTargetListener;
import org.eclipse.cdt.internal.ui.callhierarchy.CHEProviderSettings;
import org.eclipse.cdt.internal.ui.callhierarchy.CHHistoryDropDownAction;
import org.eclipse.cdt.internal.ui.callhierarchy.CHLabelProvider;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMessages;
import org.eclipse.cdt.internal.ui.callhierarchy.CHMultiDefNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHNode;
import org.eclipse.cdt.internal.ui.callhierarchy.CHPinAction;
import org.eclipse.cdt.internal.ui.callhierarchy.CHReferenceInfo;
import org.eclipse.cdt.internal.ui.callhierarchy.CHRemoveFromView;
import org.eclipse.cdt.internal.ui.callhierarchy.CallHierarchyUI;
import org.eclipse.cdt.internal.ui.search.actions.SelectionSearchGroup;
import org.eclipse.cdt.internal.ui.util.Messages;
import org.eclipse.cdt.internal.ui.viewsupport.AdaptingSelectionProvider;
import org.eclipse.cdt.internal.ui.viewsupport.CElementLabels;
import org.eclipse.cdt.internal.ui.viewsupport.DecoratingCLabelProvider;
import org.eclipse.cdt.internal.ui.viewsupport.EditorOpener;
import org.eclipse.cdt.internal.ui.viewsupport.ExtendedTreeViewer;
import org.eclipse.cdt.internal.ui.viewsupport.IndexUI;
import org.eclipse.cdt.internal.ui.viewsupport.TreeNavigator;
import org.eclipse.cdt.internal.ui.viewsupport.WorkingSetFilterUI;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ICHEContentProvider;
import org.eclipse.cdt.ui.actions.OpenViewActionGroup;
import org.eclipse.cdt.ui.refactoring.actions.CRefactoringActionGroup;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.bindings.BindingManagerEvent;
import org.eclipse.jface.bindings.IBindingManagerListener;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.TextActionHandler;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.ViewPart;

public class CHViewPart
extends ViewPart {
    private static final String TRUE = String.valueOf(true);
    private static final String KEY_WORKING_SET_FILTER = "workingSetFilter";
    private static final String KEY_FILTER_VARIABLES = "variableFilter";
    private static final String KEY_SHOW_FILES = "showFilesInLabels";
    private IMemento fMemento;
    private boolean fShowsMessage;
    private CHNode fNavigationNode;
    private int fNavigationDetail;
    private PageBook fPagebook;
    private Composite fViewerPage;
    private Label fInfoText;
    private CHContentProvider fContentProvider;
    private CHLabelProvider fLabelProvider;
    private ExtendedTreeViewer fTreeViewer;
    private ViewerFilter fVariableFilter;
    private ViewerComparator fSorterAlphaNumeric;
    private ViewerComparator fSorterReferencePosition;
    private WorkingSetFilterUI fWorkingSetFilterUI;
    private Action fReferencedByAction;
    private Action fMakesReferenceToAction;
    private Action fFilterVariablesAction;
    private Action fShowFilesInLabelsAction;
    private Action fNextAction;
    private Action fPreviousAction;
    private Action fRefreshAction;
    private Action fHistoryAction;
    private Action fShowReference;
    private Action fOpenElement;
    private Action fPinViewAction;
    private Action fRemoveFromViewAction;
    private CopyTreeAction fCopyAction;
    private OpenViewActionGroup fOpenViewActionGroup;
    private SelectionSearchGroup fSelectionSearchGroup;
    private CRefactoringActionGroup fRefactoringActionGroup;
    private IContextActivation fContextActivation;
    private boolean fIsPinned = false;
    private IPartListener2 fPartListener;
    private IBindingService bindingService;
    private IBindingManagerListener bindingManagerListener;
    private ICHEContentProvider[] fProviders;
    private DelegatingStyledCellLabelProvider.IStyledLabelProvider[] fLabelProviders;

    public void setFocus() {
        this.fPagebook.setFocus();
    }

    public void setMessage(String msg) {
        this.fInfoText.setText(msg);
        this.fPagebook.showPage((Control)this.fInfoText);
        this.fShowsMessage = true;
        this.updateDescription();
        this.updateActionEnablement();
    }

    public void setInput(ICElement input) {
        if (input == null) {
            this.setMessage(CHMessages.CHViewPart_emptyPageMessage);
            this.fTreeViewer.setInput(null);
            return;
        }
        this.fShowsMessage = false;
        boolean allowsRefTo = this.allowsRefTo(input);
        this.fTreeViewer.setInput(null);
        if (!allowsRefTo && !this.fContentProvider.getComputeReferencedBy()) {
            this.fContentProvider.setComputeReferencedBy(true);
            this.fReferencedByAction.setChecked(true);
            this.fMakesReferenceToAction.setChecked(false);
            this.updateSorter();
        }
        this.fMakesReferenceToAction.setEnabled(allowsRefTo);
        this.fTreeViewer.setInput(input);
        this.fPagebook.showPage((Control)this.fViewerPage);
        this.updateDescription();
        CallHierarchyUI.updateHistory(input);
        this.updateActionEnablement();
    }

    public void reportNotIndexed(ICElement input) {
        if (input != null && this.getInput() == input) {
            this.setMessage(IndexUI.getFileNotIndexedMessage(input));
        }
    }

    public void reportInputReplacement(ICElement input, ICElement inputHandle) {
        if (input == this.getInput()) {
            this.fTreeViewer.setInput(inputHandle);
            this.fTreeViewer.setExpandedState(inputHandle, true);
        }
    }

    private boolean allowsRefTo(ICElement element) {
        return element instanceof IFunction || element instanceof IMethod;
    }

    public void createPartControl(Composite parent) {
        this.fPagebook = new PageBook(parent, 0);
        this.createInfoPage();
        this.createViewerPage();
        this.getSite().setSelectionProvider((ISelectionProvider)new AdaptingSelectionProvider(ICElement.class, (ISelectionProvider)this.fTreeViewer));
        this.initDragAndDrop();
        this.createActions();
        this.createContextMenu();
        this.bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        if (this.bindingService != null) {
            this.bindingManagerListener = new IBindingManagerListener(){

                public void bindingManagerChanged(BindingManagerEvent event) {
                    String keyBinding;
                    if (event.isActiveBindingsChanged() && (keyBinding = CHViewPart.this.bindingService.getBestActiveBindingFormattedFor("org.eclipse.ui.edit.delete")) != null) {
                        CHViewPart.this.fRemoveFromViewAction.setText(String.valueOf(CHMessages.CHViewPart_RemoveFromView_label) + '\t' + keyBinding);
                    }
                }
            };
            this.bindingService.addBindingManagerListener(this.bindingManagerListener);
        }
        this.setMessage(CHMessages.CHViewPart_emptyPageMessage);
        this.initializeActionStates();
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext("org.eclipse.cdt.ui.cViewScope");
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.fPagebook, "org.eclipse.cdt.ui.call_hierarchy_view_context");
        this.addPartListener();
    }

    private void addPartListener() {
        this.fPartListener = new IPartListener2(){

            public void partActivated(IWorkbenchPartReference partRef) {
                if (CHViewPart.this.isThisView(partRef)) {
                    CallHierarchyUI.callHierarchyViewActivated(CHViewPart.this);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference partRef) {
            }

            public void partClosed(IWorkbenchPartReference partRef) {
                if (CHViewPart.this.isThisView(partRef)) {
                    CallHierarchyUI.callHierarchyViewClosed(CHViewPart.this);
                }
            }

            public void partDeactivated(IWorkbenchPartReference partRef) {
            }

            public void partOpened(IWorkbenchPartReference partRef) {
            }

            public void partHidden(IWorkbenchPartReference partRef) {
            }

            public void partVisible(IWorkbenchPartReference partRef) {
            }

            public void partInputChanged(IWorkbenchPartReference partRef) {
            }
        };
        this.getViewSite().getPage().addPartListener(this.fPartListener);
    }

    public void dispose() {
        IContextService ctxService;
        if (this.fContextActivation != null && (ctxService = (IContextService)this.getSite().getService(IContextService.class)) != null) {
            ctxService.deactivateContext(this.fContextActivation);
        }
        if (this.bindingService != null) {
            this.bindingService.removeBindingManagerListener(this.bindingManagerListener);
            this.bindingService = null;
        }
        if (this.fOpenViewActionGroup != null) {
            this.fOpenViewActionGroup.dispose();
            this.fOpenViewActionGroup = null;
        }
        if (this.fSelectionSearchGroup != null) {
            this.fSelectionSearchGroup.dispose();
            this.fSelectionSearchGroup = null;
        }
        if (this.fRefactoringActionGroup != null) {
            this.fRefactoringActionGroup.dispose();
            this.fRefactoringActionGroup = null;
        }
        if (this.fWorkingSetFilterUI != null) {
            this.fWorkingSetFilterUI.dispose();
            this.fWorkingSetFilterUI = null;
        }
        if (this.fPartListener != null) {
            this.getViewSite().getPage().removePartListener(this.fPartListener);
            this.fPartListener = null;
        }
        super.dispose();
    }

    private void initializeActionStates() {
        boolean referencedBy = true;
        boolean filterVariables = false;
        boolean showFiles = false;
        if (this.fMemento != null) {
            filterVariables = TRUE.equals(this.fMemento.getString(KEY_FILTER_VARIABLES));
            showFiles = TRUE.equals(this.fMemento.getString(KEY_SHOW_FILES));
        }
        this.fLabelProvider.setShowFiles(showFiles);
        this.fShowFilesInLabelsAction.setChecked(showFiles);
        this.fReferencedByAction.setChecked(referencedBy);
        this.fMakesReferenceToAction.setChecked(!referencedBy);
        this.fContentProvider.setComputeReferencedBy(referencedBy);
        this.fFilterVariablesAction.setChecked(filterVariables);
        this.fFilterVariablesAction.run();
        this.updateSorter();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.fMemento = memento;
        super.init(site, memento);
    }

    private boolean isThisView(IWorkbenchPartReference partRef) {
        if (!"org.eclipse.cdt.ui.callHierarchy".equals(partRef.getId())) {
            return false;
        }
        String partRefSecondaryId = ((IViewReference)partRef).getSecondaryId();
        String thisSecondaryId = this.getViewSite().getSecondaryId();
        return thisSecondaryId == null && partRefSecondaryId == null || thisSecondaryId != null && thisSecondaryId.equals(partRefSecondaryId);
    }

    public void saveState(IMemento memento) {
        if (this.fWorkingSetFilterUI != null) {
            this.fWorkingSetFilterUI.saveState(memento, KEY_WORKING_SET_FILTER);
        }
        memento.putString(KEY_FILTER_VARIABLES, String.valueOf(this.fFilterVariablesAction.isChecked()));
        memento.putString(KEY_SHOW_FILES, String.valueOf(this.fShowFilesInLabelsAction.isChecked()));
        super.saveState(memento);
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                CHViewPart.this.onContextMenuAboutToShow(m);
            }
        });
        Menu menu = manager.createContextMenu(this.fTreeViewer.getControl());
        this.fTreeViewer.getControl().setMenu(menu);
        IWorkbenchPartSite site = this.getSite();
        site.registerContextMenu("org.eclipse.cdt.ui.callHierarchy", manager, (ISelectionProvider)this.fTreeViewer);
    }

    private void createViewerPage() {
        Display display = this.getSite().getShell().getDisplay();
        this.fViewerPage = new Composite((Composite)this.fPagebook, 0);
        this.fViewerPage.setLayoutData((Object)new GridData(1808));
        this.fViewerPage.setSize(100, 100);
        this.fViewerPage.setLayout((Layout)new FillLayout());
        this.fProviders = CHEProviderSettings.getCCallHierarchyContentProviders();
        this.fLabelProviders = CHEProviderSettings.getCCallHierarchyLabelProviders();
        this.fContentProvider = new CHContentProvider(this, display);
        this.fLabelProvider = new CHLabelProvider(this, display, this.fContentProvider);
        this.fTreeViewer = new ExtendedTreeViewer(this.fViewerPage);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingCLabelProvider(this.fLabelProvider));
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                CHViewPart.this.onShowSelectedReference(event.getSelection());
            }
        });
        if (this.fProviders != null) {
            ICHEContentProvider[] iCHEContentProviderArray = this.fProviders;
            int n = this.fProviders.length;
            int n2 = 0;
            while (n2 < n) {
                ICHEContentProvider provider = iCHEContentProviderArray[n2];
                this.fTreeViewer.addOpenListener(provider.getCCallHierarchyOpenListener());
                ++n2;
            }
        }
    }

    private void createInfoPage() {
        this.fInfoText = new Label((Composite)this.fPagebook, 16576);
    }

    private void initDragAndDrop() {
        CHDropTargetListener dropListener = new CHDropTargetListener(this);
        Transfer[] localSelectionTransfer = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        DropTarget dropTarget = new DropTarget((Control)this.fPagebook, 23);
        dropTarget.setTransfer(localSelectionTransfer);
        dropTarget.addDropListener((DropTargetListener)dropListener);
    }

    private void createActions() {
        this.fOpenViewActionGroup = new OpenViewActionGroup((IWorkbenchPart)this);
        this.fOpenViewActionGroup.setSuppressCallHierarchy(true);
        this.fOpenViewActionGroup.setSuppressProperties(true);
        this.fOpenViewActionGroup.setEnableIncludeBrowser(true);
        this.fSelectionSearchGroup = new SelectionSearchGroup((IWorkbenchSite)this.getSite());
        this.fRefactoringActionGroup = new CRefactoringActionGroup((IWorkbenchPart)this);
        this.fWorkingSetFilterUI = new WorkingSetFilterUI((IViewPart)this, this.fMemento, KEY_WORKING_SET_FILTER){

            @Override
            protected void onWorkingSetChange() {
                CHViewPart.this.updateWorkingSetFilter(this);
            }

            @Override
            protected void onWorkingSetNameChange() {
                CHViewPart.this.updateDescription();
            }
        };
        this.fReferencedByAction = new Action(CHMessages.CHViewPart_ShowCallers_label, 8){

            public void run() {
                if (this.isChecked()) {
                    CHViewPart.this.onSetShowReferencedBy(true);
                }
            }
        };
        this.fReferencedByAction.setToolTipText(CHMessages.CHViewPart_ShowCallers_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fReferencedByAction, "lcl16/", "org.eclipse.cdt.ui.ch_callers.gif");
        this.fMakesReferenceToAction = new Action(CHMessages.CHViewPart_ShowCallees_label, 8){

            public void run() {
                if (this.isChecked()) {
                    CHViewPart.this.onSetShowReferencedBy(false);
                }
            }
        };
        this.fMakesReferenceToAction.setToolTipText(CHMessages.CHViewPart_ShowCallees_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fMakesReferenceToAction, "lcl16/", "org.eclipse.cdt.ui.ch_callees.gif");
        this.fVariableFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof CHNode) {
                    CHNode node = (CHNode)element;
                    return !node.isVariableOrEnumerator();
                }
                return true;
            }
        };
        this.fFilterVariablesAction = new Action(CHMessages.CHViewPart_FilterVariables_label, 2){

            public void run() {
                if (this.isChecked()) {
                    CHViewPart.this.fTreeViewer.addFilter(CHViewPart.this.fVariableFilter);
                } else {
                    CHViewPart.this.fTreeViewer.removeFilter(CHViewPart.this.fVariableFilter);
                }
            }
        };
        this.fFilterVariablesAction.setToolTipText(CHMessages.CHViewPart_FilterVariables_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fFilterVariablesAction, "lcl16/", "org.eclipse.cdt.ui.fields_co.gif");
        this.fSorterAlphaNumeric = new ViewerComparator();
        this.fSorterReferencePosition = new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof CHNode) {
                    return 0;
                }
                return 1;
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (!(e1 instanceof CHNode)) {
                    if (!(e2 instanceof CHNode)) {
                        return 0;
                    }
                    return -1;
                }
                if (!(e2 instanceof CHNode)) {
                    return 1;
                }
                CHNode n1 = (CHNode)e1;
                CHNode n2 = (CHNode)e2;
                int offset1 = n1.getFirstReferenceOffset();
                int offset2 = n2.getFirstReferenceOffset();
                return Integer.compare(offset1, offset2);
            }
        };
        this.fShowReference = new Action(CHMessages.CHViewPart_ShowReference_label){

            public void run() {
                CHViewPart.this.onShowSelectedReference(CHViewPart.this.fTreeViewer.getSelection());
            }
        };
        this.fShowReference.setToolTipText(CHMessages.CHViewPart_ShowReference_tooltip);
        this.fOpenElement = new Action(CHMessages.CHViewPart_Open_label){

            public void run() {
                CHViewPart.this.onOpenElement(CHViewPart.this.fTreeViewer.getSelection());
            }
        };
        this.fOpenElement.setToolTipText(CHMessages.CHViewPart_Open_tooltip);
        this.fOpenElement.setActionDefinitionId("org.eclipse.cdt.ui.edit.opendecl");
        this.fShowFilesInLabelsAction = new Action(CHMessages.CHViewPart_ShowFiles_label, 2){

            public void run() {
                CHViewPart.this.onShowFilesInLabels(this.isChecked());
            }
        };
        this.fShowFilesInLabelsAction.setToolTipText(CHMessages.CHViewPart_ShowFiles_tooltip);
        this.fNextAction = new Action(CHMessages.CHViewPart_NextReference_label){

            public void run() {
                CHViewPart.this.onNextOrPrevious(true);
            }
        };
        this.fNextAction.setToolTipText(CHMessages.CHViewPart_NextReference_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fNextAction, "lcl16/", "org.eclipse.cdt.ui.search_next.gif");
        this.fPreviousAction = new Action(CHMessages.CHViewPart_PreviousReference_label){

            public void run() {
                CHViewPart.this.onNextOrPrevious(false);
            }
        };
        this.fPreviousAction.setToolTipText(CHMessages.CHViewPart_PreviousReference_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fPreviousAction, "lcl16/", "org.eclipse.cdt.ui.search_prev.gif");
        this.fRefreshAction = new Action(CHMessages.CHViewPart_Refresh_label){

            public void run() {
                CHViewPart.this.onRefresh();
            }
        };
        this.fRefreshAction.setToolTipText(CHMessages.CHViewPart_Refresh_tooltip);
        CPluginImages.setImageDescriptors((IAction)this.fRefreshAction, "lcl16/", "org.eclipse.cdt.ui.refresh_nav.gif");
        this.fHistoryAction = new CHHistoryDropDownAction(this);
        this.fCopyAction = new CopyCallHierarchyAction(this, this.fTreeViewer);
        this.fPinViewAction = new CHPinAction(this);
        this.fRemoveFromViewAction = new CHRemoveFromView(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.fRefactoringActionGroup.fillActionBars(actionBars);
        this.fOpenViewActionGroup.fillActionBars(actionBars);
        this.fSelectionSearchGroup.fillActionBars(actionBars);
        actionBars.setGlobalActionHandler("org.eclipse.cdt.ui.actions.OpenDeclaration", (IAction)this.fOpenElement);
        actionBars.setGlobalActionHandler(ActionFactory.NEXT.getId(), (IAction)this.fNextAction);
        actionBars.setGlobalActionHandler(ActionFactory.PREVIOUS.getId(), (IAction)this.fPreviousAction);
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), (IAction)this.fRefreshAction);
        actionBars.updateActionBars();
        TextActionHandler textActionHandler = new TextActionHandler(actionBars);
        textActionHandler.setDeleteAction((IAction)this.fRemoveFromViewAction);
        IToolBarManager tm = actionBars.getToolBarManager();
        tm.add((IAction)this.fNextAction);
        tm.add((IAction)this.fPreviousAction);
        tm.add((IContributionItem)new Separator());
        tm.add((IAction)this.fFilterVariablesAction);
        tm.add((IContributionItem)new Separator());
        tm.add((IAction)this.fReferencedByAction);
        tm.add((IAction)this.fMakesReferenceToAction);
        tm.add((IAction)this.fHistoryAction);
        tm.add((IAction)this.fRefreshAction);
        tm.add((IAction)this.fPinViewAction);
        IMenuManager mm = actionBars.getMenuManager();
        this.fWorkingSetFilterUI.fillActionBars(actionBars);
        mm.add((IAction)this.fReferencedByAction);
        mm.add((IAction)this.fMakesReferenceToAction);
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)this.fShowFilesInLabelsAction);
        mm.add((IContributionItem)new Separator());
        mm.add((IAction)this.fFilterVariablesAction);
    }

    private void setNextNode(boolean forward) {
        TreeNavigator navigator = new TreeNavigator(this.fTreeViewer.getTree(), CHNode.class);
        TreeItem selectedItem = navigator.getSelectedItemOrFirstOnLevel(1, forward);
        if (selectedItem == null) {
            this.fNavigationNode = null;
            return;
        }
        if (selectedItem.getData().equals(this.fNavigationNode)) {
            if (forward && this.fNavigationDetail < this.getReferenceCount(this.fNavigationNode) - 1) {
                ++this.fNavigationDetail;
            } else if (!forward && this.fNavigationDetail > 0) {
                --this.fNavigationDetail;
            } else {
                this.fNavigationNode = (selectedItem = navigator.getNextSibbling(selectedItem, forward)) == null ? null : (CHNode)selectedItem.getData();
                this.initNavigationDetail(forward);
            }
        } else {
            this.fNavigationNode = (CHNode)selectedItem.getData();
            this.initNavigationDetail(forward);
        }
    }

    private void initNavigationDetail(boolean forward) {
        this.fNavigationDetail = !forward && this.fNavigationNode != null ? Math.max(0, this.getReferenceCount(this.fNavigationNode) - 1) : 0;
    }

    protected void onShowSelectedReference(ISelection selection) {
        CHNode node = this.selectionToNode(selection);
        this.fNavigationDetail = node != null && node == this.fNavigationNode && node.getReferenceCount() > 0 ? (this.fNavigationDetail + 1) % node.getReferenceCount() : 0;
        this.fNavigationNode = node;
        this.showReference();
    }

    protected void onOpenElement(ISelection selection) {
        CHNode node = this.selectionToNode(selection);
        this.openElement(node);
    }

    private void openElement(CHNode node) {
        ICElement elem;
        if (node != null && !node.isMultiDef() && (elem = node.getRepresentedDeclaration()) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            try {
                EditorOpener.open(page, elem);
            }
            catch (CModelException e) {
                CUIPlugin.log(e);
            }
        }
    }

    protected void onNextOrPrevious(boolean forward) {
        this.setNextNode(forward);
        if (this.fNavigationNode != null) {
            StructuredSelection sel = new StructuredSelection((Object)this.fNavigationNode);
            this.fTreeViewer.setSelection((ISelection)sel);
            this.showReference();
        }
    }

    protected void onRefresh() {
        this.fContentProvider.recompute();
    }

    protected void onShowFilesInLabels(boolean show) {
        this.fLabelProvider.setShowFiles(show);
        this.fTreeViewer.refresh();
    }

    private void updateSorter() {
        if (this.fReferencedByAction.isChecked()) {
            this.fTreeViewer.setComparator(this.fSorterAlphaNumeric);
        } else {
            this.fTreeViewer.setComparator(this.fSorterReferencePosition);
        }
    }

    private void updateDescription() {
        ICElement elem;
        String message = "";
        if (!this.fShowsMessage && (elem = this.getInput()) != null) {
            String label = CElementLabels.getElementLabel(elem, 2182113313L);
            IWorkingSet workingSet = this.fWorkingSetFilterUI.getWorkingSet();
            String scope = workingSet == null ? CHMessages.CHViewPart_WorkspaceScope : workingSet.getLabel();
            String format = this.fReferencedByAction.isChecked() ? CHMessages.CHViewPart_Title_callers : CHMessages.CHViewPart_Title_callees;
            message = Messages.format(format, label, scope);
        }
        message = TextUtil.escape((String)message, (char)'&');
        this.setContentDescription(message);
    }

    private void updateActionEnablement() {
        this.fHistoryAction.setEnabled(CallHierarchyUI.getHistoryEntries().length > 0);
        this.fNextAction.setEnabled(!this.fShowsMessage);
        this.fPreviousAction.setEnabled(!this.fShowsMessage);
        this.fRefreshAction.setEnabled(!this.fShowsMessage);
    }

    private void updateWorkingSetFilter(WorkingSetFilterUI filterUI) {
        this.fContentProvider.setWorkingSetFilter(filterUI);
    }

    public void onSetShowReferencedBy(boolean showReferencedBy) {
        if (showReferencedBy != this.fContentProvider.getComputeReferencedBy()) {
            Object input = this.fTreeViewer.getInput();
            this.fTreeViewer.setInput(null);
            this.fContentProvider.setComputeReferencedBy(showReferencedBy);
            this.updateSorter();
            this.fTreeViewer.setInput(input);
            this.updateDescription();
        }
    }

    protected void onContextMenuAboutToShow(IMenuManager menu) {
        ISelection selection;
        CUIPlugin.createStandardGroups(menu);
        CHNode node = this.selectionToNode(this.fTreeViewer.getSelection());
        if (node != null) {
            ICElement element;
            if (this.getReferenceCount(node) > 0) {
                menu.appendToGroup("group.open", (IAction)this.fShowReference);
            }
            if (!node.isMultiDef()) {
                menu.appendToGroup("group.open", (IAction)this.fOpenElement);
            }
            if (node.getParent() != null && (element = node.getRepresentedDeclaration()) != null) {
                String label = Messages.format(CHMessages.CHViewPart_FocusOn_label, CElementLabels.getTextLabel(element, 34613281L));
                menu.appendToGroup("group.open", (IAction)new Action(label){

                    public void run() {
                        CHViewPart.this.setInput(element);
                    }
                });
            }
        }
        if (OpenViewActionGroup.canActionBeAdded(selection = this.getSite().getSelectionProvider().getSelection())) {
            this.fOpenViewActionGroup.fillContextMenu(menu);
        }
        if (this.fCopyAction.canActionBeAdded()) {
            menu.appendToGroup("group.edit", (IAction)this.fCopyAction);
        }
        if (node != null) {
            menu.appendToGroup("group.edit", (IAction)this.fRemoveFromViewAction);
        }
        if (SelectionSearchGroup.canActionBeAdded(selection)) {
            this.fSelectionSearchGroup.fillContextMenu(menu);
        }
        this.fRefactoringActionGroup.fillContextMenu(menu);
    }

    private void showReference() {
        ITranslationUnit file;
        if (this.fNavigationNode != null && (file = this.fNavigationNode.getFileOfReferences()) != null) {
            IWorkbenchPage page = this.getSite().getPage();
            if (this.fNavigationNode.getReferenceCount() > 0) {
                long timestamp = this.fNavigationNode.getTimestamp();
                if (this.fNavigationDetail < 0) {
                    this.fNavigationDetail = 0;
                } else if (this.fNavigationDetail >= this.fNavigationNode.getReferenceCount() - 1) {
                    this.fNavigationDetail = this.fNavigationNode.getReferenceCount() - 1;
                }
                CHReferenceInfo ref = this.fNavigationNode.getReference(this.fNavigationDetail);
                Region region = new Region(ref.getOffset(), ref.getLength());
                EditorOpener.open(page, file, region, timestamp);
            } else {
                try {
                    EditorOpener.open(page, this.fNavigationNode.getRepresentedDeclaration());
                }
                catch (CModelException e) {
                    CUIPlugin.log(e);
                }
            }
        }
    }

    private int getReferenceCount(CHNode node) {
        if (node != null) {
            CHNode parent = node.getParent();
            if (parent instanceof CHMultiDefNode) {
                return parent.getReferenceCount();
            }
            return node.getReferenceCount();
        }
        return 0;
    }

    private CHNode selectionToNode(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            for (Object cand : ss) {
                if (!(cand instanceof CHNode)) continue;
                return (CHNode)cand;
            }
        }
        return null;
    }

    public Control getPageBook() {
        return this.fPagebook;
    }

    public ICElement getInput() {
        Object input = this.fTreeViewer.getInput();
        if (input instanceof ICElement) {
            return (ICElement)input;
        }
        return null;
    }

    public TreeViewer getTreeViewer() {
        return this.fTreeViewer;
    }

    void setPinned(boolean pinned) {
        this.fIsPinned = pinned;
    }

    boolean isPinned() {
        return this.fIsPinned;
    }

    public ICHEContentProvider[] getContentProviders() {
        return this.fProviders;
    }

    public DelegatingStyledCellLabelProvider.IStyledLabelProvider[] getLabelProviders() {
        return this.fLabelProviders;
    }

    private static class CopyCallHierarchyAction
    extends CopyTreeAction {
        public CopyCallHierarchyAction(ViewPart view, TreeViewer viewer) {
            super(CHMessages.CHViewPart_CopyCallHierarchy_label, view, viewer);
        }
    }
}

