/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class WorkInProgressPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private final List<Button> fCheckBoxes;
    private final List<Button> fRadioButtons;
    private final List<Text> fTextControls;

    public WorkInProgressPreferencePage() {
        this.setPreferenceStore(this.getPreferenceStore());
        this.fRadioButtons = new ArrayList<Button>();
        this.fCheckBoxes = new ArrayList<Button>();
        this.fTextControls = new ArrayList<Text>();
    }

    Button addCheckBox(Composite parent, String label, String key) {
        GridData gd = new GridData(256);
        Button button = new Button(parent, 32);
        button.setText(label);
        button.setData((Object)key);
        button.setLayoutData((Object)gd);
        button.setSelection(this.getPreferenceStore().getBoolean(key));
        this.fCheckBoxes.add(button);
        return button;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "WORK_IN_PROGRESS_PREFERENCE_PAGE");
    }

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = 0;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(10);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        result.setLayout((Layout)layout);
        this.applyDialogFont(result);
        return result;
    }

    public void init(IWorkbench workbench) {
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return CUIPlugin.getDefault().getPreferenceStore();
    }

    protected void performDefaults() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = this.fCheckBoxes.get(i);
            key = (String)button.getData();
            button.setSelection(store.getDefaultBoolean(key));
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = this.fRadioButtons.get(i);
            String[] info = (String[])button.getData();
            button.setSelection(info[1].equals(store.getDefaultString(info[0])));
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = this.fTextControls.get(i);
            key = (String)text.getData();
            text.setText(store.getDefaultString(key));
            ++i;
        }
        super.performDefaults();
    }

    public boolean performOk() {
        String key;
        Button button;
        IPreferenceStore store = this.getPreferenceStore();
        int i = 0;
        while (i < this.fCheckBoxes.size()) {
            button = this.fCheckBoxes.get(i);
            key = (String)button.getData();
            store.setValue(key, button.getSelection());
            ++i;
        }
        i = 0;
        while (i < this.fRadioButtons.size()) {
            button = this.fRadioButtons.get(i);
            if (button.getSelection()) {
                String[] info = (String[])button.getData();
                store.setValue(info[0], info[1]);
            }
            ++i;
        }
        i = 0;
        while (i < this.fTextControls.size()) {
            Text text = this.fTextControls.get(i);
            key = (String)text.getData();
            store.setValue(key, text.getText());
            ++i;
        }
        return super.performOk();
    }

    public static void initDefaults(IPreferenceStore store) {
    }
}

