/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.dialogs.IDialogSettings;

public class CRenameRefactoringPreferences {
    private static final String DIALOG_SETTINGS_KEY = "CRenameRefactoringInputPage";
    public static final String KEY_IGNORE_VIRTUAL = "ignoreVirtual";
    public static final String KEY_REFERENCES_INV = "references_inv";
    public static final String KEY_COMMENT = "comment";
    public static final String KEY_STRING = "string";
    public static final String KEY_INACTIVE = "inactive";
    public static final String KEY_SCOPE = "scope";
    public static final String KEY_WORKING_SET_NAME = "workingset";
    public static final String KEY_INCLUDE = "include";
    public static final String KEY_MACRO_DEFINITION = "macroDefinition";
    public static final String KEY_PREPROCESSOR = "preprocessor";
    public static final String KEY_EXHAUSTIVE_FILE_SEARCH = "exhausiveFileSearch";
    private IDialogSettings fDialogSettings;

    public CRenameRefactoringPreferences() {
        IDialogSettings ds = CUIPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = ds.getSection(DIALOG_SETTINGS_KEY);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = ds.addNewSection(DIALOG_SETTINGS_KEY);
        }
    }

    public boolean getBoolean(String key) {
        return this.fDialogSettings.getBoolean(key);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        String value = this.fDialogSettings.get(key);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    public void put(String key, int value) {
        this.fDialogSettings.put(key, value);
    }

    public void put(String key, String value) {
        this.fDialogSettings.put(key, value);
    }

    public void put(String key, boolean value) {
        this.fDialogSettings.put(key, value);
    }

    public int getScope() {
        try {
            return this.fDialogSettings.getInt(KEY_SCOPE);
        }
        catch (Exception e) {
            return 3;
        }
    }

    public String getWorkingSet() {
        return this.fDialogSettings.get(KEY_WORKING_SET_NAME);
    }

    public int getOptions() {
        int options = 0;
        if (!this.getBoolean(KEY_IGNORE_VIRTUAL)) {
            options |= 0x80;
        }
        if (!this.getBoolean(KEY_REFERENCES_INV)) {
            options |= 1;
        }
        if (this.getBoolean(KEY_INACTIVE)) {
            options |= 2;
        }
        if (this.getBoolean(KEY_COMMENT)) {
            options |= 4;
        }
        if (this.getBoolean(KEY_STRING)) {
            options |= 8;
        }
        if (this.getBoolean(KEY_INCLUDE)) {
            options |= 0x10;
        }
        if (this.getBoolean(KEY_MACRO_DEFINITION)) {
            options |= 0x20;
        }
        if (this.getBoolean(KEY_PREPROCESSOR)) {
            options |= 0x40;
        }
        if (this.getBoolean(KEY_EXHAUSTIVE_FILE_SEARCH)) {
            options |= 0x100;
        }
        return options;
    }
}

