/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.pdom;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.dom.IPDOMNode;
import org.eclipse.cdt.core.dom.IPDOMVisitor;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNamedNode;
import org.eclipse.core.runtime.CoreException;

public abstract class QtPDOMVisitor
implements IPDOMVisitor {
    public void leave(IPDOMNode node) throws CoreException {
    }

    public static class All<T>
    extends QtPDOMVisitor {
        private final Class<T> cls;
        public final ArrayList<T> list = new ArrayList();

        public All(Class<T> cls) {
            this.cls = cls;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (node != null && this.cls.isAssignableFrom(node.getClass())) {
                this.list.add(node);
            }
            return true;
        }
    }

    public static class Find<T>
    extends QtPDOMVisitor {
        private final Class<T> cls;
        private final IFilter filter;
        public T element;

        public Find(Class<T> cls, IFilter filter) {
            this.cls = cls;
            this.filter = filter;
        }

        public boolean visit(IPDOMNode node) throws CoreException {
            if (this.element != null) {
                return false;
            }
            if (this.cls.isAssignableFrom(node.getClass()) && this.filter.matches(node)) {
                this.element = node;
            }
            return this.element == null;
        }
    }

    public static interface IFilter {
        public boolean matches(IPDOMNode var1) throws CoreException;
    }

    public static class PDOMNamedNodeFilter
    implements IFilter {
        private final char[] name;

        public PDOMNamedNodeFilter(String name) {
            this.name = name.toCharArray();
        }

        @Override
        public boolean matches(IPDOMNode node) throws CoreException {
            if (node instanceof PDOMNamedNode) {
                return Arrays.equals(this.name, ((PDOMNamedNode)node).getNameCharArray());
            }
            return false;
        }
    }
}

