/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.utils.envvar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.envvar.EnvironmentVariable;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;

public class EnvVarOperationProcessor {
    public static IEnvironmentVariable performOperation(IEnvironmentVariable initial, IEnvironmentVariable added) {
        if (initial == null) {
            return added;
        }
        if (added == null) {
            return initial;
        }
        String name = added.getName();
        switch (added.getOperation()) {
            case 2: {
                return new EnvironmentVariable(name, null, 2, null);
            }
            case 4: {
                String delimiter = added.getDelimiter();
                return new EnvironmentVariable(name, EnvVarOperationProcessor.performAppend(initial.getValue(), added.getValue(), delimiter), initial.getOperation() == 4 ? 4 : 1, delimiter);
            }
            case 3: {
                String delimiter = added.getDelimiter();
                return new EnvironmentVariable(name, EnvVarOperationProcessor.performPrepend(initial.getValue(), added.getValue(), delimiter), initial.getOperation() == 3 ? 3 : 1, delimiter);
            }
        }
        return new EnvironmentVariable(added.getName(), added.getValue(), added.getDelimiter());
    }

    public static String performAppendPrepend(String initialValue, String addValue, String delimiter, boolean prepend) {
        if (initialValue == null) {
            return addValue;
        }
        if (addValue == null) {
            return initialValue;
        }
        if (delimiter == null || delimiter.isEmpty()) {
            return prepend ? String.valueOf(addValue) + initialValue : String.valueOf(initialValue) + addValue;
        }
        List<String> value = EnvVarOperationProcessor.convertToList(initialValue, delimiter);
        List<String> added = EnvVarOperationProcessor.convertToList(addValue, delimiter);
        value = EnvVarOperationProcessor.removeDuplicates(value, added);
        if (prepend) {
            value.addAll(0, added);
        } else {
            value.addAll(added);
        }
        return EnvVarOperationProcessor.convertToString(value, delimiter);
    }

    public static String performAppend(String initialValue, String addValue, String delimiter) {
        return EnvVarOperationProcessor.performAppendPrepend(initialValue, addValue, delimiter, false);
    }

    public static String performPrepend(String initialValue, String addValue, String delimiter) {
        return EnvVarOperationProcessor.performAppendPrepend(initialValue, addValue, delimiter, true);
    }

    public static String performOperation(String initialValue, String newValue, String delimiter, int op) {
        switch (op) {
            case 2: {
                return null;
            }
            case 3: {
                return EnvVarOperationProcessor.performPrepend(initialValue, newValue, delimiter);
            }
            case 4: {
                return EnvVarOperationProcessor.performAppend(initialValue, newValue, delimiter);
            }
        }
        return initialValue;
    }

    public static List<String> convertToList(String value, String delimiter) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int delLength = delimiter.length();
        int valLength = value.length();
        if (delLength == 0) {
            list.add(value);
        } else {
            int start = 0;
            while (start < valLength) {
                int stop = value.indexOf(delimiter, start);
                if (stop == -1) {
                    stop = valLength;
                }
                String subst = value.substring(start, stop);
                list.add(subst);
                start = stop + delLength;
            }
        }
        return list;
    }

    public static List<String> removeDuplicates(List<String> value, List<String> duplicates) {
        ArrayList<String> list = new ArrayList<String>();
        for (String curVal : value) {
            boolean duplFound = false;
            for (String curDupl : duplicates) {
                if (!curVal.equals(curDupl)) continue;
                duplFound = true;
                break;
            }
            if (duplFound) continue;
            list.add(curVal);
        }
        return list;
    }

    public static String convertToString(List<String> list, String delimiter) {
        Iterator<String> iter = list.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    public static String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        if ("".equals(name = name.trim())) {
            return null;
        }
        return name;
    }

    public static IEnvironmentVariable[] filterVariables(IEnvironmentVariable[] variables, String[] remove) {
        if (variables == null || variables.length == 0) {
            return variables;
        }
        IEnvironmentVariable[] filtered = new IEnvironmentVariable[variables.length];
        int filteredNum = 0;
        IEnvironmentVariable[] iEnvironmentVariableArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            IEnvironmentVariable var = iEnvironmentVariableArray[n2];
            String name = null;
            if (var != null && (name = EnvVarOperationProcessor.normalizeName(var.getName())) != null) {
                boolean skip = false;
                if (remove != null && remove.length > 0) {
                    String[] stringArray = remove;
                    int n3 = remove.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String element = stringArray[n4];
                        if (element != null && element.equals(name)) {
                            skip = true;
                            break;
                        }
                        ++n4;
                    }
                }
                if (!skip) {
                    filtered[filteredNum++] = var;
                }
            }
            ++n2;
        }
        if (filteredNum != filtered.length) {
            IEnvironmentVariable[] vars = new IEnvironmentVariable[filteredNum];
            int i = 0;
            while (i < filteredNum) {
                vars[i] = filtered[i];
                ++i;
            }
            filtered = vars;
        }
        return filtered;
    }
}

