/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.core.workspace;

import java.util.Optional;
import java.util.function.Predicate;
import org.eclipse.cdt.lsp.core.preferences.LanguageServerPreferenceMetadata;
import org.eclipse.cdt.lsp.internal.core.preferences.LanguageServerDefaults;
import org.eclipse.cdt.lsp.internal.core.workspace.ResolveDocumentFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.PreferenceMetadata;
import org.eclipse.jface.text.IDocument;

public final class PreferLanguageServer
implements Predicate<IDocument> {
    private final ResolveDocumentFile file = new ResolveDocumentFile();
    private final LanguageServerPreferenceMetadata metadata = new LanguageServerDefaults();

    @Override
    public boolean test(IDocument document) {
        Optional<IProject> project = this.file.apply(document).map(IResource::getProject);
        if (project.isPresent()) {
            return this.forProject(project.get());
        }
        return this.forExternal(document);
    }

    private boolean forExternal(IDocument document) {
        PreferenceMetadata<Boolean> option = this.metadata.preferLanguageServer();
        return Platform.getPreferencesService().getBoolean("org.eclipse.cdt.lsp.core", option.identifer(), ((Boolean)option.defaultValue()).booleanValue(), null);
    }

    private boolean forProject(IProject project) {
        PreferenceMetadata<Boolean> option = this.metadata.preferLanguageServer();
        return Platform.getPreferencesService().getBoolean("org.eclipse.cdt.lsp.core", option.identifer(), ((Boolean)option.defaultValue()).booleanValue(), new IScopeContext[]{new ProjectScope(project)});
    }
}

