/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.dialogs.cpaths;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IPathEntry;
import org.eclipse.cdt.core.model.IPathEntryContainer;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElement;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementAttribute;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPElementGroup;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPListImageDescriptor;
import org.eclipse.cdt.internal.ui.dialogs.cpaths.CPathEntryMessages;
import org.eclipse.cdt.internal.ui.util.ImageDescriptorRegistry;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.IWorkbenchAdapter;

class CPElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Color inDirect = new Color((Device)Display.getDefault(), new RGB(170, 170, 170));
    private String fNewLabel = CPathEntryMessages.CPElementLabelProvider_new;
    private String fCreateLabel = CPathEntryMessages.CPElementLabelProvider_willbecreated;
    private ImageDescriptor fIncludeIcon;
    private ImageDescriptor fMacroIcon;
    private ImageDescriptor fLibWSrcIcon;
    private ImageDescriptor fLibIcon;
    private ImageDescriptor fQuoteIncludeIcon;
    private ImageDescriptor fIncludeFileIcon;
    private ImageDescriptor fMacrosFileIcon;
    private ImageDescriptor fFolderImage;
    private ImageDescriptor fOutputImage;
    private ImageDescriptor fProjectImage;
    private ImageDescriptor fContainerImage;
    private boolean bShowExported;
    private boolean bShowParentInfo;
    private ImageDescriptorRegistry fRegistry = CUIPlugin.getImageDescriptorRegistry();
    private static final Point SMALL_SIZE = new Point(16, 16);

    public CPElementLabelProvider() {
        this(true, false);
    }

    public CPElementLabelProvider(boolean showExported, boolean showParentInfo) {
        this.fLibIcon = CDTSharedImages.getImageDescriptor("icons/obj16/ar_obj.gif");
        this.fLibWSrcIcon = CDTSharedImages.getImageDescriptor("icons/obj16/ar_obj.gif");
        this.fIncludeIcon = CDTSharedImages.getImageDescriptor("icons/obj16/hfolder_obj.gif");
        this.fQuoteIncludeIcon = CDTSharedImages.getImageDescriptor("icons/obj16/hfolder_quote_obj.gif");
        this.fIncludeFileIcon = CDTSharedImages.getImageDescriptor("icons/obj16/h_file_obj.gif");
        this.fMacroIcon = CDTSharedImages.getImageDescriptor("icons/obj16/define_obj.gif");
        this.fMacrosFileIcon = CDTSharedImages.getImageDescriptor("icons/obj16/h_file_obj.gif");
        this.fFolderImage = CDTSharedImages.getImageDescriptor("icons/obj16/sroot_obj.gif");
        this.fOutputImage = CDTSharedImages.getImageDescriptor("icons/obj16/container_obj.gif");
        this.fContainerImage = CDTSharedImages.getImageDescriptor("icons/obj16/lib_obj.gif");
        IWorkbench workbench = PlatformUI.getWorkbench();
        this.fProjectImage = workbench.getSharedImages().getImageDescriptor("IMG_OBJ_PROJECT");
        this.bShowExported = showExported;
        this.bShowParentInfo = showParentInfo;
    }

    public void dispose() {
        this.inDirect.dispose();
        this.inDirect = null;
        super.dispose();
    }

    public String getText(Object element) {
        if (element instanceof CPElement) {
            return this.getCPElementText((CPElement)element);
        }
        if (element instanceof CPElementAttribute) {
            return this.getCPElementAttributeText((CPElementAttribute)element);
        }
        if (element instanceof IPathEntry) {
            return this.getCPElementText(CPElement.createFromExisting((IPathEntry)element, null));
        }
        if (element instanceof CPElementGroup) {
            return this.getCPContainerGroupText((CPElementGroup)element);
        }
        return super.getText(element);
    }

    private String getCPContainerGroupText(CPElementGroup group) {
        switch (group.getEntryKind()) {
            case 16: {
                return CPathEntryMessages.CPElementLabelProvider_Includes;
            }
            case 256: {
                return CPathEntryMessages.CPElementLabelProvider_IncludeFiles;
            }
            case 64: {
                return CPathEntryMessages.CPElementLabelProvider_PreprocessorSymbols;
            }
            case 512: {
                return CPathEntryMessages.CPElementLabelProvider_MacrosFiles;
            }
            case 1: {
                return CPathEntryMessages.CPElementLabelProvider_Libraries;
            }
            case -1: {
                if (group.getResource().getType() == 4) {
                    return group.getResource().getName();
                }
                StringBuilder label = new StringBuilder(group.getResource().getProjectRelativePath().toString());
                if (!group.getResource().exists()) {
                    label.append(this.fCreateLabel);
                }
                return label.toString();
            }
        }
        return "";
    }

    public String getCPElementAttributeText(CPElementAttribute attrib) {
        IPath path;
        String notAvailable = CPathEntryMessages.CPElementLabelProvider_none;
        StringBuilder buf = new StringBuilder();
        String key = attrib.getKey();
        if (key.equals("sourcepath")) {
            buf.append(CPathEntryMessages.CPElementLabelProvider_source_attachment_label);
            path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                buf.append(this.getPathString(path, path.getDevice() != null));
            } else {
                buf.append(notAvailable);
            }
        } else if (key.equals("rootpath")) {
            buf.append(CPathEntryMessages.CPElementLabelProvider_source_attachment_root_label);
            path = (IPath)attrib.getValue();
            if (path != null && !path.isEmpty()) {
                buf.append(path.toString());
            } else {
                buf.append(notAvailable);
            }
        }
        if (key.equals("exclusion")) {
            buf.append(CPathEntryMessages.CPElementLabelProvider_exclusion_filter_label);
            IPath[] patterns = (IPath[])attrib.getValue();
            if (patterns != null && patterns.length > 0) {
                int i = 0;
                while (i < patterns.length) {
                    if (i > 0) {
                        buf.append(CPathEntryMessages.CPElementLabelProvider_exclusion_filter_separator);
                    }
                    buf.append(patterns[i].toString());
                    ++i;
                }
            } else {
                buf.append(notAvailable);
            }
        }
        return buf.toString();
    }

    public String getCPElementText(CPElement cpentry) {
        IPath path = cpentry.getPath();
        switch (cpentry.getEntryKind()) {
            case 1: {
                IPath libPath = (IPath)cpentry.getAttribute("librarypath");
                StringBuilder str = new StringBuilder();
                this.addBaseString(libPath, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 4: {
                return path.lastSegment();
            }
            case 16: {
                IPath incPath = (IPath)cpentry.getAttribute("includepath");
                StringBuilder str = new StringBuilder();
                this.addBaseString(incPath, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 256: {
                IPath incFilePath = (IPath)cpentry.getAttribute("includefile");
                StringBuilder str = new StringBuilder();
                this.addBaseString(incFilePath, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 64: {
                StringBuilder str = new StringBuilder(String.valueOf((String)cpentry.getAttribute("macroname")) + "=" + (String)cpentry.getAttribute("macrovalue"));
                this.addBaseString(null, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 512: {
                IPath macroFilePath = (IPath)cpentry.getAttribute("macrosfile");
                StringBuilder str = new StringBuilder();
                this.addBaseString(macroFilePath, cpentry, str);
                this.addExport(cpentry, str);
                this.addParentInfo(cpentry, str);
                return str.toString();
            }
            case 32: {
                StringBuilder str = new StringBuilder(path.toString());
                try {
                    IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)cpentry.getPath(), (ICProject)cpentry.getCProject());
                    if (container != null) {
                        str.setLength(0);
                        str.append(container.getDescription());
                    }
                }
                catch (CModelException container) {
                    // empty catch block
                }
                this.addExport(cpentry, str);
                return str.toString();
            }
            case 8: 
            case 128: {
                StringBuilder buf = new StringBuilder(path.makeRelative().toString());
                IResource resource = cpentry.getResource();
                if (resource != null && !resource.exists()) {
                    buf.append(' ');
                    if (cpentry.getStatus().getSeverity() != 0) {
                        buf.append(this.fCreateLabel);
                    } else {
                        buf.append(this.fNewLabel);
                    }
                }
                return buf.toString();
            }
        }
        return CPathEntryMessages.CPElementLabelProvider_unknown_element_label;
    }

    private void addParentInfo(CPElement cpentry, StringBuilder str) {
        CPElement parent;
        if (this.bShowParentInfo && (parent = cpentry.getParentContainer()) != null) {
            str.append(" [");
            try {
                IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)cpentry.getPath(), (ICProject)cpentry.getCProject());
                if (container != null) {
                    str.append(container.getDescription());
                }
            }
            catch (CModelException e) {
                str.append(parent.getPath());
            }
            str.append(']');
        }
    }

    private void addExport(CPElement cpentry, StringBuilder str) {
        if (this.bShowExported && cpentry.isExported()) {
            str.append(' ');
            str.append(CPathEntryMessages.CPElementLabelProvider_export_label);
        }
    }

    private void addBaseString(IPath endPath, CPElement cpentry, StringBuilder str) {
        IPath baseRef = (IPath)cpentry.getAttribute("base-ref");
        if (!baseRef.isEmpty()) {
            if (baseRef.isAbsolute()) {
                IPath path = baseRef;
                if (endPath != null) {
                    path = path.append(endPath);
                }
                str.append(path.makeRelative().toOSString());
            } else {
                if (endPath != null) {
                    str.append(endPath.toOSString());
                }
                str.append(" - (");
                try {
                    IPathEntryContainer container = CoreModel.getPathEntryContainer((IPath)baseRef, (ICProject)cpentry.getCProject());
                    if (container != null) {
                        str.append(container.getDescription());
                    }
                }
                catch (CModelException cModelException) {
                    // empty catch block
                }
                str.append(')');
            }
        } else {
            IPath path = (IPath)cpentry.getAttribute("base-path");
            if (!path.isEmpty()) {
                if (endPath != null) {
                    path = path.append(endPath);
                }
                str.insert(0, path.toOSString());
            } else if (endPath != null) {
                str.insert(0, endPath.toOSString());
            }
        }
    }

    private String getPathString(IPath path, boolean isExternal) {
        return isExternal ? path.toOSString() : path.makeRelative().toString();
    }

    private ImageDescriptor getCPElementBaseImage(CPElement cpentry) {
        switch (cpentry.getEntryKind()) {
            case 128: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fOutputImage;
            }
            case 8: {
                if (cpentry.getPath().segmentCount() == 1) {
                    return this.fProjectImage;
                }
                return this.fFolderImage;
            }
            case 1: {
                IPath path = (IPath)cpentry.getAttribute("sourcepath");
                if (path == null || path.isEmpty()) {
                    return this.fLibIcon;
                }
                return this.fLibWSrcIcon;
            }
            case 4: {
                return this.fProjectImage;
            }
            case 32: {
                return this.fContainerImage;
            }
            case 16: {
                if (((Boolean)cpentry.getAttribute("systeminclude")).booleanValue()) {
                    return this.fIncludeIcon;
                }
                return this.fQuoteIncludeIcon;
            }
            case 256: {
                return this.fIncludeFileIcon;
            }
            case 64: {
                return this.fMacroIcon;
            }
            case 512: {
                return this.fMacrosFileIcon;
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPElement) {
            CPElement cpentry = (CPElement)element;
            Object imageDescriptor = this.getCPElementBaseImage(cpentry);
            if (imageDescriptor != null) {
                switch (cpentry.getStatus().getSeverity()) {
                    case 2: {
                        imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 1, SMALL_SIZE);
                        break;
                    }
                    case 4: {
                        imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 2, SMALL_SIZE);
                    }
                }
                if (cpentry.getInherited() != null) {
                    imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 4, SMALL_SIZE);
                }
                return this.fRegistry.get((ImageDescriptor)imageDescriptor);
            }
        } else if (element instanceof CPElementAttribute) {
            String key = ((CPElementAttribute)element).getKey();
            if (key.equals("sourcepath")) {
                return this.fRegistry.get(CDTSharedImages.getImageDescriptor("icons/obj16/source_attach_attrib.gif"));
            }
            if (key.equals("exclusion")) {
                return CDTSharedImages.getImage("icons/obj16/exclusion_filter_attrib.gif");
            }
        } else {
            if (element instanceof IPathEntry) {
                return this.getImage(CPElement.createFromExisting((IPathEntry)element, null));
            }
            if (element instanceof CPElementGroup) {
                switch (((CPElementGroup)element).getEntryKind()) {
                    case 16: {
                        return CDTSharedImages.getImage("icons/obj16/includes_container.gif");
                    }
                    case 64: {
                        return this.fRegistry.get(this.fMacroIcon);
                    }
                    case 256: 
                    case 512: {
                        return CDTSharedImages.getImage("icons/obj16/include_obj.gif");
                    }
                    case 1: {
                        return CDTSharedImages.getImage("icons/obj16/lib_obj.gif");
                    }
                    case -1: {
                        IResource res = ((CPElementGroup)element).getResource();
                        IWorkbenchAdapter adapter = (IWorkbenchAdapter)res.getAdapter(IWorkbenchAdapter.class);
                        Object imageDescriptor = adapter.getImageDescriptor((Object)res);
                        if (!res.exists()) {
                            imageDescriptor = new CPListImageDescriptor((ImageDescriptor)imageDescriptor, 1, SMALL_SIZE);
                        }
                        return this.fRegistry.get((ImageDescriptor)imageDescriptor);
                    }
                }
            }
        }
        return null;
    }

    public Color getForeground(Object element) {
        if (element instanceof CPElement && ((CPElement)element).getInherited() != null) {
            return this.inDirect;
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

