/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.core;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4j.DidChangeWatchedFilesParams;
import org.eclipse.lsp4j.FileChangeType;
import org.eclipse.lsp4j.FileEvent;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.osgi.util.NLS;

final class CPPResourceChangeListener
implements IResourceChangeListener {
    private final IProject fProject;

    CPPResourceChangeListener(IProject project) {
        this.fProject = project;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        LanguageServersRegistry.LanguageServerDefinition definition = LanguageServersRegistry.getInstance().getDefinition("org.eclipse.cdt.lsp.core");
        LanguageServerWrapper wrapper = this.getLanguageSeverWrapper(definition);
        if (event.getType() != 1 || !CPPResourceChangeListener.isRelevantDelta(event.getDelta()) || wrapper == null) {
            return;
        }
        CPPResourceChangeListener.sendFileEvents(wrapper, CPPResourceChangeListener.createFileEventsFromResourceEvent(event));
    }

    private static void sendFileEvents(LanguageServerWrapper wrapper, List<FileEvent> fileEvents) {
        if (!fileEvents.isEmpty()) {
            DidChangeWatchedFilesParams params = new DidChangeWatchedFilesParams(fileEvents);
            ((LanguageServer)wrapper.getInitializedServer().join()).getWorkspaceService().didChangeWatchedFiles(params);
        }
    }

    private static List<FileEvent> createFileEventsFromResourceEvent(IResourceChangeEvent event) {
        ArrayList<FileEvent> fileEvents = new ArrayList<FileEvent>();
        try {
            event.getDelta().accept(delta -> {
                FileEvent fileEvent;
                if (delta.getResource() instanceof IFile && CPPResourceChangeListener.isRelevantDelta(delta) && (fileEvent = CPPResourceChangeListener.createFileEventFromDelta(delta)) != null) {
                    fileEvents.add(fileEvent);
                }
                return true;
            }, false);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return fileEvents;
    }

    private LanguageServerWrapper getLanguageSeverWrapper(LanguageServersRegistry.LanguageServerDefinition definition) {
        try {
            return LanguageServiceAccessor.getLSWrapperForConnection((IProject)this.fProject, (LanguageServersRegistry.LanguageServerDefinition)definition);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static boolean isRelevantDelta(IResourceDelta delta) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (delta.getResource() instanceof IFile && kind == 4) {
            return (flags & 0x100) != 0;
        }
        return kind == 1 || kind == 4 || kind == 2;
    }

    private static FileEvent createFileEventFromDelta(IResourceDelta delta) {
        URI locationURI = delta.getResource().getLocationURI();
        if (locationURI == null) {
            return null;
        }
        FileChangeType changeType = null;
        if (delta.getKind() == 1) {
            changeType = FileChangeType.Created;
        } else if (delta.getKind() == 4) {
            changeType = FileChangeType.Changed;
        } else if (delta.getKind() == 2) {
            changeType = FileChangeType.Deleted;
        } else {
            throw new IllegalStateException(NLS.bind((String)"Unsupported resource delta kind: {0}", (Object)delta.getKind()));
        }
        return new FileEvent(locationURI.toString(), changeType);
    }
}

