/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class ContainerLaunchUtils {
    public static final String toDockerPath(IPath path) {
        String pathstring = path.toPortableString();
        if (path.getDevice() != null && pathstring.charAt(0) != '/') {
            pathstring = String.valueOf('/') + pathstring;
        }
        return ContainerLaunchUtils.toDockerPath(pathstring);
    }

    public static final String toDockerPath(String path) {
        if (Platform.getOS().equals("win32")) {
            path = path.replace(':', '/');
            path = path.replace("//WSL$/", "/WSL/");
        }
        return path;
    }

    public static final String toDockerVolume(IPath path) {
        IPath p = path.makeAbsolute();
        String rv = ContainerLaunchUtils.toDockerPath(p);
        rv = String.valueOf(rv) + ":HOST_FILE_SYSTEM:";
        rv = String.valueOf(rv) + p.toOSString();
        rv = String.valueOf(rv) + ":false:true";
        return rv;
    }
}

