/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.autotools.core;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.autotools.core.internal.Activator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class AutotoolsBuildConfiguration
extends CBuildConfiguration {
    public static final String AUTOTOOLS_GENERATOR = "autotools.generator";
    public static final String AUTOTOOLS_ARGUMENTS = "autotools.arguments";
    public static final String BUILD_COMMAND = "autotools.command.build";
    public static final String CLEAN_COMMAND = "autotools.command.clean";

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
    }

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain) {
        super(config, name, toolChain, "run");
    }

    public AutotoolsBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, String launchMode) {
        super(config, name, toolChain, launchMode);
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.execute(Arrays.asList("autoreconf", "--install"), project.getLocation(), console, monitor);
        this.executeRemote(Arrays.asList("./configure"), project.getLocation(), console, monitor);
        this.executeRemote(Arrays.asList("make"), project.getLocation(), console, monitor);
        return new IProject[]{project};
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        this.executeRemote(Arrays.asList("make", "clean"), this.getProject().getLocation(), console, monitor);
    }

    protected void execute(List<String> command, IPath dir, IConsole console, IProgressMonitor monitor) throws CoreException {
        String cmd = command.get(0);
        if (Platform.getOS().equals("win32") && (!cmd.endsWith(".exe") || cmd.endsWith(".bat"))) {
            java.nio.file.Path shPath = this.findCommand("sh");
            if (shPath != null) {
                ArrayList<String> shCommand = new ArrayList<String>();
                shCommand.add(shPath.toString());
                shCommand.add("-c");
                shCommand.add("\"" + String.join((CharSequence)" ", command) + "\"");
                command = shCommand;
            }
        } else {
            java.nio.file.Path cmdPath = this.findCommand(cmd);
            if (cmdPath != null) {
                cmd = cmdPath.toString();
                command.set(0, cmd);
            }
        }
        ProcessBuilder builder = new ProcessBuilder(command).directory(dir.toFile());
        this.setBuildEnvironment(builder.environment());
        try {
            Process process = builder.start();
            this.watchProcess(process, console);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus("Error executing: " + String.join((CharSequence)" ", command), e));
        }
        this.getProject().refreshLocal(2, monitor);
    }

    protected void executeRemote(List<String> command, IPath dir, IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            java.nio.file.Path cmdPath;
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream outStream = console.getOutputStream();
            java.nio.file.Path buildDir = this.getBuildDirectory();
            String cmd = command.get(0);
            if (cmd.startsWith(".") && (cmdPath = Paths.get(dir.toString(), cmd)).toFile().exists()) {
                command.set(0, cmdPath.toAbsolutePath().toString());
            }
            outStream.write("Building in: " + buildDir.toString() + "\n");
            Throwable throwable = null;
            Object var10_12 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                epm.setOutputStream((OutputStream)console.getOutputStream());
                IEnvironmentVariable[] env = new IEnvironmentVariable[]{};
                Path workingDir = new Path(this.getBuildDirectory().toString());
                Process p = this.startBuildProcess(command, env, (IPath)workingDir, console, monitor);
                if (p == null) {
                    console.getErrorStream().write(String.format("Error executing: {0}", String.join((CharSequence)" ", command)));
                    throw new CoreException(Activator.errorStatus("Error executing: " + String.join((CharSequence)" ", command), null));
                }
                this.watchProcess(p, new IConsoleParser[]{epm});
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException(Activator.errorStatus("Error executing: " + String.join((CharSequence)" ", command), e));
        }
    }
}

