/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.lsp.LanguageServerConfiguration;
import org.eclipse.cdt.lsp.core.Activator;
import org.eclipse.cdt.lsp.core.CPPResourceChangeListener;
import org.eclipse.cdt.lsp.internal.core.ResolvePreferredServer;
import org.eclipse.cdt.utils.CommandLineUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;

public class CPPStreamConnectionProvider
extends ProcessStreamConnectionProvider {
    public static final String ID = "org.eclipse.cdt.lsp.core";
    private IResourceChangeListener fResourceListener;
    private static final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private final LanguageServerConfiguration configuration = new ResolvePreferredServer().apply(((Object)((Object)this)).getClass());

    public CPPStreamConnectionProvider() throws UnsupportedOperationException {
        File defaultLSLocation = CPPStreamConnectionProvider.getDefaultLSLocation(this.configuration.identifier());
        if (defaultLSLocation != null) {
            store.setDefault("org.eclipse.cdt.lsp.serverPathPreference", defaultLSLocation.getAbsolutePath());
        }
        File languageServerLocation = CPPStreamConnectionProvider.getLanguageServerLocation();
        String parent = "";
        String flags = store.getString("org.eclipse.cdt.lsp.serverOptionsPreference");
        ArrayList<String> commands = new ArrayList<String>();
        if (languageServerLocation != null) {
            commands.add(languageServerLocation.getAbsolutePath());
            if (!flags.isEmpty()) {
                commands.addAll(Arrays.asList(CommandLineUtil.argumentsToArray((String)flags)));
            }
            parent = languageServerLocation.getParent();
        }
        this.setWorkingDirectory(parent);
        this.setCommands(commands);
    }

    public void stop() {
        super.stop();
        if (this.fResourceListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fResourceListener);
            this.fResourceListener = null;
        }
    }

    public Object getInitializationOptions(URI rootPath) {
        this.installResourceChangeListener(rootPath);
        return this.configuration.options(super.getInitializationOptions(rootPath), rootPath);
    }

    private void installResourceChangeListener(URI rootPath) {
        if (rootPath == null || this.fResourceListener != null) {
            return;
        }
        IContainer[] containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(rootPath);
        if (containers.length == 0) {
            return;
        }
        IContainer[] iContainerArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer c = iContainerArray[n2];
            if (c instanceof IProject) {
                IProject project = (IProject)c;
                this.fResourceListener = new CPPResourceChangeListener(project);
                project.getWorkspace().addResourceChangeListener(this.fResourceListener);
                break;
            }
            ++n2;
        }
    }

    public String toString() {
        return "C/C++ Language Server: " + super.toString();
    }

    private static File getLanguageServerLocation() {
        String path = store.getString("org.eclipse.cdt.lsp.serverPathPreference");
        if (path.isEmpty()) {
            return null;
        }
        File f = new File(path);
        if (f.canExecute()) {
            return f;
        }
        return null;
    }

    public static File getDefaultLSLocation(String selectedLanguageServer) {
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "which " + selectedLanguageServer};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where " + selectedLanguageServer};
        }
        try {
            Process p = Runtime.getRuntime().exec(command);
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                res = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (res == null) {
            return null;
        }
        File f = new File(res);
        if (f.canExecute()) {
            return f;
        }
        return null;
    }
}

