/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.cdt.lsp.LanguageServerConfiguration;
import org.eclipse.cdt.lsp.SupportedLanguageServers;
import org.eclipse.cdt.lsp.internal.core.UndefinedLanguageServer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.framework.FrameworkUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;

@Component
public final class ContributedLanguageServers
implements SupportedLanguageServers {
    private final LanguageServerConfiguration undefined;
    private final Map<String, LanguageServerConfiguration> configs = new LinkedHashMap<String, LanguageServerConfiguration>();

    public ContributedLanguageServers() {
        this.undefined = new UndefinedLanguageServer();
    }

    @Override
    public Collection<LanguageServerConfiguration> all() {
        return this.configs.values();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE)
    public void register(LanguageServerConfiguration configuration) {
        this.configs.put(configuration.identifier(), configuration);
    }

    public void unregister(LanguageServerConfiguration configuration) {
        this.configs.remove(configuration.identifier());
    }

    @Override
    public LanguageServerConfiguration preferred() {
        return this.configs.getOrDefault(this.preferredIdentifier(), this.undefined);
    }

    private String preferredIdentifier() {
        return Platform.getPreferencesService().getString(this.nodeQualifier(), this.nodePath(), this.undefined.identifier(), new IScopeContext[]{InstanceScope.INSTANCE});
    }

    private String nodeQualifier() {
        return FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
    }

    private String nodePath() {
        return "org.eclipse.cdt.lsp.serverChoicePreference";
    }
}

