/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui.text;

import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.swt.custom.LineBackgroundEvent;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class LineBackgroundListenerCPP
implements LineBackgroundListener {
    private IDocument currentDocument;
    private Color lineBackgroundColor;

    public void setCurrentDocument(IDocument currentDocument) {
        this.currentDocument = currentDocument;
    }

    public void lineGetBackground(LineBackgroundEvent event) {
        this.lineBackgroundColor = new Color((Device)Display.getCurrent(), PreferenceConverter.getColor((IPreferenceStore)CUIPlugin.getDefault().getPreferenceStore(), (String)"inactiveCodeColor"));
        if (this.currentDocument == null) {
            return;
        }
        Position[] inactivePositions = null;
        try {
            inactivePositions = this.currentDocument.getPositions("org.eclipse.cdt.lsp.core.inactiveCodeHighlight");
        }
        catch (BadPositionCategoryException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
        if (inactivePositions == null) {
            return;
        }
        try {
            Position[] positionArray = inactivePositions;
            int n = inactivePositions.length;
            int n2 = 0;
            while (n2 < n) {
                Position eachInactivePosition = positionArray[n2];
                int regionStartLine = this.currentDocument.getLineOfOffset(eachInactivePosition.getOffset());
                int regionEndLine = this.currentDocument.getLineOfOffset(eachInactivePosition.getOffset() + eachInactivePosition.getLength());
                if (event.lineOffset >= this.currentDocument.getLineOffset(regionStartLine) && event.lineOffset <= this.currentDocument.getLineOffset(regionEndLine)) {
                    event.lineBackground = this.lineBackgroundColor;
                    break;
                }
                ++n2;
            }
        }
        catch (BadLocationException e) {
            Platform.getLog(this.getClass()).error(e.getMessage(), (Throwable)e);
        }
    }
}

