/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.ui.text;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.core.dom.ast.gnu.cpp.GPPLanguage;
import org.eclipse.cdt.core.model.ICLanguageKeywords;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.editor.SemanticHighlightingManager;
import org.eclipse.cdt.internal.ui.text.CCodeScanner;
import org.eclipse.cdt.internal.ui.text.CCommentScanner;
import org.eclipse.cdt.internal.ui.text.CPreprocessorScanner;
import org.eclipse.cdt.internal.ui.text.CPresentationReconciler;
import org.eclipse.cdt.internal.ui.text.PartitionDamager;
import org.eclipse.cdt.internal.ui.text.SingleTokenCScanner;
import org.eclipse.cdt.internal.ui.text.TokenStore;
import org.eclipse.cdt.lsp.internal.core.workspace.ResolveDocumentUri;
import org.eclipse.cdt.lsp.internal.ui.text.LineBackgroundListenerCPP;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.ILanguageUI;
import org.eclipse.cdt.ui.text.AbstractCScanner;
import org.eclipse.cdt.ui.text.ICTokenScanner;
import org.eclipse.cdt.ui.text.ITokenStoreFactory;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.swt.custom.LineBackgroundListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;

public class PresentationReconcilerCPP
extends CPresentationReconciler {
    private final ResolveDocumentUri documentUri;
    private CCommentScanner fSinglelineCommentScanner;
    private CCommentScanner fMultilineCommentScanner;
    private SingleTokenCScanner fStringScanner;
    private AbstractCScanner fCodeScanner;
    private LineBackgroundListenerCPP fLineBackgroundListener = new LineBackgroundListenerCPP();
    private ITextViewer textViewer;
    private TextInputListenerCPP textInputListener;
    private CEditor.BracketInserter fBracketInserter;
    private DefaultPositionUpdater semanticHighlightingPositionUpdater;
    public static final String SEMANTIC_HIGHLIGHTING_POSITION_CATEGORY = "org.eclipse.cdt.lsp.core.semanticHighlight";
    public static final String INACTIVE_CODE_HIGHLIGHTING_POSITION_CATEGORY = "org.eclipse.cdt.lsp.core.inactiveCodeHighlight";
    public static Set<PresentationReconcilerCPP> presentationReconcilers = ConcurrentHashMap.newKeySet();
    protected ICTokenScanner fMultilineDocCommentScanner;
    protected ICTokenScanner fSinglelineDocCommentScanner;
    protected AbstractCScanner fPreprocessorScanner;

    protected ITokenStoreFactory getTokenStoreFactory() {
        return propertyColorNames -> new TokenStore(CUIPlugin.getDefault().getTextTools().getColorManager(), CUIPlugin.getDefault().getCombinedPreferenceStore(), propertyColorNames);
    }

    protected ILanguage getLanguage() {
        return GPPLanguage.getDefault();
    }

    protected RuleBasedScanner getCodeScanner(ILanguage language) {
        if (this.fCodeScanner != null) {
            return this.fCodeScanner;
        }
        CCodeScanner scanner = null;
        if (language != null) {
            ICLanguageKeywords keywords = (ICLanguageKeywords)language.getAdapter(ICLanguageKeywords.class);
            if (keywords != null) {
                scanner = new CCodeScanner(this.getTokenStoreFactory(), keywords);
            } else {
                ILanguageUI languageUI = (ILanguageUI)language.getAdapter(ILanguageUI.class);
                if (languageUI != null) {
                    scanner = languageUI.getCodeScanner();
                }
            }
        }
        if (scanner == null) {
            scanner = new CCodeScanner(this.getTokenStoreFactory(), (ICLanguageKeywords)GPPLanguage.getDefault());
        }
        if (scanner instanceof AbstractCScanner) {
            this.fCodeScanner = (AbstractCScanner)scanner;
        }
        return scanner;
    }

    public PresentationReconcilerCPP() {
        ICTokenScanner docCommentMultiScanner;
        this.documentUri = new ResolveDocumentUri();
        this.fStringScanner = new SingleTokenCScanner(this.getTokenStoreFactory(), "c_string");
        this.fMultilineCommentScanner = new CCommentScanner(this.getTokenStoreFactory(), "c_multi_line_comment");
        this.fSinglelineCommentScanner = new CCommentScanner(this.getTokenStoreFactory(), "c_single_line_comment");
        this.setDocumentPartitioning(CUIPlugin.getDefault().getTextTools().getDocumentPartitioning());
        ILanguage language = this.getLanguage();
        RuleBasedScanner scanner = this.getCodeScanner(language);
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)scanner);
        this.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        this.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fSinglelineCommentScanner);
        this.setDamager((IPresentationDamager)dr, "__c_singleline_comment");
        this.setRepairer((IPresentationRepairer)dr, "__c_singleline_comment");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fMultilineCommentScanner);
        this.setDamager((IPresentationDamager)dr, "__c_multiline_comment");
        this.setRepairer((IPresentationRepairer)dr, "__c_multiline_comment");
        ICTokenScanner docCommentSingleScanner = this.getSinglelineDocCommentScanner(null);
        if (docCommentSingleScanner != null) {
            dr = new DefaultDamagerRepairer((ITokenScanner)docCommentSingleScanner);
            this.setDamager((IPresentationDamager)dr, "__c_singleline_doc_comment");
            this.setRepairer((IPresentationRepairer)dr, "__c_singleline_doc_comment");
        }
        if ((docCommentMultiScanner = this.getMultilineDocCommentScanner(null)) != null) {
            dr = new DefaultDamagerRepairer((ITokenScanner)docCommentMultiScanner);
            this.setDamager((IPresentationDamager)dr, "__c_multiline_doc_comment");
            this.setRepairer((IPresentationRepairer)dr, "__c_multiline_doc_comment");
        }
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        this.setDamager((IPresentationDamager)dr, "__c_string");
        this.setRepairer((IPresentationRepairer)dr, "__c_string");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.fStringScanner);
        this.setDamager((IPresentationDamager)dr, "__c_character");
        this.setRepairer((IPresentationRepairer)dr, "__c_character");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPreprocessorScanner(language));
        this.setDamager((IPresentationDamager)new PartitionDamager(), "__c_preprocessor");
        this.setRepairer((IPresentationRepairer)dr, "__c_preprocessor");
    }

    public TextPresentation createPresentation(IRegion damage, IDocument document) {
        TextPresentation presentation = super.createPresentation(damage, document);
        IDocument doc = this.textViewer.getDocument();
        Optional uri = this.documentUri.apply(doc);
        if (!uri.isPresent()) {
            return presentation;
        }
        Position[] returnedPositions = null;
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        this.addSemanticHighlightPositionCategory(doc);
        try {
            returnedPositions = doc.getPositions(SEMANTIC_HIGHLIGHTING_POSITION_CATEGORY);
        }
        catch (BadPositionCategoryException e) {
            Platform.getLog(((Object)((Object)this)).getClass()).error(e.getMessage(), (Throwable)e);
        }
        if (returnedPositions == null) {
            return presentation;
        }
        SemanticHighlightingManager.HighlightedPosition[] highlightedPositions = (SemanticHighlightingManager.HighlightedPosition[])Arrays.copyOf(returnedPositions, returnedPositions.length, SemanticHighlightingManager.HighlightedPosition[].class);
        int damageStartOffset = damage.getOffset();
        int damageEndOffset = damageStartOffset + damage.getLength();
        SemanticHighlightingManager.HighlightedPosition[] highlightedPositionArray = highlightedPositions;
        int n = highlightedPositions.length;
        int n2 = 0;
        while (n2 < n) {
            SemanticHighlightingManager.HighlightedPosition eachPosition = highlightedPositionArray[n2];
            if (eachPosition.getOffset() + eachPosition.getLength() >= damageStartOffset && eachPosition.getOffset() < damageEndOffset) {
                StyleRange range = eachPosition.createStyleRange();
                styleRanges.add(range);
            }
            ++n2;
        }
        StyleRange[] styleRangesArray = new StyleRange[styleRanges.size()];
        styleRangesArray = styleRanges.toArray(styleRangesArray);
        presentation.replaceStyleRanges(styleRangesArray);
        return presentation;
    }

    protected ICTokenScanner getMultilineDocCommentScanner(IResource resource) {
        if (this.fMultilineDocCommentScanner == null) {
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            if (this.fMultilineDocCommentScanner == null) {
                this.fMultilineDocCommentScanner = this.fMultilineCommentScanner;
            }
        }
        return this.fMultilineDocCommentScanner;
    }

    protected ICTokenScanner getSinglelineDocCommentScanner(IResource resource) {
        if (this.fSinglelineDocCommentScanner == null) {
            if (resource == null) {
                resource = ResourcesPlugin.getWorkspace().getRoot();
            }
            if (this.fSinglelineDocCommentScanner == null) {
                this.fSinglelineDocCommentScanner = this.fSinglelineCommentScanner;
            }
        }
        return this.fSinglelineDocCommentScanner;
    }

    protected RuleBasedScanner getPreprocessorScanner(ILanguage language) {
        ICLanguageKeywords keywords;
        if (this.fPreprocessorScanner != null) {
            return this.fPreprocessorScanner;
        }
        CPreprocessorScanner scanner = null;
        ICLanguageKeywords iCLanguageKeywords = keywords = language == null ? null : (ICLanguageKeywords)language.getAdapter(ICLanguageKeywords.class);
        if (keywords != null) {
            scanner = new CPreprocessorScanner(this.getTokenStoreFactory(), keywords);
        }
        if (scanner == null) {
            keywords = (ICLanguageKeywords)GPPLanguage.getDefault().getAdapter(ICLanguageKeywords.class);
            scanner = new CPreprocessorScanner(this.getTokenStoreFactory(), keywords);
        }
        this.fPreprocessorScanner = scanner;
        return this.fPreprocessorScanner;
    }

    private void addSemanticHighlightPositionCategory(IDocument document) {
        if (!document.containsPositionCategory(SEMANTIC_HIGHLIGHTING_POSITION_CATEGORY)) {
            document.addPositionCategory(SEMANTIC_HIGHLIGHTING_POSITION_CATEGORY);
            this.semanticHighlightingPositionUpdater = new DefaultPositionUpdater(SEMANTIC_HIGHLIGHTING_POSITION_CATEGORY);
            document.addPositionUpdater((IPositionUpdater)this.semanticHighlightingPositionUpdater);
        }
    }

    private void addInactiveCodeHighlightingCategory(IDocument document) {
        if (!document.containsPositionCategory(INACTIVE_CODE_HIGHLIGHTING_POSITION_CATEGORY)) {
            document.addPositionCategory(INACTIVE_CODE_HIGHLIGHTING_POSITION_CATEGORY);
            DefaultPositionUpdater inactiveCodeHighlightingPositionUpdater = new DefaultPositionUpdater(INACTIVE_CODE_HIGHLIGHTING_POSITION_CATEGORY);
            document.addPositionUpdater((IPositionUpdater)inactiveCodeHighlightingPositionUpdater);
        }
    }

    public void setupDocument(IDocument newDocument) {
        if (newDocument != null) {
            this.fLineBackgroundListener.setCurrentDocument(newDocument);
            this.addSemanticHighlightPositionCategory(newDocument);
            this.addInactiveCodeHighlightingCategory(newDocument);
        }
    }

    public ITextViewer getTextViewer() {
        return this.textViewer;
    }

    public DefaultPositionUpdater getSemanticHighlightingPositionUpdater() {
        return this.semanticHighlightingPositionUpdater;
    }

    public void install(ITextViewer viewer) {
        super.install(viewer);
        this.textViewer = viewer;
        this.textInputListener = new TextInputListenerCPP();
        viewer.addTextInputListener((ITextInputListener)this.textInputListener);
        IDocument document = viewer.getDocument();
        if (document != null) {
            this.textInputListener.inputDocumentChanged(null, document);
        }
        StyledText textWidget = this.textViewer.getTextWidget();
        textWidget.addLineBackgroundListener((LineBackgroundListener)this.fLineBackgroundListener);
        presentationReconcilers.add(this);
        Display.getDefault().asyncExec(() -> {
            TextEditor editor = (TextEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            this.fBracketInserter = new CEditor.BracketInserter(editor, true);
            this.fBracketInserter.setSourceViewer((ISourceViewer)((SourceViewer)this.textViewer));
            ((TextViewer)this.textViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        });
    }

    public void uninstall() {
        super.uninstall();
        this.textViewer.getTextWidget().removeLineBackgroundListener((LineBackgroundListener)this.fLineBackgroundListener);
        this.textViewer.removeTextInputListener((ITextInputListener)this.textInputListener);
        ((TextViewer)this.textViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        presentationReconcilers.remove((Object)this);
    }

    public class TextInputListenerCPP
    implements ITextInputListener {
        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            PresentationReconcilerCPP.this.setupDocument(newInput);
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }
    }
}

