/*******************************************************************************
 * Copyright (c) 2015 QNX Software Systems and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.cdt.internal.qt.ui.editor;

import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.qt.core.IQMLAnalyzer;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.ui.texteditor.ITextEditor;

public class QMLHyperlinkDetector extends AbstractHyperlinkDetector {

	@Override
	public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
		IQMLAnalyzer analyzer = Activator.getService(IQMLAnalyzer.class);
		if (analyzer == null || !analyzer.isSupported()) {
			return null;
		}

		// TODO is length of region ever > 0?
		IRegion wordRegion = QMLEditor.findWord(textViewer.getDocument(), region.getOffset());
		if (wordRegion != null) {
			ITextEditor editor = getAdapter(ITextEditor.class);
			return new IHyperlink[] { new QMLHyperlink(wordRegion, textViewer, editor) };
		}
		return null;
	}

}
