/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.unittest.launcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.cdt.unittest.CDTUnitTestPlugin;
import org.eclipse.cdt.unittest.launcher.CDTTestRunnerClient;
import org.eclipse.cdt.unittest.ui.OpenEditorAtLineAction;
import org.eclipse.cdt.unittest.ui.OpenTestAction;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.text.StringMatcher;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.unittest.launcher.ITestRunnerClient;
import org.eclipse.unittest.model.ITestCaseElement;
import org.eclipse.unittest.model.ITestElement;
import org.eclipse.unittest.model.ITestRunSession;
import org.eclipse.unittest.model.ITestSuiteElement;
import org.eclipse.unittest.ui.ITestViewSupport;

public class CDTTestViewSupport
implements ITestViewSupport {
    private static final String TEST_PATH_PART_DELIMITER = "\n";
    public static final String FRAME_PREFIX = " at ";

    public Collection<StringMatcher> getTraceExclusionFilterPatterns() {
        return Collections.emptySet();
    }

    public IAction getOpenTestAction(Shell shell, ITestCaseElement testCase) {
        return new OpenTestAction(shell, testCase.getParent(), testCase);
    }

    public IAction getOpenTestAction(Shell shell, ITestSuiteElement testSuite) {
        return new OpenTestAction(shell, testSuite);
    }

    public IAction createOpenEditorAction(Shell shell, ITestElement failure, String traceLine) {
        int indexOfFramePrefix;
        String testName;
        block3: {
            testName = traceLine;
            indexOfFramePrefix = testName.indexOf(FRAME_PREFIX);
            if (indexOfFramePrefix != -1) break block3;
            return null;
        }
        try {
            testName = testName.substring(indexOfFramePrefix);
            testName = testName.substring(FRAME_PREFIX.length(), testName.lastIndexOf(58)).trim();
            String lineNumber = traceLine;
            lineNumber = lineNumber.substring(lineNumber.indexOf(58) + 1);
            int line = Integer.parseInt(lineNumber);
            return new OpenEditorAtLineAction(shell, testName, failure.getTestRunSession(), line);
        }
        catch (IndexOutOfBoundsException | NumberFormatException e) {
            CDTUnitTestPlugin.log(e);
            return null;
        }
    }

    public Runnable createShowStackTraceInConsoleViewActionDelegate(ITestElement failedTest) {
        return null;
    }

    public ILaunchConfiguration getRerunLaunchConfiguration(List<ITestElement> tests) {
        if (tests.isEmpty()) {
            return null;
        }
        ILaunchConfiguration origin = tests.get(0).getTestRunSession().getLaunch().getLaunchConfiguration();
        try {
            ILaunchConfigurationWorkingCopy res = origin.copy(String.valueOf(origin.getName()) + "\ud83d\udd03");
            res.setAttribute("org.eclipse.cdt.testsrunner.launch.TESTS_FILTER", tests.stream().map(CDTTestViewSupport::packTestPaths).collect(Collectors.toList()));
            return res;
        }
        catch (CoreException e) {
            CDTUnitTestPlugin.log(e);
            return null;
        }
    }

    private static String packTestPaths(ITestElement testElement) {
        ArrayList<String> testPath = new ArrayList<String>();
        testPath.clear();
        ITestElement element = testElement;
        while (element != null && !(element instanceof ITestRunSession)) {
            if (element.getParent() != null) {
                testPath.add(element.getTestName());
            }
            element = element.getParent();
        }
        StringBuilder sb = new StringBuilder();
        boolean needDelimiter = false;
        int pathPartIdx = testPath.size() - 1;
        while (pathPartIdx >= 0) {
            if (needDelimiter) {
                sb.append(TEST_PATH_PART_DELIMITER);
            } else {
                needDelimiter = true;
            }
            sb.append((String)testPath.get(pathPartIdx));
            --pathPartIdx;
        }
        return sb.toString();
    }

    public String getDisplayName() {
        return "C/C++ Unit Tests";
    }

    public ITestRunnerClient newTestRunnerClient(ITestRunSession session) {
        return new CDTTestRunnerClient(session);
    }
}

