/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.view.ui.local.showin;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tm.terminal.view.ui.activator.UIPlugin;
import org.eclipse.tm.terminal.view.ui.internal.ExternalExecutablesState;
import org.eclipse.tm.terminal.view.ui.local.showin.IDetectExternalExecutable;
import org.eclipse.tm.terminal.view.ui.local.showin.detectors.DetectGitBash;
import org.eclipse.tm.terminal.view.ui.local.showin.detectors.DetectWSL;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.services.ISourceProviderService;

public class ExternalExecutablesManager {
    private static List<IDetectExternalExecutable> detectors = List.of(new DetectGitBash(), new DetectWSL());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasEntries() {
        block12: {
            File f;
            IPath stateLocation = UIPlugin.getDefault().getStateLocation();
            if (stateLocation != null && (f = stateLocation.append(".executables/data.properties").toFile()).canRead()) {
                try {
                    Object object = null;
                    Object var3_5 = null;
                    try (FileReader r = new FileReader(f);){
                        Properties data = new Properties();
                        data.load(r);
                        if (!data.isEmpty()) {
                            return true;
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                            throw object;
                        }
                        if (object == throwable) throw object;
                        ((Throwable)object).addSuppressed(throwable);
                        throw object;
                    }
                }
                catch (IOException e) {
                    if (!Platform.inDebugMode()) break block12;
                    e.printStackTrace();
                }
            }
        }
        for (IDetectExternalExecutable iDetectExternalExecutable : detectors) {
            if (!iDetectExternalExecutable.hasEntries()) continue;
            return true;
        }
        return false;
    }

    public static List<Map<String, String>> load() {
        ArrayList<Map<String, String>> externalExecutables;
        block22: {
            File f;
            externalExecutables = new ArrayList<Map<String, String>>();
            IPath stateLocation = UIPlugin.getDefault().getStateLocation();
            if (stateLocation != null && (f = stateLocation.append(".executables/data.properties").toFile()).canRead()) {
                InputStreamReader r = null;
                try {
                    try {
                        Properties data = new Properties();
                        r = new FileReader(f);
                        data.load(r);
                        HashMap<Integer, HashMap<String, String>> c = new HashMap<Integer, HashMap<String, String>>();
                        for (String name : data.stringPropertyNames()) {
                            String k;
                            if (name == null || name.indexOf(46) == -1) continue;
                            int ix = name.indexOf(46);
                            String n = name.substring(0, ix);
                            String string = k = ix + 1 < name.length() ? name.substring(ix + 1) : null;
                            if (n == null || k == null) continue;
                            Integer i = null;
                            try {
                                i = Integer.decode(n);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (i == null) continue;
                            HashMap<String, String> m = (HashMap<String, String>)c.get(i);
                            if (m == null) {
                                m = new HashMap<String, String>();
                                c.put(i, m);
                            }
                            Assert.isNotNull((Object)m);
                            m.put(k, data.getProperty(name));
                        }
                        ArrayList k = new ArrayList(c.keySet());
                        Collections.sort(k);
                        for (Integer i : k) {
                            Map m = (Map)c.get(i);
                            if (m == null || m.isEmpty()) continue;
                            externalExecutables.add(m);
                        }
                    }
                    catch (Exception e) {
                        if (Platform.inDebugMode()) {
                            e.printStackTrace();
                        }
                        if (r != null) {
                            try {
                                r.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                if (r != null) {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        List readOnly = Collections.unmodifiableList(externalExecutables);
        List detected = detectors.stream().flatMap(detector -> detector.getEntries(readOnly).stream()).collect(Collectors.toList());
        if (!detected.isEmpty()) {
            externalExecutables.addAll(detected);
            ExternalExecutablesManager.save(externalExecutables);
        }
        return externalExecutables;
    }

    public static void save(List<Map<String, String>> externalExecutables) {
        block21: {
            ISourceProviderService sourceProviderService = (ISourceProviderService)PlatformUI.getWorkbench().getService(ISourceProviderService.class);
            ExternalExecutablesState stateService = (ExternalExecutablesState)sourceProviderService.getSourceProvider("org.eclipse.tm.terminal.external.executable.configured");
            IPath stateLocation = UIPlugin.getDefault().getStateLocation();
            if (stateLocation != null) {
                File f = stateLocation.append(".executables/data.properties").toFile();
                if (f.isFile() && (externalExecutables == null || externalExecutables.isEmpty())) {
                    boolean s = f.delete();
                    if (stateService != null) {
                        stateService.disable();
                    }
                } else {
                    OutputStreamWriter w = null;
                    try {
                        try {
                            Properties data = new Properties();
                            int i = 0;
                            while (i < externalExecutables.size()) {
                                Map<String, String> m = externalExecutables.get(i);
                                for (Map.Entry<String, String> e : m.entrySet()) {
                                    String key = String.valueOf(Integer.toString(i)) + "." + e.getKey();
                                    data.setProperty(key, e.getValue());
                                }
                                ++i;
                            }
                            if (!f.exists()) {
                                boolean s = f.getParentFile().mkdirs();
                                s = f.createNewFile();
                            }
                            w = new FileWriter(f);
                            data.store(w, null);
                            if (stateService != null) {
                                stateService.enable();
                            }
                        }
                        catch (Exception e) {
                            if (Platform.inDebugMode()) {
                                e.printStackTrace();
                            }
                            if (w == null) break block21;
                            try {
                                w.flush();
                                w.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    finally {
                        if (w != null) {
                            try {
                                w.flush();
                                w.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
        }
    }
}

