/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.ssh.controls;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm.internal.terminal.provisional.api.AbstractSettingsPage;
import org.eclipse.tm.internal.terminal.provisional.api.ISettingsPage;
import org.eclipse.tm.terminal.connector.ssh.connector.SshConnector;
import org.eclipse.tm.terminal.connector.ssh.connector.SshSettings;
import org.eclipse.tm.terminal.connector.ssh.connector.SshSettingsPage;
import org.eclipse.tm.terminal.connector.ssh.nls.Messages;
import org.eclipse.tm.terminal.view.core.TerminalContextPropertiesProviderFactory;
import org.eclipse.tm.terminal.view.core.interfaces.ITerminalContextPropertiesProvider;
import org.eclipse.tm.terminal.view.ui.interfaces.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.view.ui.panels.AbstractExtendedConfigurationPanel;

public class SshWizardConfigurationPanel
extends AbstractExtendedConfigurationPanel {
    private static final String SAVE_USER = "saveUser";
    private static final String SAVE_PASSWORD = "savePassword";
    private SshSettings sshSettings;
    private ISettingsPage sshSettingsPage;
    private Button userButton;
    private Button passwordButton;

    public SshWizardConfigurationPanel(IConfigurationPanelContainer container) {
        super(container);
    }

    public void setupPanel(Composite parent) {
        Composite panel = new Composite(parent, 0);
        panel.setLayout((Layout)new GridLayout());
        GridData data = new GridData(4, 4, true, true);
        panel.setLayoutData((Object)data);
        if (this.isWithoutSelection()) {
            this.createHostsUI(panel, true);
        }
        SshConnector conn = new SshConnector();
        this.sshSettings = (SshSettings)conn.getSshSettings();
        this.sshSettings.setHost(this.getSelectionHost());
        this.sshSettings.setUser(this.getDefaultUser());
        this.sshSettingsPage = new SshSettingsPage(this.sshSettings);
        if (this.sshSettingsPage instanceof AbstractSettingsPage) {
            ((AbstractSettingsPage)this.sshSettingsPage).setHasControlDecoration(true);
        }
        this.sshSettingsPage.createControl(panel);
        this.sshSettingsPage.addListener(new ISettingsPage.Listener(){

            public void onSettingsPageChanged(Control control) {
                if (SshWizardConfigurationPanel.this.getContainer() != null) {
                    SshWizardConfigurationPanel.this.getContainer().validate();
                }
            }
        });
        this.createEncodingUI(panel, true);
        this.createSaveButtonsUI(panel, true);
        this.setControl(panel);
    }

    public void setupData(Map<String, Object> data) {
        Object v;
        if (data == null || this.sshSettings == null || this.sshSettingsPage == null) {
            return;
        }
        String value = (String)data.get("ip.host");
        if (value != null) {
            this.sshSettings.setHost(value);
        }
        String string = value = (v = data.get("ip.port")) != null ? v.toString() : null;
        if (value != null) {
            this.sshSettings.setPort(value);
        }
        String string2 = value = (v = data.get("timeout")) != null ? v.toString() : null;
        if (value != null) {
            this.sshSettings.setTimeout(value);
        }
        String string3 = value = (v = data.get("ssh.keep_alive")) != null ? v.toString() : null;
        if (value != null) {
            this.sshSettings.setKeepalive(value);
        }
        if ((value = (String)data.get("ssh.password")) != null) {
            this.sshSettings.setPassword(value);
        }
        if ((value = (String)data.get("ssh.user")) != null) {
            this.sshSettings.setUser(value);
        }
        if ((value = (String)data.get("encoding")) != null) {
            this.setEncoding(value);
        }
        this.sshSettingsPage.loadSettings();
    }

    private String getDefaultUser() {
        Object user;
        Object element;
        ITerminalContextPropertiesProvider provider;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty() && (provider = TerminalContextPropertiesProviderFactory.getProvider((Object)(element = ((IStructuredSelection)selection).getFirstElement()))) != null && (user = provider.getProperty(element, "defaultUser")) instanceof String) {
            return ((String)user).trim();
        }
        return System.getProperty("user.name");
    }

    public void extractData(Map<String, Object> data) {
        if (data == null) {
            return;
        }
        data.put("tm.terminal.connector.id", "org.eclipse.tm.terminal.connector.ssh.SshConnector");
        this.sshSettingsPage.saveSettings();
        data.put("ip.host", this.sshSettings.getHost());
        data.put("ip.port", this.sshSettings.getPort());
        data.put("timeout", this.sshSettings.getTimeout());
        data.put("ssh.keep_alive", this.sshSettings.getKeepalive());
        data.put("ssh.password", this.sshSettings.getPassword());
        data.put("ssh.user", this.sshSettings.getUser());
        data.put("encoding", this.getEncoding());
    }

    protected void fillSettingsForHost(String host) {
        boolean saveUser = true;
        boolean savePassword = false;
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                if (hostSettings.get("ip.host") != null) {
                    this.sshSettings.setHost((String)hostSettings.get("ip.host"));
                }
                if (hostSettings.get("ip.port") != null) {
                    this.sshSettings.setPort((String)hostSettings.get("ip.port"));
                }
                if (hostSettings.get("timeout") != null) {
                    this.sshSettings.setTimeout((String)hostSettings.get("timeout"));
                }
                if (hostSettings.get("ssh.keep_alive") != null) {
                    this.sshSettings.setKeepalive((String)hostSettings.get("ssh.keep_alive"));
                }
                if (hostSettings.get("ssh.user") != null) {
                    this.sshSettings.setUser((String)hostSettings.get("ssh.user"));
                }
                if (hostSettings.get(SAVE_PASSWORD) != null) {
                    savePassword = new Boolean((String)hostSettings.get(SAVE_PASSWORD));
                }
                if (!savePassword) {
                    this.sshSettings.setPassword("");
                } else {
                    String password = this.accessSecurePassword(this.sshSettings.getHost());
                    if (password != null) {
                        this.sshSettings.setPassword(password);
                    }
                }
                String encoding = (String)hostSettings.get("encoding");
                if (encoding == null || "null".equals(encoding)) {
                    String defaultEncoding = this.getSelectionEncoding();
                    encoding = defaultEncoding != null && !"".equals(defaultEncoding.trim()) ? defaultEncoding.trim() : "ISO-8859-1";
                }
                this.setEncoding(encoding);
            } else {
                this.sshSettings.setHost(this.getSelectionHost());
                this.sshSettings.setUser(this.getDefaultUser());
                saveUser = true;
                savePassword = false;
            }
            this.sshSettingsPage.loadSettings();
            this.userButton.setSelection(saveUser);
            this.passwordButton.setSelection(savePassword);
        }
    }

    public void doSaveWidgetValues(IDialogSettings settings, String idPrefix) {
        this.saveSettingsForHost(true);
        super.doSaveWidgetValues(settings, idPrefix);
    }

    protected void saveSettingsForHost(boolean add) {
        boolean saveUser = this.userButton.getSelection();
        boolean savePassword = this.passwordButton.getSelection();
        String host = this.getHostFromSettings();
        if (host != null && host.length() != 0) {
            if (this.hostSettingsMap.containsKey(host)) {
                String defaultEncoding;
                Map hostSettings = (Map)this.hostSettingsMap.get(host);
                hostSettings.put("ip.host", this.sshSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.sshSettings.getPort()));
                hostSettings.put("timeout", Integer.toString(this.sshSettings.getTimeout()));
                hostSettings.put("ssh.keep_alive", Integer.toString(this.sshSettings.getKeepalive()));
                if (saveUser) {
                    if (this.sshSettings.getUser() != null) {
                        hostSettings.put("ssh.user", this.sshSettings.getUser());
                    } else {
                        hostSettings.remove("ssh.user");
                    }
                } else {
                    hostSettings.remove("ssh.user");
                }
                String encoding = this.getEncoding();
                if (encoding != null && (defaultEncoding = this.getSelectionEncoding()) != null && defaultEncoding.trim().equals(encoding)) {
                    encoding = null;
                }
                hostSettings.put("encoding", encoding);
                hostSettings.put(SAVE_USER, Boolean.toString(saveUser));
                hostSettings.put(SAVE_PASSWORD, Boolean.toString(savePassword));
                if (savePassword && this.sshSettings.getPassword() != null && this.sshSettings.getPassword().length() != 0) {
                    this.saveSecurePassword(host, this.sshSettings.getPassword());
                }
                if (!savePassword) {
                    this.removeSecurePassword(host);
                }
            } else if (add) {
                HashMap<String, String> hostSettings = new HashMap<String, String>();
                hostSettings.put("ip.host", this.sshSettings.getHost());
                hostSettings.put("ip.port", Integer.toString(this.sshSettings.getPort()));
                hostSettings.put("timeout", Integer.toString(this.sshSettings.getTimeout()));
                hostSettings.put("ssh.keep_alive", Integer.toString(this.sshSettings.getKeepalive()));
                if (saveUser && this.sshSettings.getUser() != null) {
                    hostSettings.put("ssh.user", this.sshSettings.getUser());
                }
                hostSettings.put("encoding", this.getEncoding());
                hostSettings.put(SAVE_USER, Boolean.toString(saveUser));
                hostSettings.put(SAVE_PASSWORD, Boolean.toString(savePassword));
                this.hostSettingsMap.put(host, hostSettings);
                if (savePassword && this.sshSettings.getPassword() != null && this.sshSettings.getPassword().length() != 0) {
                    this.saveSecurePassword(host, this.sshSettings.getPassword());
                }
            }
        }
    }

    private void saveSecurePassword(String host, String password) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        Assert.isNotNull((Object)password);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            try {
                node.put("password", password, true);
            }
            catch (StorageException storageException) {
                // empty catch block
            }
        }
    }

    private String accessSecurePassword(String host) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            String password = null;
            try {
                password = node.get("password", null);
            }
            catch (StorageException storageException) {
                // empty catch block
            }
            return password;
        }
        return null;
    }

    protected void removeSecurePassword(String host) {
        String nodeKey;
        ISecurePreferences node;
        Assert.isNotNull((Object)host);
        ISecurePreferences preferences = SecurePreferencesFactory.getDefault();
        if (preferences != null && (node = preferences.node(nodeKey = "/Target Explorer SSH Password/" + host)) != null) {
            node.remove("password");
        }
    }

    public boolean isValid() {
        return this.isEncodingValid() && this.sshSettingsPage.validateSettings();
    }

    protected String getHostFromSettings() {
        this.sshSettingsPage.saveSettings();
        return this.sshSettings.getHost();
    }

    private void createSaveButtonsUI(Composite parent, boolean separator) {
        Assert.isNotNull((Object)parent);
        if (separator) {
            Label sep = new Label(parent, 258);
            sep.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        }
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        panel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.userButton = new Button(panel, 32);
        this.userButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.userButton.setText(Messages.SshWizardConfigurationPanel_saveUser);
        this.passwordButton = new Button(panel, 32);
        this.passwordButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.passwordButton.setText(Messages.SshWizardConfigurationPanel_savePassword);
    }
}

