/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IBasicType;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.SizeofCalculator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBuiltinParameter;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.Conversions;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ExecReturn;
import org.eclipse.core.runtime.CoreException;

public class ExecBuiltin
implements ICPPExecution {
    public static final short BUILTIN_FFS = 0;
    public static final short BUILTIN_FFSL = 1;
    public static final short BUILTIN_FFSLL = 2;
    public static final short BUILTIN_CTZ = 3;
    public static final short BUILTIN_CTZL = 4;
    public static final short BUILTIN_CTZLL = 5;
    public static final short BUILTIN_POPCOUNT = 6;
    public static final short BUILTIN_POPCOUNTL = 7;
    public static final short BUILTIN_POPCOUNTLL = 8;
    public static final short BUILTIN_PARITY = 9;
    public static final short BUILTIN_PARITYL = 10;
    public static final short BUILTIN_PARITYLL = 11;
    public static final short BUILTIN_ABS = 12;
    public static final short BUILTIN_LABS = 13;
    public static final short BUILTIN_LLABS = 14;
    public static final short BUILTIN_CLRSB = 15;
    public static final short BUILTIN_CLRSBL = 16;
    public static final short BUILTIN_CLRSBLL = 17;
    public static final short BUILTIN_CLZ = 18;
    public static final short BUILTIN_CLZL = 19;
    public static final short BUILTIN_CLZLL = 20;
    private static IType intType = new CPPBasicType(IBasicType.Kind.eInt, 0);
    private static IType longType = new CPPBasicType(IBasicType.Kind.eInt, 1);
    private static IType longlongType = new CPPBasicType(IBasicType.Kind.eInt, 64);
    private short funcId;

    public ExecBuiltin(short funcId) {
        this.funcId = funcId;
    }

    @Override
    public ICPPExecution instantiate(InstantiationContext context, int maxDepth) {
        return this;
    }

    @Override
    public ICPPExecution executeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        switch (this.funcId) {
            case 0: {
                return this.executeBuiltinFfs(record, context, intType);
            }
            case 1: {
                return this.executeBuiltinFfs(record, context, longType);
            }
            case 2: {
                return this.executeBuiltinFfs(record, context, longlongType);
            }
            case 3: {
                return this.executeBuiltinCtz(record, context, intType);
            }
            case 4: {
                return this.executeBuiltinCtz(record, context, longType);
            }
            case 5: {
                return this.executeBuiltinCtz(record, context, longlongType);
            }
            case 6: {
                return this.executeBuiltinPopcount(record, context, intType);
            }
            case 7: {
                return this.executeBuiltinPopcount(record, context, longType);
            }
            case 8: {
                return this.executeBuiltinPopcount(record, context, longlongType);
            }
            case 9: {
                return this.executeBuiltinParity(record, context, intType);
            }
            case 10: {
                return this.executeBuiltinParity(record, context, longType);
            }
            case 11: {
                return this.executeBuiltinParity(record, context, longlongType);
            }
            case 12: {
                return this.executeBuiltinAbs(record, context, intType);
            }
            case 13: {
                return this.executeBuiltinAbs(record, context, longType);
            }
            case 14: {
                return this.executeBuiltinAbs(record, context, longlongType);
            }
            case 15: {
                return this.executeBuiltinClrsb(record, context, intType);
            }
            case 16: {
                return this.executeBuiltinClrsb(record, context, longType);
            }
            case 17: {
                return this.executeBuiltinClrsb(record, context, longlongType);
            }
            case 18: {
                return this.executeBuiltinClz(record, context, intType);
            }
            case 19: {
                return this.executeBuiltinClz(record, context, longType);
            }
            case 20: {
                return this.executeBuiltinClz(record, context, longlongType);
            }
        }
        return null;
    }

    private ICPPExecution executeBuiltinFfsCtz(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, boolean isCtz, IType argType) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        IValue argValue = arg0.getValue();
        Number numberVal = argValue.numberValue();
        if ((numberVal = Conversions.narrowNumberValue(numberVal, argType)) == null) {
            return null;
        }
        long arg = numberVal.longValue();
        if (arg == 0L) {
            if (isCtz) {
                return null;
            }
            return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(0L)));
        }
        int count = 0;
        while ((arg & 1L) == 0L) {
            arg >>= 1;
            ++count;
        }
        int increment = isCtz ? 0 : 1;
        return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(count + increment)));
    }

    private ICPPExecution executeBuiltinFfs(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        return this.executeBuiltinFfsCtz(record, context, false, argType);
    }

    private ICPPExecution executeBuiltinCtz(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        return this.executeBuiltinFfsCtz(record, context, true, argType);
    }

    private ICPPExecution executeBuiltinPopcountParity(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, boolean isParity, IType argType) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        IValue argValue = arg0.getValue();
        Number numberVal = argValue.numberValue();
        if ((numberVal = Conversions.narrowNumberValue(numberVal, argType)) == null) {
            return null;
        }
        long arg = numberVal.longValue();
        int count = 0;
        while (arg != 0L) {
            if ((arg & 1L) != 0L) {
                ++count;
            }
            arg >>>= 1;
        }
        if (isParity) {
            count &= 1;
        }
        return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(count)));
    }

    private ICPPExecution executeBuiltinPopcount(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        return this.executeBuiltinPopcountParity(record, context, false, argType);
    }

    private ICPPExecution executeBuiltinParity(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        return this.executeBuiltinPopcountParity(record, context, true, argType);
    }

    private ICPPExecution executeBuiltinAbs(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        IValue argValue = arg0.getValue();
        Number argNumber = argValue.numberValue();
        if ((argNumber = Conversions.narrowNumberValue(argNumber, argType)) == null) {
            return null;
        }
        long arg = argNumber.longValue();
        long result = Math.abs(arg);
        return new ExecReturn(new EvalFixed(argType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(result)));
    }

    private ICPPExecution executeBuiltinClrsb(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        SizeofCalculator.SizeAndAlignment sizeToType = SizeofCalculator.getSizeAndAlignment(argType);
        if (sizeToType.size > 8L) {
            return null;
        }
        IValue argValue = arg0.getValue();
        Number argNumber = argValue.numberValue();
        if (argNumber == null) {
            return null;
        }
        long argLong = argNumber.longValue();
        long signBit = 1L << (int)(sizeToType.size * 8L - 1L);
        int result = 0;
        long valueBit = signBit >>> 1;
        if ((argLong & signBit) == 0L) {
            argLong ^= 0xFFFFFFFFFFFFFFFFL;
        }
        while ((argLong & valueBit) != 0L) {
            ++result;
            valueBit >>>= 1;
        }
        return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(result)));
    }

    private ICPPExecution executeBuiltinClz(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context, IType argType) {
        ICPPEvaluation arg0 = record.getVariable(new CPPBuiltinParameter(null, 0));
        SizeofCalculator.SizeAndAlignment sizeToType = SizeofCalculator.getSizeAndAlignment(argType);
        if (sizeToType.size > 8L) {
            return null;
        }
        IValue argValue = arg0.getValue();
        Number argNumber = argValue.numberValue();
        if (argNumber == null) {
            return null;
        }
        long argLong = argNumber.longValue();
        long valueBit = 1L << (int)(sizeToType.size * 8L - 1L);
        int result = 0;
        while ((argLong & valueBit) == 0L) {
            ++result;
            if ((valueBit >>>= 1) == 0L) break;
        }
        return new ExecReturn(new EvalFixed(intType, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(result)));
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        buffer.putShort((short)19);
        buffer.putShort(this.funcId);
    }

    public static ICPPExecution unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        short funcId = buffer.getShort();
        return new ExecBuiltin(funcId);
    }
}

