/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel;

import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.debug.internal.ui.viewmodel.DsfCastToTypeSupport;
import org.eclipse.cdt.dsf.debug.service.IExpressions;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.DisabledExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionManagerVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.ExpressionVMProvider;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.IExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.expression.SingleExpressionVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterBitFieldVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterGroupVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.RegisterVMNode;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.register.SyncRegisterDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.SyncVariableDataAccess;
import org.eclipse.cdt.dsf.debug.ui.viewmodel.variable.VariableVMNode;
import org.eclipse.cdt.dsf.gdb.internal.ui.GdbUIPlugin;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.FetchMoreChildrenEvent;
import org.eclipse.cdt.dsf.gdb.internal.ui.viewmodel.GdbVariableVMNode;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMAdapter;
import org.eclipse.cdt.dsf.ui.viewmodel.AbstractVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.IRootVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMNode;
import org.eclipse.cdt.dsf.ui.viewmodel.IVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.AbstractDMVMProvider;
import org.eclipse.cdt.dsf.ui.viewmodel.datamodel.RootDMVMNode;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;

public class GdbExpressionVMProvider
extends ExpressionVMProvider {
    private IPropertyChangeListener fPreferencesListener;

    public GdbExpressionVMProvider(AbstractVMAdapter adapter, IPresentationContext context, DsfSession session) {
        super(adapter, context, session);
        final IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        Integer childCountLimit = store.getInt("initialChildCountLimitForCollections");
        if (childCountLimit != 0) {
            this.getPresentationContext().setProperty("initialChildCountLimitForCollections", (Object)childCountLimit);
        }
        this.fPreferencesListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                GdbExpressionVMProvider.this.handlePropertyChanged(store, event);
            }
        };
        store.addPropertyChangeListener(this.fPreferencesListener);
    }

    public void dispose() {
        super.dispose();
        IPreferenceStore store = GdbUIPlugin.getDefault().getPreferenceStore();
        store.removePropertyChangeListener(this.fPreferencesListener);
    }

    protected void configureLayout() {
        SyncRegisterDataAccess syncRegDataAccess = new SyncRegisterDataAccess(this.getSession());
        SyncVariableDataAccess syncvarDataAccess = new SyncVariableDataAccess(this.getSession());
        RootDMVMNode rootNode = new RootDMVMNode((AbstractVMProvider)this);
        if ("org.eclipse.cdt.dsf.ui.expression_hover".equals(this.getPresentationContext().getId())) {
            expressionManagerNode = new SingleExpressionVMNode((ExpressionVMProvider)this);
            this.addChildNodes((IVMNode)rootNode, new IVMNode[]{expressionManagerNode});
        } else {
            expressionManagerNode = new ExpressionManagerVMNode((ExpressionVMProvider)this);
            this.addChildNodes((IVMNode)rootNode, new IVMNode[]{expressionManagerNode});
        }
        DisabledExpressionVMNode disabledExpressionNode = new DisabledExpressionVMNode((IVMProvider)this);
        RegisterGroupVMNode registerGroupNode = new RegisterGroupVMNode((AbstractDMVMProvider)this, this.getSession(), syncRegDataAccess);
        RegisterVMNode registerNode = new RegisterVMNode((AbstractDMVMProvider)this, this.getSession(), syncRegDataAccess);
        this.addChildNodes((IVMNode)registerGroupNode, (IVMNode[])new IExpressionVMNode[]{registerNode});
        RegisterBitFieldVMNode bitFieldNode = new RegisterBitFieldVMNode((AbstractDMVMProvider)this, this.getSession(), syncRegDataAccess);
        this.addChildNodes((IVMNode)registerNode, new IVMNode[]{bitFieldNode});
        GdbVariableVMNode variableNode = new GdbVariableVMNode((AbstractDMVMProvider)this, this.getSession(), syncvarDataAccess);
        this.addChildNodes((IVMNode)variableNode, (IVMNode[])new IExpressionVMNode[]{variableNode});
        ((VariableVMNode)variableNode).setCastToTypeSupport(new DsfCastToTypeSupport(this.getSession(), (AbstractDMVMProvider)this, syncvarDataAccess));
        this.setExpressionNodes(new IExpressionVMNode[]{disabledExpressionNode, registerGroupNode, variableNode});
        this.setRootNode((IRootVMNode)rootNode);
    }

    public void handleEvent(Object event, final RequestMonitor rm) {
        GdbVariableVMNode.IncompleteChildrenVMC incompleteChildrenVmc;
        IVMNode node;
        Object element;
        ISelection selection;
        if (event instanceof DoubleClickEvent && !this.isDisposed() && (selection = ((DoubleClickEvent)event).getSelection()) instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof GdbVariableVMNode.IncompleteChildrenVMC && (node = (incompleteChildrenVmc = (GdbVariableVMNode.IncompleteChildrenVMC)((Object)element)).getVMNode()) instanceof GdbVariableVMNode && node.getVMProvider() == this && selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            TreePath path = treeSelection.getPaths()[0];
            IExpressions.IExpressionDMContext exprCtx = incompleteChildrenVmc.getParentDMContext();
            ((GdbVariableVMNode)node).incrementChildCountLimit(exprCtx);
            final FetchMoreChildrenEvent fetchMoreChildrenEvent = new FetchMoreChildrenEvent(exprCtx, path);
            this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    GdbExpressionVMProvider.this.handleEvent((Object)fetchMoreChildrenEvent, rm);
                }
            });
            return;
        }
        super.handleEvent(event, rm);
    }

    protected void handlePropertyChanged(IPreferenceStore store, final PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("initialChildCountLimitForCollections".equals(property)) {
            Integer childCountLimit = store.getInt("initialChildCountLimitForCollections");
            if (childCountLimit != 0) {
                this.getPresentationContext().setProperty("initialChildCountLimitForCollections", (Object)childCountLimit);
            } else {
                this.getPresentationContext().setProperty("initialChildCountLimitForCollections", null);
            }
            this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    GdbExpressionVMProvider.this.handleEvent(event);
                }
            });
        }
    }
}

