/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.editor;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.UncheckedIOException;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.io.HexDump;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.utils.IGnuToolFactory;
import org.eclipse.cdt.utils.Objdump;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DefaultBinaryFileEditor
extends TextEditor {
    public DefaultBinaryFileEditor() {
        this.setDocumentProvider((IDocumentProvider)new BinaryFileDocumentProvider());
    }

    public static class BinaryFileDocumentProvider
    extends FileDocumentProvider {
        private static final String CONTENT_TRUNCATED_MESSAGE_FORMAT = "\n--- {0} ---\n";

        private InputStream getInputStream(Consumer<OutputStream> writer) throws IOException {
            final AtomicReference writerException = new AtomicReference();
            PipedInputStream pipedInputStream = new PipedInputStream();
            FilterInputStream filterInputStream = new FilterInputStream(pipedInputStream){

                @Override
                public void close() throws IOException {
                    try {
                        IOException exception = (IOException)writerException.get();
                        if (exception != null) {
                            throw new IOException(exception.getMessage(), exception);
                        }
                    }
                    finally {
                        super.close();
                    }
                }
            };
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            new Thread(() -> {
                try {
                    Throwable throwable = null;
                    Object var4_7 = null;
                    try {
                        try {
                            writer.accept(pipedOutputStream);
                        }
                        finally {
                            if (pipedOutputStream != null) {
                                pipedOutputStream.close();
                            }
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (UncheckedIOException e) {
                    writerException.set(e.getCause());
                }
                catch (IOException e) {
                    writerException.set(e);
                }
            }).start();
            return filterInputStream;
        }

        private void writeObjdump(Objdump objdump, OutputStream outputStream) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream objdumpStream = objdump.getInputStream();){
                    byte[] buffer;
                    int offset = 0;
                    while ((buffer = objdumpStream.readNBytes(4096)).length != 0) {
                        if (offset >= 0x1000000) {
                            String message = "\n" + MessageFormat.format(CONTENT_TRUNCATED_MESSAGE_FORMAT, CEditorMessages.DefaultBinaryFileEditor_TruncateMessage) + objdump.toString();
                            outputStream.write(message.getBytes());
                            break;
                        }
                        outputStream.write(buffer);
                        offset += buffer.length;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private void writeHexDump(IPath filePath, OutputStream outputStream) {
            int BYTES_PER_LINE = 16;
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(filePath.toFile()));){
                    byte[] buffer;
                    int offset = 0;
                    while ((buffer = fileStream.readNBytes(4096)).length != 0) {
                        if (offset >= 0x1000000) {
                            String message = MessageFormat.format(CONTENT_TRUNCATED_MESSAGE_FORMAT, CEditorMessages.DefaultBinaryFileEditor_TruncateHexDumpMessage);
                            outputStream.write(message.getBytes());
                            break;
                        }
                        HexDump.dump((byte[])buffer, (long)offset, (OutputStream)outputStream, (int)0);
                        offset += buffer.length;
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private InputStream getBinaryFileContent(IBinaryParser.IBinaryFile binaryFile) throws CoreException {
            try {
                Objdump objdump;
                IPath filePath = binaryFile.getPath();
                IGnuToolFactory factory = (IGnuToolFactory)binaryFile.getBinaryParser().getAdapter(IGnuToolFactory.class);
                if (factory != null && (objdump = factory.getObjdump(filePath)) != null) {
                    return this.getInputStream(stream -> this.writeObjdump(objdump, (OutputStream)stream));
                }
                return this.getInputStream(stream -> this.writeHexDump(filePath, (OutputStream)stream));
            }
            catch (IOException e) {
                String message = e.getMessage() != null ? e.getMessage() : "";
                throw new CoreException(Status.error((String)message, (Throwable)e));
            }
        }

        /*
         * WARNING - void declaration
         */
        protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
            IEditorInput iEditorInput = editorInput;
            if (iEditorInput instanceof IFileEditorInput) {
                IBinaryParser.IBinaryFile binaryFile;
                void fileEditorInput;
                IFileEditorInput iFileEditorInput = (IFileEditorInput)iEditorInput;
                IFileEditorInput cfr_ignored_0 = (IFileEditorInput)iEditorInput;
                IFile file = fileEditorInput.getFile();
                ICElement cElement = CoreModel.getDefault().create(file);
                if (cElement != null && (binaryFile = (IBinaryParser.IBinaryFile)cElement.getAdapter(IBinaryParser.IBinaryFile.class)) != null) {
                    this.setDocumentContent(document, this.getBinaryFileContent(binaryFile), encoding);
                    return true;
                }
            }
            return super.setDocumentContent(document, editorInput, encoding);
        }

        public boolean isModifiable(Object element) {
            return false;
        }

        public boolean isReadOnly(Object element) {
            return true;
        }
    }
}

