/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.llvm.util;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.resources.RefreshScopeManager;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.gnu.mingw.MingwEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.llvm.ui.LlvmEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.llvm.ui.preferences.LlvmPreferenceStore;
import org.eclipse.cdt.managedbuilder.llvm.util.FileUtil;
import org.eclipse.cdt.managedbuilder.llvm.util.ProjectIndex;
import org.eclipse.cdt.managedbuilder.llvm.util.Separators;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class LlvmToolOptionPathUtil {
    private static final String linkerInputType = "bc";
    private static final String[] inputTypes = new String[]{"cpp", "c"};
    public static final int INCLUDE = 1;
    public static final int LIB = 2;
    public static final int LIB_PATH = 3;

    public static void addLlvmIncludePath(String includePath) {
        LlvmToolOptionPathUtil.addPathToToolOption(includePath, 1);
    }

    public static void removeLlvmIncludePath(String includePath) {
        LlvmToolOptionPathUtil.removePathFromToolOption(includePath, 1);
    }

    public static void addLlvmLib(String lib) {
        LlvmToolOptionPathUtil.addPathToToolOption(lib, 2);
    }

    public static void removeLlvmLib(String lib) {
        LlvmToolOptionPathUtil.removePathFromToolOption(lib, 2);
    }

    public static void addLlvmLibraryPath(String libDir) {
        LlvmToolOptionPathUtil.addPathToToolOption(libDir, 3);
    }

    public static void removeLlvmLibraryPath(String libDir) {
        LlvmToolOptionPathUtil.removePathFromToolOption(libDir, 3);
    }

    private static void addPathToToolOption(String path, int var) {
        if (path.length() > 0 && (LlvmToolOptionPathUtil.pathExists(path) || var == 2)) {
            IProject[] projects;
            boolean success = false;
            IProject[] iProjectArray = projects = LlvmToolOptionPathUtil.getProjectsInWorkspace();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                IConfiguration[] configs = LlvmToolOptionPathUtil.getAllBuildConfigs(proj);
                if (configs.length > 0) {
                    IConfiguration[] iConfigurationArray = configs;
                    int n3 = configs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfiguration cf = iConfigurationArray[n4];
                        success = LlvmToolOptionPathUtil.addPathToSelectedToolOptionBuildConf(cf, path, var);
                        ++n4;
                    }
                    if (success) {
                        ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
                    }
                }
                ++n2;
            }
        }
    }

    private static void addPathToToolOptionCppProjects(String path, int var) {
        if (path.length() > 0 && (LlvmToolOptionPathUtil.pathExists(path) || var == 2)) {
            boolean success = false;
            IProject[] projects = LlvmToolOptionPathUtil.getProjectsInWorkspace();
            String projectPath = null;
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration[] configs;
                IProject proj = iProjectArray[n2];
                projectPath = proj.getLocation().toOSString();
                if (projectPath != null && FileUtil.containsCppFile(new File(projectPath)) && (configs = LlvmToolOptionPathUtil.getAllBuildConfigs(proj)).length > 0) {
                    IConfiguration[] iConfigurationArray = configs;
                    int n3 = configs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfiguration cf = iConfigurationArray[n4];
                        success = LlvmToolOptionPathUtil.addPathToSelectedToolOptionBuildConf(cf, path, var);
                        ++n4;
                    }
                    if (success) {
                        ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
                        ICProjectDescription projectDescription = CoreModel.getDefault().getProjectDescription(proj);
                        try {
                            CoreModel.getDefault().setProjectDescription(proj, projectDescription);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        RefreshScopeManager manager = RefreshScopeManager.getInstance();
                        IWorkspaceRunnable runnable = manager.getRefreshRunnable(proj);
                        try {
                            ResourcesPlugin.getWorkspace().run(runnable, null, 1, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                        ProjectIndex.rebuiltIndex(proj);
                    }
                }
                ++n2;
            }
        }
    }

    private static void removePathFromToolOption(String path, int var) {
        if (path.length() > 0 && LlvmToolOptionPathUtil.pathExists(path) || var == 2) {
            IProject[] projects;
            boolean success = false;
            IProject[] iProjectArray = projects = LlvmToolOptionPathUtil.getProjectsInWorkspace();
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                IProject proj = iProjectArray[n2];
                IConfiguration[] configs = LlvmToolOptionPathUtil.getAllBuildConfigs(proj);
                if (configs.length > 0) {
                    IConfiguration[] iConfigurationArray = configs;
                    int n3 = configs.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfiguration cf = iConfigurationArray[n4];
                        success = LlvmToolOptionPathUtil.removePathFromSelectedToolOptionBuildConf(cf, path, var);
                        ++n4;
                    }
                    if (success) {
                        ManagedBuildManager.saveBuildInfo((IProject)proj, (boolean)true);
                    }
                }
                ++n2;
            }
        }
    }

    private static boolean addPathToSelectedToolOptionBuildConf(IConfiguration cf, String path, int var) {
        switch (var) {
            case 1: {
                return LlvmToolOptionPathUtil.addLlvmIncludePathToToolOption(cf, path);
            }
            case 2: {
                return LlvmToolOptionPathUtil.addLlvmLibToToolOption(cf, path);
            }
            case 3: {
                return LlvmToolOptionPathUtil.addLlvmLibSearchPathToToolOption(cf, path);
            }
        }
        return false;
    }

    private static boolean removePathFromSelectedToolOptionBuildConf(IConfiguration cf, String path, int var) {
        switch (var) {
            case 1: {
                return LlvmToolOptionPathUtil.removeLlvmIncludePathFromToolOption(cf, path);
            }
            case 2: {
                return LlvmToolOptionPathUtil.removeLlvmLibFromToolOption(cf, path);
            }
            case 3: {
                return LlvmToolOptionPathUtil.removeLlvmLibSearchPathFromToolOption(cf, path);
            }
        }
        return false;
    }

    public static IProject[] getProjectsInWorkspace() {
        IWorkspace root = ResourcesPlugin.getWorkspace();
        return root.getRoot().getProjects();
    }

    private static IConfiguration[] getAllBuildConfigs(IProject proj) {
        IConfiguration[] configurations = new IConfiguration[]{};
        IManagedBuildInfo info = null;
        try {
            info = ManagedBuildManager.getBuildInfo((IResource)proj);
        }
        catch (Exception e) {
            e.printStackTrace();
            return configurations;
        }
        if (info == null) {
            return configurations;
        }
        IManagedProject mProj = info.getManagedProject();
        configurations = mProj.getConfigurations();
        return configurations;
    }

    private static boolean addLlvmIncludePathToToolOption(IConfiguration cf, String newIncludePath) {
        ITool llvmFrontEnd = LlvmToolOptionPathUtil.getLlvmFrontEnd(cf);
        if (llvmFrontEnd != null) {
            IOption llvmFrontEndIncPathOption = LlvmToolOptionPathUtil.getLlvmFrontEndIncludePathOption(cf);
            boolean val = LlvmToolOptionPathUtil.addIncludePathToToolOption(cf, llvmFrontEnd, llvmFrontEndIncPathOption, newIncludePath);
            return val;
        }
        return false;
    }

    private static boolean removeLlvmIncludePathFromToolOption(IConfiguration cf, String removeIncludePath) {
        ITool llvmFrontEnd = LlvmToolOptionPathUtil.getLlvmFrontEnd(cf);
        if (llvmFrontEnd != null) {
            IOption llvmFrontEndIncPathOption = LlvmToolOptionPathUtil.getLlvmFrontEndIncludePathOption(cf);
            LlvmToolOptionPathUtil.removeIncludePathFromToolOption(cf, llvmFrontEnd, llvmFrontEndIncPathOption, removeIncludePath);
            return true;
        }
        return false;
    }

    private static boolean addLlvmLibToToolOption(IConfiguration cf, String lib) {
        ITool llvmLinker = LlvmToolOptionPathUtil.getLlvmLinker(cf);
        if (llvmLinker != null) {
            IOption librariesOption = LlvmToolOptionPathUtil.getLlvmLinkerLibrariesOption(cf);
            boolean val = LlvmToolOptionPathUtil.addLibraryToToolOption(cf, llvmLinker, librariesOption, lib);
            return val;
        }
        return false;
    }

    private static boolean removeLlvmLibFromToolOption(IConfiguration cf, String removeLib) {
        ITool llvmLinker = LlvmToolOptionPathUtil.getLlvmLinker(cf);
        if (llvmLinker != null) {
            IOption librariesOption = LlvmToolOptionPathUtil.getLlvmLinkerLibrariesOption(cf);
            LlvmToolOptionPathUtil.removeLibraryFromToolOption(cf, llvmLinker, librariesOption, removeLib);
            return true;
        }
        return false;
    }

    private static boolean addLlvmLibSearchPathToToolOption(IConfiguration cf, String libDir) {
        ITool llvmLinker = LlvmToolOptionPathUtil.getLlvmLinker(cf);
        if (llvmLinker != null) {
            IOption libDirOption = LlvmToolOptionPathUtil.getLlvmLinkerLibrarySearchPathOption(cf);
            boolean val = LlvmToolOptionPathUtil.addLibrarySearchPathToToolOption(cf, llvmLinker, libDirOption, libDir);
            return val;
        }
        return false;
    }

    private static boolean removeLlvmLibSearchPathFromToolOption(IConfiguration cf, String removeLibDir) {
        ITool llvmLinker = LlvmToolOptionPathUtil.getLlvmLinker(cf);
        if (llvmLinker != null) {
            IOption libDirOption = LlvmToolOptionPathUtil.getLlvmLinkerLibrarySearchPathOption(cf);
            LlvmToolOptionPathUtil.removeLibrarySearchPathFromToolOption(cf, llvmLinker, libDirOption, removeLibDir);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addIncludePathToToolOption(IConfiguration cf, ITool cfTool, IOption option, String newIncludePath) {
        try {
            String[] incPaths;
            String[] stringArray = incPaths = option.getIncludePaths();
            int n = incPaths.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    LlvmToolOptionPathUtil.addInputToToolOption(cf, cfTool, option, newIncludePath, incPaths);
                    return true;
                }
                String inc = stringArray[n2];
                if (inc.equalsIgnoreCase(newIncludePath)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void removeIncludePathFromToolOption(IConfiguration cf, ITool cfTool, IOption option, String removeIncludePath) {
        try {
            LlvmToolOptionPathUtil.removeInputFromToolOption(cf, cfTool, option, removeIncludePath, option.getIncludePaths());
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addLibraryToToolOption(IConfiguration cf, ITool cfTool, IOption option, String newLibrary) {
        try {
            String[] libraries;
            if (option == null) return true;
            String[] stringArray = libraries = option.getLibraries();
            int n = libraries.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    LlvmToolOptionPathUtil.addInputToToolOption(cf, cfTool, option, newLibrary, libraries);
                    return true;
                }
                String lib = stringArray[n2];
                if (lib.equalsIgnoreCase(newLibrary)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void removeLibraryFromToolOption(IConfiguration cf, ITool cfTool, IOption option, String removeLibrary) {
        try {
            LlvmToolOptionPathUtil.removeInputFromToolOption(cf, cfTool, option, removeLibrary, option.getLibraries());
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean addLibrarySearchPathToToolOption(IConfiguration cf, ITool cfTool, IOption option, String newLibraryPath) {
        try {
            String[] libPaths;
            if (option == null) return true;
            String[] stringArray = libPaths = option.getLibraryPaths();
            int n = libPaths.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    LlvmToolOptionPathUtil.addInputToToolOption(cf, cfTool, option, newLibraryPath, libPaths);
                    return true;
                }
                String libPath = stringArray[n2];
                if (libPath.equalsIgnoreCase(newLibraryPath)) {
                    return false;
                }
                ++n2;
            }
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static void removeLibrarySearchPathFromToolOption(IConfiguration cf, ITool cfTool, IOption option, String removeSearchPath) {
        try {
            LlvmToolOptionPathUtil.removeInputFromToolOption(cf, cfTool, option, removeSearchPath, option.getLibraryPaths());
        }
        catch (BuildException e) {
            e.printStackTrace();
        }
    }

    private static void addInputToToolOption(IConfiguration cf, ITool cfTool, IOption option, String newValue, String[] existingValues) {
        if (option != null) {
            String[] newValues = LlvmToolOptionPathUtil.addNewPathToExistingPathList(existingValues, newValue);
            ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)cfTool, (IOption)option, (String[])newValues);
        }
    }

    private static void removeInputFromToolOption(IConfiguration cf, ITool cfTool, IOption option, String removeValue, String[] existingValues) {
        if (option != null && existingValues.length > 0) {
            String[] newValues = LlvmToolOptionPathUtil.removePathFromExistingPathList(existingValues, removeValue);
            ManagedBuildManager.setOption((IConfiguration)cf, (IHoldsOptions)cfTool, (IOption)option, (String[])newValues);
        }
    }

    private static ITool getLlvmFrontEnd(IConfiguration cf) {
        int i = 0;
        while (i < inputTypes.length) {
            ITool tool = LlvmToolOptionPathUtil.getIToolByInputType(cf, inputTypes[i]);
            if (tool != null) {
                return tool;
            }
            ++i;
        }
        return null;
    }

    private static ITool getLlvmLinker(IConfiguration cf) {
        return LlvmToolOptionPathUtil.getIToolByInputType(cf, linkerInputType);
    }

    private static ITool getIToolByInputType(IConfiguration cf, String ext) {
        return cf.getToolFromInputExtension(ext);
    }

    private static IOption getLlvmFrontEndIncludePathOption(IConfiguration cf) {
        ITool cfTool = LlvmToolOptionPathUtil.getLlvmFrontEnd(cf);
        String includeOptionId = LlvmToolOptionPathUtil.getOptionId(cfTool, 4);
        return LlvmToolOptionPathUtil.getIToolPathOption(cfTool, includeOptionId);
    }

    private static IOption getLlvmLinkerLibrariesOption(IConfiguration cf) {
        ITool cfTool = LlvmToolOptionPathUtil.getLlvmLinker(cf);
        String libOptionId = LlvmToolOptionPathUtil.getOptionId(cfTool, 6);
        return LlvmToolOptionPathUtil.getIToolPathOption(cfTool, libOptionId);
    }

    private static IOption getLlvmLinkerLibrarySearchPathOption(IConfiguration cf) {
        ITool cfTool = cf.getToolFromInputExtension(linkerInputType);
        String libDirOptionId = LlvmToolOptionPathUtil.getOptionId(cfTool, 9);
        return LlvmToolOptionPathUtil.getIToolPathOption(cfTool, libDirOptionId);
    }

    private static String getOptionId(ITool cfTool, int optionValueType) {
        IOption[] options;
        String optionId = null;
        IOption[] iOptionArray = options = cfTool.getOptions();
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            IOption opt = iOptionArray[n2];
            try {
                if (opt.getValueType() == optionValueType) {
                    optionId = opt.getId();
                    break;
                }
            }
            catch (BuildException buildException) {
                // empty catch block
            }
            ++n2;
        }
        return optionId;
    }

    private static IOption getIToolPathOption(ITool cfTool, String optionId) {
        return cfTool.getOptionById(optionId);
    }

    public static String[] addNewPathToExistingPathList(String[] existingPaths, String newPath) {
        String path;
        String pathSep = File.pathSeparator;
        ArrayList<String> newPathList = new ArrayList<String>();
        int i = 0;
        while (i < existingPaths.length) {
            path = existingPaths[i];
            newPathList.add(path);
            ++i;
        }
        String[] newPathArray = newPath.split(pathSep);
        int i2 = 0;
        while (i2 < newPathArray.length) {
            path = newPathArray[i2];
            newPathList.add(path);
            ++i2;
        }
        String[] newArray = newPathList.toArray(new String[0]);
        return newArray;
    }

    public static String[] removePathFromExistingPathList(String[] existingPaths, String removePath) {
        ArrayList<String> newPathList = new ArrayList<String>();
        int i = 0;
        while (i < existingPaths.length) {
            String path = existingPaths[i];
            newPathList.add(path);
            ++i;
        }
        newPathList.remove(removePath);
        String[] newArray = newPathList.toArray(new String[0]);
        return newArray;
    }

    public static String[] stringToArray(String str) {
        return str.split(System.getProperty("path.separator"));
    }

    public static String arrayToString(String[] array) {
        StringBuilder sB = new StringBuilder();
        if (array.length > 0) {
            String[] stringArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                String i = stringArray[n2];
                sB.append(i);
                sB.append(System.getProperty("path.separator"));
                ++n2;
            }
        }
        return sB.toString();
    }

    private static boolean pathExists(String path) {
        return new File(path).exists();
    }

    private static String[] getAllIncludePaths() {
        String includePathList = LlvmPreferenceStore.getIncludePath();
        String[] incPaths = includePathList.split(Separators.getPathSeparator());
        return incPaths;
    }

    private static String[] getAllLibraries() {
        String libList = LlvmPreferenceStore.getLibraries();
        String[] libs = libList.split(Separators.getPathSeparator());
        return libs;
    }

    private static String[] getAllLibraryPaths() {
        String libPathList = LlvmPreferenceStore.getLibraryPath();
        String[] libPaths = libPathList.split(Separators.getPathSeparator());
        return libPaths;
    }

    public static void addAllIncludesToBuildConf() {
        String[] includes;
        String[] stringArray = includes = LlvmToolOptionPathUtil.getAllIncludePaths();
        int n = includes.length;
        int n2 = 0;
        while (n2 < n) {
            String inc = stringArray[n2];
            LlvmToolOptionPathUtil.addLlvmIncludePath(inc);
            ++n2;
        }
    }

    public static void addAllLibsToBuildConf() {
        String[] libs;
        String[] stringArray = libs = LlvmToolOptionPathUtil.getAllLibraries();
        int n = libs.length;
        int n2 = 0;
        while (n2 < n) {
            String lib = stringArray[n2];
            LlvmToolOptionPathUtil.addLlvmLib(lib);
            ++n2;
        }
    }

    public static void addAllLibPathsToBuildConf() {
        String[] libPaths;
        String[] stringArray = libPaths = LlvmToolOptionPathUtil.getAllLibraryPaths();
        int n = libPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String libPath = stringArray[n2];
            LlvmToolOptionPathUtil.addLlvmLibraryPath(libPath);
            ++n2;
        }
    }

    public static void addMissingCppIncludesForMingw() {
        MingwEnvironmentVariableSupplier mingwEnvironmentVariables = new MingwEnvironmentVariableSupplier();
        IBuildEnvironmentVariable mingwPath = mingwEnvironmentVariables.getVariable("PATH", null, null);
        String[] mingwPaths = mingwPath.getValue().split(Separators.getPathSeparator());
        int i = 0;
        while (i < mingwPaths.length) {
            if (mingwPaths[i].contains("bin")) {
                mingwPaths[i] = mingwPaths[i].replace("bin", "");
            }
            ++i;
        }
        File f1 = null;
        String rightPath = null;
        int i2 = 0;
        while (i2 < mingwPaths.length) {
            f1 = new File(String.valueOf(mingwPaths[i2]) + "lib/gcc/mingw32");
            if (f1.exists()) {
                rightPath = f1.getAbsolutePath();
                break;
            }
            ++i2;
        }
        if (rightPath != null && f1 != null) {
            File testFile = new File(String.valueOf((f1 = f1.listFiles()[0]).getAbsolutePath()) + "/include/c++");
            if (testFile.exists()) {
                LlvmPreferenceStore.appendIncludePath(testFile.getAbsolutePath());
                LlvmToolOptionPathUtil.addPathToToolOptionCppProjects(testFile.getAbsolutePath(), 1);
            }
            if ((testFile = new File(String.valueOf(f1.getAbsolutePath()) + "/include/c++/mingw32")).exists()) {
                LlvmPreferenceStore.appendIncludePath(testFile.getAbsolutePath());
                LlvmToolOptionPathUtil.addPathToToolOptionCppProjects(testFile.getAbsolutePath(), 1);
            }
            if ((testFile = new File(String.valueOf(f1.getAbsolutePath()) + "/include/c++/backward")).exists()) {
                LlvmPreferenceStore.appendIncludePath(testFile.getAbsolutePath());
                LlvmToolOptionPathUtil.addPathToToolOptionCppProjects(testFile.getAbsolutePath(), 1);
            }
            LlvmEnvironmentVariableSupplier.notifyPreferenceChange();
        }
    }
}

