/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.dataprovider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.build.internal.core.scannerconfig2.CfgScannerConfigInfoFactory2;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.LanguageSettingsManager;
import org.eclipse.cdt.core.language.settings.providers.ScannerDiscoveryLegacySupport;
import org.eclipse.cdt.core.model.ILanguageDescriptor;
import org.eclipse.cdt.core.model.LanguageManager;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICExternalSetting;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.core.settings.model.IModificationContext;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationDataProvider;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IBuilder;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IFolderInfo;
import org.eclipse.cdt.managedbuilder.core.IInputType;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IResourceInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.Builder;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.Configuration;
import org.eclipse.cdt.managedbuilder.internal.core.ISettingsChangeListener;
import org.eclipse.cdt.managedbuilder.internal.core.InputType;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.NotificationManager;
import org.eclipse.cdt.managedbuilder.internal.core.SettingsChangeEvent;
import org.eclipse.cdt.managedbuilder.internal.core.Tool;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildConfigurationData;
import org.eclipse.cdt.managedbuilder.internal.dataprovider.BuildLanguageData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentType;

public class ConfigurationDataProvider
extends CConfigurationDataProvider
implements ISettingsChangeListener {
    private static final String BUILD_SYSTEM_DATA_MODULE_NAME = "cdtBuildSystem";
    private static final String VERSION_ATTRIBUTE = "version";
    private static final String PREF_CFG_ID = "org.eclipse.cdt.build.core.prefbase.cfg";
    public static final String PREF_TC_ID = "org.eclipse.cdt.build.core.prefbase.toolchain";
    private static final String PREF_TOOL_ID = "org.eclipse.cdt.build.core.settings.holder";
    private static final QualifiedName CFG_PERSISTED_PROPERTY = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "configPersisted");
    private static final QualifiedName NATURES_USED_ON_CACHE_PROPERTY = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "naturesUsedOnCache");
    private static final QualifiedName BUILD_INFO_PROPERTY = new QualifiedName(ManagedBuilderCorePlugin.getUniqueIdentifier(), "buildInfo");
    private static boolean registered;

    public ConfigurationDataProvider() {
        if (!registered) {
            registered = true;
            NotificationManager.getInstance().subscribe(this);
        }
    }

    static BuildConfigurationData writeConfiguration(ICConfigurationDescription cfgDescription, BuildConfigurationData baseData) throws CoreException {
        BuildConfigurationData appliedCfg = baseData;
        ICStorageElement rootElement = cfgDescription.getStorage(BUILD_SYSTEM_DATA_MODULE_NAME, true);
        rootElement.clear();
        rootElement.setAttribute(VERSION_ATTRIBUTE, ManagedBuildManager.getVersion().toString());
        ICStorageElement cfgElemen = rootElement.createChild("configuration");
        Configuration cfg = (Configuration)appliedCfg.getConfiguration();
        Builder b = (Builder)cfg.getEditableBuilder();
        cfg.setConfigurationDescription(cfgDescription);
        if (b != null && b.isManagedBuildOn() && b.getBuildPathAttribute(false) == null) {
            String bPath = b.getDefaultBuildPath();
            b.setBuildPathAttribute(bPath);
        }
        cfg.serialize(cfgElemen);
        return appliedCfg;
    }

    protected CConfigurationData applyPreferences(ICConfigurationDescription cfgDescription, CConfigurationData baseData) throws CoreException {
        BuildConfigurationData appliedCfg = ConfigurationDataProvider.writeConfiguration(cfgDescription, (BuildConfigurationData)baseData);
        IConfiguration cfg = ((BuildConfigurationData)baseData).getConfiguration();
        try {
            CfgScannerConfigInfoFactory2.savePreference(cfg);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return appliedCfg;
    }

    public CConfigurationData applyConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData baseData, IModificationContext context, IProgressMonitor monitor) throws CoreException {
        BuildConfigurationData appliedCfgData;
        if (cfgDescription.isPreferenceConfiguration()) {
            return this.applyPreferences(cfgDescription, baseData);
        }
        BuildConfigurationData baseCfgData = (BuildConfigurationData)baseData;
        IConfiguration baseCfg = baseCfgData.getConfiguration();
        if (context.isBaseDataCached() && !baseCfg.isDirty()) {
            appliedCfgData = baseCfgData;
            context.setConfigurationSettingsFlags(3);
        } else {
            appliedCfgData = ConfigurationDataProvider.writeConfiguration(cfgDescription, baseCfgData);
            IManagedBuildInfo info = ConfigurationDataProvider.getBuildInfo(cfgDescription);
            ManagedProject mProj = (ManagedProject)info.getManagedProject();
            mProj.applyConfiguration((Configuration)appliedCfgData.getConfiguration());
            ConfigurationDataProvider.writeManagedProjectInfo(cfgDescription.getProjectDescription(), mProj);
            if (baseCfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                List providers;
                String[] defaultIds = ((ILanguageSettingsProvidersKeeper)baseCfgDescription).getDefaultLanguageSettingsProvidersIds();
                if (defaultIds == null) {
                    IConfiguration cfg;
                    ICProjectDescription prjDescription = baseCfgDescription.getProjectDescription();
                    if (prjDescription != null) {
                        IProject project = prjDescription.getProject();
                        ScannerDiscoveryLegacySupport.defineLanguageSettingsEnablement((IProject)project);
                    }
                    String[] stringArray = defaultIds = (cfg = appliedCfgData.getConfiguration()) != null ? cfg.getDefaultLanguageSettingsProviderIds() : null;
                    if (defaultIds == null) {
                        defaultIds = ScannerDiscoveryLegacySupport.getDefaultProviderIdsLegacy((ICConfigurationDescription)baseCfgDescription);
                    }
                    providers = LanguageSettingsManager.createLanguageSettingsProviders((String[])defaultIds);
                } else {
                    providers = ((ILanguageSettingsProvidersKeeper)baseCfgDescription).getLanguageSettingProviders();
                }
                if (cfgDescription instanceof ILanguageSettingsProvidersKeeper) {
                    ((ILanguageSettingsProvidersKeeper)cfgDescription).setDefaultLanguageSettingsProvidersIds(defaultIds);
                    ((ILanguageSettingsProvidersKeeper)cfgDescription).setLanguageSettingProviders(providers);
                }
            }
            try {
                CfgScannerConfigInfoFactory2.save(appliedCfgData, cfgDescription.getProjectDescription(), baseCfgDescription.getProjectDescription(), !this.isPersistedCfg(cfgDescription));
            }
            catch (CoreException e) {
                ManagedBuilderCorePlugin.log(e);
            }
            info.setValid(true);
            ManagedBuildManager.setLoaddedBuildInfo(cfgDescription.getProjectDescription().getProject(), info);
            this.setPersistedFlag(cfgDescription);
            ConfigurationDataProvider.cacheNaturesIdsUsedOnCache(cfgDescription);
        }
        if (cfgDescription.isActive()) {
            IConfiguration cfg = appliedCfgData.getConfiguration();
            IBuilder builder = cfg.getEditableBuilder();
            IProject project = context.getProject();
            IProjectDescription eDes = context.getEclipseProjectDescription();
            switch (BuilderFactory.applyBuilder(eDes, builder)) {
                case -1: {
                    DesApplyRunnable applyR = new DesApplyRunnable(project, builder);
                    context.addWorkspaceRunnable((IWorkspaceRunnable)applyR);
                    break;
                }
                case 1: {
                    context.setEclipseProjectDescription(eDes);
                }
            }
        }
        return appliedCfgData;
    }

    private void setPersistedFlag(ICConfigurationDescription cfgDescription) {
        cfgDescription.setSessionProperty(CFG_PERSISTED_PROPERTY, (Object)Boolean.TRUE);
    }

    private static void writeManagedProjectInfo(ICProjectDescription prjDescription, ManagedProject mProj) throws CoreException {
        ICStorageElement rootElement = prjDescription.getStorage(BUILD_SYSTEM_DATA_MODULE_NAME, true);
        rootElement.clear();
        rootElement.setAttribute(VERSION_ATTRIBUTE, ManagedBuildManager.getVersion().toString());
        ICStorageElement mProjElem = rootElement.createChild("project");
        mProj.serializeProjectInfo(mProjElem);
    }

    protected CConfigurationData createPreferences(ICConfigurationDescription cfgDescription, CConfigurationData baseData) throws CoreException {
        Configuration cfg = (Configuration)((BuildConfigurationData)baseData).getConfiguration();
        Configuration newCfg = new Configuration((ManagedProject)cfg.getManagedProject(), cfg, cfgDescription.getId(), true, true, true);
        newCfg.setConfigurationDescription(cfgDescription);
        newCfg.setName(cfgDescription.getName());
        return newCfg.getConfigurationData();
    }

    public CConfigurationData createConfiguration(ICConfigurationDescription cfgDescription, ICConfigurationDescription baseCfgDescription, CConfigurationData base, boolean clone, IProgressMonitor monitor) throws CoreException {
        if (cfgDescription.isPreferenceConfiguration()) {
            return this.createPreferences(cfgDescription, base);
        }
        Configuration cfg = (Configuration)((BuildConfigurationData)base).getConfiguration();
        Configuration newCfg = ConfigurationDataProvider.copyCfg(cfg, cfgDescription);
        if (!newCfg.getId().equals(cfg.getId()) && newCfg.canExportedArtifactInfo()) {
            ICExternalSetting[] iCExternalSettingArray = newCfg.getConfigurationDescription().getExternalSettings();
            int n = iCExternalSettingArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICExternalSetting extSetting = iCExternalSettingArray[n2];
                newCfg.getConfigurationDescription().removeExternalSetting(extSetting);
                ++n2;
            }
            newCfg.exportArtifactInfo();
        }
        this.setPersistedFlag(cfgDescription);
        return newCfg.getConfigurationData();
    }

    public static Configuration copyCfg(Configuration cfg, ICConfigurationDescription cfgDescription) {
        IManagedBuildInfo info = ConfigurationDataProvider.getBuildInfo(cfgDescription);
        ManagedProject mProj = (ManagedProject)info.getManagedProject();
        Configuration newCfg = new Configuration(mProj, cfg, cfgDescription.getId(), true, true, false);
        newCfg.setConfigurationDescription(cfgDescription);
        newCfg.setName(cfgDescription.getName());
        cfgDescription.setConfigurationData(cfgDescription.getBuildSystemId(), newCfg.getConfigurationData());
        ManagedBuildManager.performValueHandlerEvent(newCfg, 1);
        return newCfg;
    }

    private static IManagedBuildInfo getBuildInfo(ICConfigurationDescription cfgDescription) {
        ICProjectDescription projDes = cfgDescription.getProjectDescription();
        IProject project = projDes.getProject();
        IManagedBuildInfo info = ManagedBuildManager.getBuildInfo((IResource)project, false);
        if (info == null) {
            info = ManagedBuildManager.createBuildInfo((IResource)project);
        }
        ConfigurationDataProvider.setLoaddedBuildInfo(projDes, info);
        ConfigurationDataProvider.getManagedProject(cfgDescription, info);
        return info;
    }

    private static void setLoaddedBuildInfo(ICProjectDescription prjDescription, IManagedBuildInfo info) {
        prjDescription.setSessionProperty(BUILD_INFO_PROPERTY, (Object)info);
    }

    public static ManagedBuildInfo getLoaddedBuildInfo(ICProjectDescription prjDescription) {
        return (ManagedBuildInfo)prjDescription.getSessionProperty(BUILD_INFO_PROPERTY);
    }

    private static IManagedProject getManagedProject(ICConfigurationDescription cfgDescription, IManagedBuildInfo info) {
        IManagedProject mProj = info.getManagedProject();
        if (mProj == null) {
            mProj = ConfigurationDataProvider.createManagedProject(info, cfgDescription.getProjectDescription());
        }
        return mProj;
    }

    private static IManagedProject createManagedProject(IManagedBuildInfo info, ICProjectDescription prjDescription) {
        ManagedProject mProj;
        block5: {
            mProj = null;
            try {
                ICStorageElement rootElem = prjDescription.getStorage(BUILD_SYSTEM_DATA_MODULE_NAME, false);
                if (rootElem == null) break block5;
                String version = rootElem.getAttribute(VERSION_ATTRIBUTE);
                ICStorageElement[] children = rootElem.getChildren();
                int i = 0;
                while (i < children.length) {
                    if ("project".equals(children[i].getName())) {
                        mProj = new ManagedProject((ManagedBuildInfo)info, children[i], false, version);
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (mProj == null) {
            mProj = new ManagedProject(prjDescription);
            info.setManagedProject(mProj);
        }
        return mProj;
    }

    public static String[] getNaturesIdsUsedOnCache(IConfiguration cfg) {
        ICConfigurationDescription cfgDescription = ManagedBuildManager.getDescriptionForConfiguration(cfg);
        if (cfgDescription != null) {
            return ConfigurationDataProvider.getNaturesIdsUsedOnCache(cfgDescription);
        }
        return null;
    }

    public static String[] getNaturesIdsUsedOnCache(ICConfigurationDescription cfgDescription) {
        String[] strs = (String[])cfgDescription.getSessionProperty(NATURES_USED_ON_CACHE_PROPERTY);
        return strs != null && strs.length != 0 ? (String[])strs.clone() : strs;
    }

    public static void cacheNaturesIdsUsedOnCache(ICConfigurationDescription cfgDescription) {
        IProject project = cfgDescription.getProjectDescription().getProject();
        try {
            IProjectDescription eDes = project.getDescription();
            String[] natures = eDes.getNatureIds();
            ConfigurationDataProvider.setNaturesIdsUsedOnCache(cfgDescription, natures);
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    private static void setNaturesIdsUsedOnCache(ICConfigurationDescription cfgDescription, String[] ids) {
        ids = ids != null && ids.length != 0 ? (String[])ids.clone() : ids;
        cfgDescription.setSessionProperty(NATURES_USED_ON_CACHE_PROPERTY, (Object)ids);
    }

    private Configuration load(ICConfigurationDescription cfgDescription, ManagedProject mProj, boolean isPreference) throws CoreException {
        ICStorageElement rootElement = cfgDescription.getStorage(BUILD_SYSTEM_DATA_MODULE_NAME, true);
        ICStorageElement[] children = rootElement.getChildren();
        String version = rootElement.getAttribute(VERSION_ATTRIBUTE);
        Configuration cfg = null;
        int i = 0;
        while (i < children.length) {
            if ("configuration".equals(children[i].getName())) {
                cfg = new Configuration(mProj, children[i], version, isPreference);
                ManagedBuildManager.performValueHandlerEvent(cfg, 1);
                break;
            }
            ++i;
        }
        return cfg;
    }

    protected CConfigurationData loadPreferences(ICConfigurationDescription cfgDescription) throws CoreException {
        Configuration cfg = this.load(cfgDescription, null, true);
        cfg = ConfigurationDataProvider.updatePreferenceOnLoad(cfg, cfgDescription);
        cfg.setConfigurationDescription(cfgDescription);
        return cfg.getConfigurationData();
    }

    public static Configuration getClearPreference(String id) {
        Configuration cfg = ConfigurationDataProvider.createEmptyPrefConfiguration(id, null);
        cfg = ConfigurationDataProvider.adjustPreferenceConfig(cfg);
        return cfg;
    }

    private static Configuration updatePreferenceOnLoad(Configuration cfg, ICConfigurationDescription cfgDescription) {
        if (cfg == null) {
            cfg = ConfigurationDataProvider.createEmptyPrefConfiguration(cfgDescription.getId(), cfgDescription.getName());
        }
        cfg = ConfigurationDataProvider.adjustPreferenceConfig(cfg);
        return cfg;
    }

    private static Configuration adjustPreferenceConfig(Configuration cfg) {
        LanguageManager mngr = LanguageManager.getInstance();
        ILanguageDescriptor[] dess = mngr.getLanguageDescriptors();
        Map map = mngr.getContentTypeIdToLanguageDescriptionsMap();
        IResourceInfo[] rcInfos = cfg.getResourceInfos();
        int i = 0;
        while (i < rcInfos.length) {
            if (rcInfos[i] instanceof IFolderInfo) {
                ConfigurationDataProvider.adjustFolderInfo((IFolderInfo)rcInfos[i], dess, new HashMap<Object, ILanguageDescriptor[]>(map));
            }
            ++i;
        }
        return cfg;
    }

    private static void adjustFolderInfo(IFolderInfo info, ILanguageDescriptor[] dess, HashMap<Object, ILanguageDescriptor[]> map) {
        IToolChain tch = info.getToolChain();
        HashMap<String, ILanguageDescriptor> langMap = new HashMap<String, ILanguageDescriptor>();
        int i = 0;
        while (i < dess.length) {
            langMap.put(dess[i].getId(), dess[i]);
            ++i;
        }
        if (PREF_TC_ID.equals(tch.getSuperClass().getId())) {
            ITool[] tools = tch.getTools();
            int i2 = 0;
            while (i2 < tools.length) {
                Tool tool = (Tool)tools[i2];
                IInputType[] types = tool.getAllInputTypes();
                int k = 0;
                while (k < types.length) {
                    InputType type = (InputType)types[k];
                    String langId = type.getLanguageId(tool);
                    if (langId != null) {
                        ILanguageDescriptor des = (ILanguageDescriptor)langMap.remove(langId);
                        if (des != null) {
                            ConfigurationDataProvider.adjustInputType(tool, type, des);
                        }
                    } else {
                        IContentType[] cTypes = type.getSourceContentTypes();
                        int c = 0;
                        while (c < cTypes.length) {
                            IContentType cType = cTypes[c];
                            ILanguageDescriptor[] langs = map.remove(cType.getId());
                            if (langs != null && langs.length != 0) {
                                int q = 0;
                                while (q < langs.length) {
                                    langMap.remove(langs[q].getId());
                                    ++q;
                                }
                                ConfigurationDataProvider.adjustInputType(tool, type, langs[0]);
                            }
                            ++c;
                        }
                    }
                    ++k;
                }
                ++i2;
            }
            if (!langMap.isEmpty()) {
                ConfigurationDataProvider.addTools(tch, langMap, map);
            }
        }
    }

    private static InputType adjustInputType(Tool tool, InputType type, ILanguageDescriptor des) {
        String[] cTypeIds = des.getContentTypeIds();
        String[] srcIds = type.getSourceContentTypeIds();
        String[] hIds = type.getHeaderContentTypeIds();
        HashSet<String> landTypes = new HashSet<String>(Arrays.asList(cTypeIds));
        landTypes.removeAll(Arrays.asList(srcIds));
        landTypes.removeAll(Arrays.asList(hIds));
        if (landTypes.size() != 0) {
            ArrayList<String> srcList = new ArrayList<String>();
            srcList.addAll(landTypes);
            type = (InputType)tool.getEditableInputType(type);
            type.setSourceContentTypeIds(srcList.toArray(new String[srcList.size()]));
        }
        if (!des.getId().equals(type.getLanguageId(tool))) {
            type = (InputType)tool.getEditableInputType(type);
            type.setLanguageIdAttribute(des.getId());
            type.setLanguageNameAttribute(des.getName());
        }
        return type;
    }

    private static void addTools(IToolChain tc, Map<String, ILanguageDescriptor> langMap, Map<Object, ILanguageDescriptor[]> cTypeToLangMap) {
        ITool extTool = ManagedBuildManager.getExtensionTool(PREF_TOOL_ID);
        ArrayList<ILanguageDescriptor> list = new ArrayList<ILanguageDescriptor>(langMap.values());
        while (list.size() != 0) {
            ILanguageDescriptor des = (ILanguageDescriptor)list.remove(list.size() - 1);
            String[] ctypeIds = des.getContentTypeIds();
            boolean addLang = false;
            int i = 0;
            while (i < ctypeIds.length) {
                ILanguageDescriptor[] langs = cTypeToLangMap.remove(ctypeIds[i]);
                if (langs != null && langs.length != 0) {
                    addLang = true;
                    int q = 0;
                    while (q < langs.length) {
                        list.remove(langs[q]);
                        ++q;
                    }
                }
                ++i;
            }
            if (!addLang) continue;
            String id = ManagedBuildManager.calculateChildId(extTool.getId(), null);
            String name = des.getName();
            Tool tool = (Tool)tc.createTool(extTool, id, name, false);
            InputType type = (InputType)tool.getInputTypes()[0];
            type = (InputType)tool.getEditableInputType(type);
            type.setSourceContentTypes(des.getContentTypes());
            type.setLanguageNameAttribute(des.getName());
            type.setName(des.getName());
            type.setLanguageIdAttribute(des.getId());
        }
    }

    private static Configuration createEmptyPrefConfiguration(String id, String name) {
        Configuration extCfg = (Configuration)ManagedBuildManager.getExtensionConfiguration(PREF_CFG_ID);
        Configuration emptyPrefCfg = null;
        if (extCfg != null) {
            if (id == null) {
                id = ManagedBuildManager.calculateChildId(extCfg.getId(), null);
            }
            if (name == null) {
                name = extCfg.getName();
            }
            emptyPrefCfg = new Configuration(null, extCfg, id, false, true, true);
            emptyPrefCfg.setName(name);
            emptyPrefCfg.setPerRcTypeDiscovery(false);
        }
        return emptyPrefCfg;
    }

    public CConfigurationData loadConfiguration(ICConfigurationDescription cfgDescription, IProgressMonitor monitor) throws CoreException {
        if (cfgDescription.isPreferenceConfiguration()) {
            return this.loadPreferences(cfgDescription);
        }
        IManagedBuildInfo info = ConfigurationDataProvider.getBuildInfo(cfgDescription);
        Configuration cfg = this.load(cfgDescription, (ManagedProject)info.getManagedProject(), false);
        if (cfg != null) {
            String[] defaultIds;
            IProject project = cfgDescription.getProjectDescription().getProject();
            cfg.setConfigurationDescription(cfgDescription);
            info.setValid(true);
            this.setPersistedFlag(cfgDescription);
            ConfigurationDataProvider.cacheNaturesIdsUsedOnCache(cfgDescription);
            ManagedBuildManager.setLoaddedBuildInfo(project, info);
            if (cfgDescription instanceof ILanguageSettingsProvidersKeeper && (defaultIds = cfg.getDefaultLanguageSettingsProviderIds()) != null) {
                ((ILanguageSettingsProvidersKeeper)cfgDescription).setDefaultLanguageSettingsProvidersIds(defaultIds);
            }
            return cfg.getConfigurationData();
        }
        return null;
    }

    private boolean isPersistedCfg(ICConfigurationDescription cfgDescription) {
        return cfgDescription.getSessionProperty(CFG_PERSISTED_PROPERTY) != null;
    }

    @Override
    public void settingsChanged(SettingsChangeEvent event) {
        BuildLanguageData[] datas = (BuildLanguageData[])event.getRcInfo().getCLanguageDatas();
        IOption option = event.getOption();
        try {
            int type = option.getValueType();
            int i = 0;
            while (i < datas.length) {
                datas[i].optionsChanged(type);
                ++i;
            }
        }
        catch (BuildException e) {
            ManagedBuilderCorePlugin.log(e);
        }
    }

    public void removeConfiguration(ICConfigurationDescription cfgDescription, CConfigurationData data, IProgressMonitor monitor) {
        IConfiguration cfg = ((BuildConfigurationData)data).getConfiguration();
        ManagedBuildManager.performValueHandlerEvent(cfg, 2);
        IManagedBuildInfo info = ConfigurationDataProvider.getBuildInfo(cfgDescription);
        IManagedProject mProj = info.getManagedProject();
        mProj.removeConfiguration(cfg.getId());
    }

    public void dataCached(ICConfigurationDescription cfgDescription, CConfigurationData data, IProgressMonitor monitor) {
        BuildConfigurationData cfgData = (BuildConfigurationData)data;
        ((Configuration)cfgData.getConfiguration()).setConfigurationDescription(cfgDescription);
        cfgData.clearCachedData();
    }

    private static class DesApplyRunnable
    implements IWorkspaceRunnable {
        IBuilder fBuilder;
        IProject fProject;

        DesApplyRunnable(IProject project, IBuilder builder) {
            this.fProject = project;
            this.fBuilder = builder;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                IProjectDescription eDes = this.fProject.getDescription();
                if (BuilderFactory.applyBuilder(eDes, this.fBuilder) == 1) {
                    this.fProject.setDescription(eDes, monitor);
                }
            }
            catch (Exception e) {
                ManagedBuilderCorePlugin.log(e);
            }
        }
    }
}

