/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.serial.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.serial.BaudRate;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.remote.core.IRemoteConnectionWorkingCopy;
import org.eclipse.remote.serial.internal.ui.Activator;
import org.eclipse.remote.serial.internal.ui.Messages;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SerialPortConnectionBlock {
    private String name;
    private String portName;
    private int baudRateIndex;
    private int byteSizeIndex;
    private int parityIndex;
    private int stopBitsIndex;
    private String[] portNames;
    private Text nameText;
    private Combo portCombo;
    private Combo baudRateCombo;
    private Combo byteSizeCombo;
    private Combo parityCombo;
    private Combo stopBitsCombo;
    private boolean isComplete;
    private List<SerialBlockUpdateListener> listeners = new ArrayList<SerialBlockUpdateListener>();

    public void createBlock(Composite comp, IRemoteConnectionWorkingCopy wc) {
        String name = "";
        String connectionPortName = "";
        int baudRateStringIndex = BaudRate.getStringIndex((BaudRate)BaudRate.getDefault());
        int byteSizeStringIndex = ByteSize.getStringIndex((ByteSize)ByteSize.getDefault());
        int parityStringIndex = Parity.getStringIndex((Parity)Parity.getDefault());
        int stopBitsStringIndex = StopBits.getStringIndex((StopBits)StopBits.getDefault());
        if (wc != null) {
            name = wc.getName();
            connectionPortName = wc.getAttribute("serial.portName");
            baudRateStringIndex = Integer.parseInt(wc.getAttribute("serial.baudRate"));
            byteSizeStringIndex = Integer.parseInt(wc.getAttribute("serial.byteSize"));
            parityStringIndex = Integer.parseInt(wc.getAttribute("serial.parity"));
            stopBitsStringIndex = Integer.parseInt(wc.getAttribute("serial.stopBits"));
        }
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Messages.NewSerialPortConnectionWizardPage_NameLabel);
        this.nameText = new Text(comp, 2052);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setText(name);
        this.nameText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                SerialPortConnectionBlock.this.updateStatus();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.NewSerialPortConnectionWizardPage_PortLabel);
        this.portCombo = new Combo(comp, 8);
        this.portCombo.setLayoutData((Object)new GridData(768));
        try {
            this.portNames = SerialPort.list();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        int index = 0;
        int portNameIndex = 0;
        String[] stringArray = this.portNames;
        int n = this.portNames.length;
        int n2 = 0;
        while (n2 < n) {
            String portName = stringArray[n2];
            this.portCombo.add(portName);
            if (portName.equals(connectionPortName)) {
                portNameIndex = index;
            }
            ++index;
            ++n2;
        }
        this.portCombo.select(portNameIndex);
        this.portCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialPortConnectionBlock.this.updateStatus();
            }
        });
        Label baudRateLabel = new Label(comp, 0);
        baudRateLabel.setText(Messages.NewSerialPortConnectionWizardPage_BaudRateLabel);
        this.baudRateCombo = new Combo(comp, 8);
        this.baudRateCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray2 = BaudRate.getStrings();
        int n3 = stringArray2.length;
        n = 0;
        while (n < n3) {
            String baudRateStr = stringArray2[n];
            this.baudRateCombo.add(baudRateStr);
            ++n;
        }
        this.baudRateCombo.select(baudRateStringIndex);
        this.baudRateCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialPortConnectionBlock.this.updateStatus();
            }
        });
        Label byteSizeLabel = new Label(comp, 0);
        byteSizeLabel.setText(Messages.NewSerialPortConnectionWizardPage_ByteSizeLabel);
        this.byteSizeCombo = new Combo(comp, 8);
        this.byteSizeCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray3 = ByteSize.getStrings();
        int n4 = stringArray3.length;
        n3 = 0;
        while (n3 < n4) {
            String byteSizeStr = stringArray3[n3];
            this.byteSizeCombo.add(byteSizeStr);
            ++n3;
        }
        this.byteSizeCombo.select(byteSizeStringIndex);
        this.byteSizeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialPortConnectionBlock.this.updateStatus();
            }
        });
        Label parityLabel = new Label(comp, 0);
        parityLabel.setText(Messages.NewSerialPortConnectionWizardPage_ParityLabel);
        this.parityCombo = new Combo(comp, 8);
        this.parityCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray4 = Parity.getStrings();
        int n5 = stringArray4.length;
        n4 = 0;
        while (n4 < n5) {
            String parityStr = stringArray4[n4];
            this.parityCombo.add(parityStr);
            ++n4;
        }
        this.parityCombo.select(parityStringIndex);
        this.parityCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialPortConnectionBlock.this.updateStatus();
            }
        });
        Label stopBitsLabel = new Label(comp, 0);
        stopBitsLabel.setText(Messages.NewSerialPortConnectionWizardPage_StopBitsLabel);
        this.stopBitsCombo = new Combo(comp, 8);
        this.stopBitsCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray5 = StopBits.getStrings();
        int n6 = stringArray5.length;
        n5 = 0;
        while (n5 < n6) {
            String stopBitsStr = stringArray5[n5];
            this.stopBitsCombo.add(stopBitsStr);
            ++n5;
        }
        this.stopBitsCombo.select(stopBitsStringIndex);
        this.stopBitsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialPortConnectionBlock.this.updateStatus();
            }
        });
        this.updateStatus();
    }

    private void updateStatus() {
        this.name = this.nameText.getText();
        int portIndex = this.portCombo.getSelectionIndex();
        this.portName = portIndex < 0 ? null : this.portNames[portIndex];
        this.baudRateIndex = this.baudRateCombo.getSelectionIndex();
        this.byteSizeIndex = this.byteSizeCombo.getSelectionIndex();
        this.parityIndex = this.parityCombo.getSelectionIndex();
        this.stopBitsIndex = this.stopBitsCombo.getSelectionIndex();
        this.isComplete = !this.name.isEmpty() && this.portName != null;
        for (SerialBlockUpdateListener listener : this.listeners) {
            listener.update();
        }
    }

    public String getConnectionName() {
        return this.name;
    }

    public String getPortName() {
        return this.portName;
    }

    public int getBaudRateIndex() {
        return this.baudRateIndex;
    }

    public int getByteSizeIndex() {
        return this.byteSizeIndex;
    }

    public int getParityIndex() {
        return this.parityIndex;
    }

    public int getStopBitsIndex() {
        return this.stopBitsIndex;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void addUpdateListener(SerialBlockUpdateListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeUpdateListener(SerialBlockUpdateListener listener) {
        this.listeners.remove(listener);
    }

    public abstract class SerialBlockUpdateListener {
        public abstract void update();
    }
}

