/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.core.autotools.core;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.cdt.core.autotools.core.AutotoolsBuildConfiguration;
import org.eclipse.cdt.core.autotools.core.internal.Activator;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfigurationManager;
import org.eclipse.cdt.core.build.ICBuildConfigurationProvider;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.build.IToolChainManager;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;

public class AutotoolsBuildConfigurationProvider
implements ICBuildConfigurationProvider {
    public static final String ID = "org.eclipse.cdt.core.autotools.core.provider";
    private ICBuildConfigurationManager configManager = Activator.getService(ICBuildConfigurationManager.class);

    public String getId() {
        return ID;
    }

    public ICBuildConfiguration getCBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        if (config.getName().equals("")) {
            IToolChain tc;
            IToolChain toolChain = null;
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("os", Platform.getOS());
            properties.put("arch", Platform.getOSArch());
            IToolChainManager toolChainManager = Activator.getService(IToolChainManager.class);
            Iterator iterator = toolChainManager.getToolChainsMatching(properties).iterator();
            if (iterator.hasNext()) {
                toolChain = tc = (IToolChain)iterator.next();
            }
            if (toolChain == null && (iterator = toolChainManager.getToolChainsMatching(new HashMap()).iterator()).hasNext()) {
                toolChain = tc = (IToolChain)iterator.next();
            }
            if (toolChain != null) {
                return new AutotoolsBuildConfiguration(config, name, toolChain);
            }
            return null;
        }
        AutotoolsBuildConfiguration autotoolsConfig = new AutotoolsBuildConfiguration(config, name);
        IToolChain toolChain = autotoolsConfig.getToolChain();
        if (toolChain == null) {
            return null;
        }
        return autotoolsConfig;
    }

    public ICBuildConfiguration createBuildConfiguration(IProject project, IToolChain toolChain, String launchMode, IProgressMonitor monitor) throws CoreException {
        String arch;
        HashMap<String, String> properties = new HashMap<String, String>();
        String os = toolChain.getProperty("os");
        if (os != null && !os.isEmpty()) {
            properties.put("os", os);
        }
        if ((arch = toolChain.getProperty("arch")) != null && !arch.isEmpty()) {
            properties.put("arch", arch);
        }
        StringBuilder configName = new StringBuilder("autotools.");
        configName.append(launchMode);
        if ("linux-container".equals(os)) {
            String osConfigName = toolChain.getProperty("linux-container-id");
            osConfigName = osConfigName.replaceAll("/", "_");
            configName.append('.');
            configName.append(osConfigName);
        } else {
            if (os != null) {
                configName.append('.');
                configName.append(os);
            }
            if (arch != null && !arch.isEmpty()) {
                configName.append('.');
                configName.append(arch);
            }
        }
        String name = configName.toString();
        IBuildConfiguration config = null;
        if (this.configManager.hasConfiguration((ICBuildConfigurationProvider)this, project, name)) {
            config = project.getBuildConfig(this.getId() + "/" + name);
        }
        if (config == null) {
            config = this.configManager.createBuildConfiguration((ICBuildConfigurationProvider)this, project, name, monitor);
        }
        AutotoolsBuildConfiguration autotoolsConfig = new AutotoolsBuildConfiguration(config, name, toolChain, launchMode);
        this.configManager.addBuildConfiguration(config, (ICBuildConfiguration)autotoolsConfig);
        return autotoolsConfig;
    }
}

