/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core;

import java.util.Iterator;
import java.util.regex.Matcher;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroDefinition;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.qt.core.ASTUtil;
import org.eclipse.cdt.internal.qt.core.pdom.ASTNameReference;
import org.eclipse.cdt.internal.qt.core.pdom.QtASTImageLocation;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.cdt.qt.core.index.IQMethod;
import org.eclipse.cdt.qt.core.index.IQObject;
import org.eclipse.cdt.qt.core.index.QtIndex;
import org.eclipse.core.resources.IProject;

public class QtMethodReference
extends ASTNameReference {
    private final Type type;
    private final ICPPClassType cls;
    private final String expansionParam;

    private QtMethodReference(Type type, ICPPClassType cls, IASTName macroRefName, String expansionParam, IASTFileLocation location) {
        super(macroRefName, location);
        this.type = type;
        this.cls = cls;
        this.expansionParam = expansionParam;
    }

    public ICPPClassType getContainingType() {
        return this.cls;
    }

    public static QtMethodReference parse(IASTNode parent, IType cppType, IASTNode arg) {
        if (!(cppType instanceof ICPPClassType) || arg == null) {
            return null;
        }
        ICPPClassType cls = (ICPPClassType)cppType;
        Type type = null;
        IASTName macroReferenceName = null;
        IASTNodeLocation[] iASTNodeLocationArray = arg.getNodeLocations();
        int n = iASTNodeLocationArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNodeLocation location = iASTNodeLocationArray[n2];
            if (location instanceof IASTMacroExpansionLocation) {
                IASTPreprocessorMacroExpansion expansion = ((IASTMacroExpansionLocation)location).getExpansion();
                macroReferenceName = expansion.getMacroReference();
                IASTPreprocessorMacroDefinition macroDefn = expansion.getMacroDefinition();
                type = Type.from(macroDefn.getName());
                if (type != null) break;
            }
            ++n2;
        }
        if (macroReferenceName == null || type == null) {
            return null;
        }
        String raw = arg.getRawSignature();
        Matcher m = ASTUtil.Regex_MacroExpansion.matcher(raw);
        if (!m.matches()) {
            return null;
        }
        String expansionArgs = m.group(2);
        int expansionOffset = m.start(2);
        int expansionLength = m.end(2) - expansionOffset;
        QtASTImageLocation location = new QtASTImageLocation(macroReferenceName.getFileLocation(), expansionOffset, expansionLength);
        return new QtMethodReference(type, cls, macroReferenceName, expansionArgs, (IASTFileLocation)location);
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public String getRawSignature() {
        return this.expansionParam;
    }

    @Override
    public char[] getSimpleID() {
        return this.expansionParam.toCharArray();
    }

    private IQObject findQObject() {
        String[] qualName = null;
        try {
            qualName = this.cls.getQualifiedName();
        }
        catch (DOMException e) {
            QtPlugin.log(e);
        }
        IProject project = ASTUtil.getProject((IASTNode)this.delegate);
        if (project == null) {
            return null;
        }
        QtIndex qtIndex = QtIndex.getIndex(project);
        if (qtIndex == null) {
            return null;
        }
        return qtIndex.findQObject(qualName);
    }

    public IQMethod getMethod() {
        IQObject qobj = this.findQObject();
        if (qobj == null) {
            return null;
        }
        Iterator<IQMethod> iterator = ASTUtil.findMethods(qobj, this).iterator();
        if (iterator.hasNext()) {
            IQMethod method = iterator.next();
            return method;
        }
        return null;
    }

    @Override
    public IBinding resolveBinding() {
        IBinding[] methods;
        if (this.binding != null) {
            return this.binding;
        }
        String methodName = this.expansionParam;
        int paren = methodName.indexOf(40);
        if (paren > 0) {
            methodName = methodName.substring(0, paren);
        }
        this.binding = (methods = CPPSemantics.findBindings((IScope)this.cls.getCompositeScope(), (String)methodName.trim(), (boolean)false)).length > 0 ? methods[0] : null;
        return this.binding;
    }

    public static enum Type {
        Signal("sender", "SIGNAL", "signal"),
        Slot("receiver", "SLOT", "member");

        public final String roleName;
        public final String macroName;
        public final String paramName;

        public boolean matches(Type other) {
            if (other == null) {
                return false;
            }
            return this == Signal ? other == Signal : true;
        }

        public static Type from(IASTName name) {
            String nameStr = String.valueOf(name);
            if ("SIGNAL".equals(nameStr)) {
                return Signal;
            }
            if ("SLOT".equals(nameStr)) {
                return Slot;
            }
            return null;
        }

        private Type(String roleName, String macroName, String paramName) {
            this.roleName = roleName;
            this.macroName = macroName;
            this.paramName = paramName;
        }
    }
}

