/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.debug.application;

import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.ICompileOptionsFinder;
import org.eclipse.cdt.core.ISymbolReader;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvider;
import org.eclipse.cdt.core.language.settings.providers.ILanguageSettingsProvidersKeeper;
import org.eclipse.cdt.core.language.settings.providers.IWorkingDirectoryTracker;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescriptionManager;
import org.eclipse.cdt.debug.application.GCCCompileOptionsParser;
import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.cdt.utils.elf.parser.GNUElfParser;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class CompilerOptionParser
implements IWorkspaceRunnable {
    private static final String GCC_COMPILE_OPTIONS_PROVIDER_ID = "org.eclipse.cdt.debug.application.DwarfLanguageSettingsProvider";
    private final IProject project;
    private final String executable;

    public CompilerOptionParser(IProject project, String executable) {
        this.project = project;
        this.executable = executable;
    }

    public void run(IProgressMonitor monitor) {
        try {
            GNUElfParser binParser = new GNUElfParser();
            IBinaryParser.IBinaryFile bf = binParser.getBinary((IPath)new Path(this.executable));
            ISymbolReader reader = (ISymbolReader)bf.getAdapter(ISymbolReader.class);
            String[] sourceFiles = reader.getSourceFiles();
            monitor.beginTask(Messages.GetCompilerOptions, sourceFiles.length * 2 + 1);
            String[] stringArray = sourceFiles;
            int n = sourceFiles.length;
            int n2 = 0;
            while (n2 < n) {
                Path sourceNamePath;
                String sourceFile = stringArray[n2];
                Path sourceFilePath = new Path(sourceFile);
                String sourceName = sourceFilePath.lastSegment();
                IContainer c = this.createFromRoot(this.project, (IPath)new Path(sourceFile));
                IFile source = c.getFile((IPath)(sourceNamePath = new Path(sourceName)));
                if (!source.isLinked()) {
                    try {
                        source.createLink((IPath)sourceFilePath, 0, null);
                    }
                    catch (Exception exception) {}
                }
                monitor.worked(1);
                ++n2;
            }
            CWDTracker cwdTracker = new CWDTracker();
            ICProjectDescriptionManager projDescManager = CCorePlugin.getDefault().getProjectDescriptionManager();
            ICProjectDescription projDesc = projDescManager.getProjectDescription(this.project, false);
            ICConfigurationDescription ccdesc = projDesc.getActiveConfiguration();
            GCCCompileOptionsParser parser = null;
            if (ccdesc instanceof ILanguageSettingsProvidersKeeper) {
                ILanguageSettingsProvidersKeeper keeper = (ILanguageSettingsProvidersKeeper)ccdesc;
                List list = keeper.getLanguageSettingProviders();
                for (ILanguageSettingsProvider p : list) {
                    if (!p.getId().equals(GCC_COMPILE_OPTIONS_PROVIDER_ID)) continue;
                    parser = (GCCCompileOptionsParser)p;
                }
            }
            parser.startup(ccdesc, cwdTracker);
            if (reader instanceof ICompileOptionsFinder) {
                ICompileOptionsFinder f = (ICompileOptionsFinder)reader;
                String[] stringArray2 = sourceFiles;
                int n3 = sourceFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    String fileName = stringArray2[n4];
                    parser.setCurrentResourceName(fileName);
                    parser.processLine(f.getCompileOptions(fileName));
                    monitor.worked(1);
                    ++n4;
                }
                parser.shutdown();
                monitor.worked(1);
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        monitor.done();
    }

    private IContainer createFromRoot(IProject exeProject, IPath path) throws CoreException {
        int segmentCount = path.segmentCount() - 1;
        IProject currentFolder = exeProject;
        int i = 0;
        while (i < segmentCount) {
            if (!(currentFolder = currentFolder.getFolder((IPath)new Path(path.segment(i)))).exists()) {
                ((IFolder)currentFolder).create(9216, true, (IProgressMonitor)new NullProgressMonitor());
            }
            ++i;
        }
        return currentFolder;
    }

    private class CWDTracker
    implements IWorkingDirectoryTracker {
        private CWDTracker() {
        }

        public URI getWorkingDirectoryURI() {
            return null;
        }
    }
}

