/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.testsrunner.internal.model;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProviderInfo;
import org.eclipse.cdt.testsrunner.internal.launcher.TestsRunnerProvidersManager;
import org.eclipse.cdt.testsrunner.internal.model.ITestingSessionsManagerListener;
import org.eclipse.cdt.testsrunner.internal.model.TestingSession;
import org.eclipse.cdt.testsrunner.model.ITestingSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class TestingSessionsManager {
    private TestsRunnerProvidersManager testsRunnersManager;
    private LinkedList<TestingSession> sessions = new LinkedList();
    private TestingSession activeSession;
    private List<ITestingSessionsManagerListener> listeners = new ArrayList<ITestingSessionsManagerListener>();
    private int historySizeLimit = 10;

    public TestingSessionsManager(TestsRunnerProvidersManager testsRunnersManager) {
        this.testsRunnersManager = testsRunnersManager;
    }

    private TestingSession findActualPreviousSession(ILaunchConfiguration launchConfiguration, TestsRunnerProviderInfo testsRunnerProviderInfo) {
        String testsRunnerName = testsRunnerProviderInfo.getName();
        for (TestingSession session : this.sessions) {
            if (session == null || !launchConfiguration.equals(session.getLaunch().getLaunchConfiguration()) || !session.isFinished() || session.wasStopped() || !session.getTestsRunnerProviderInfo().getName().equals(testsRunnerName)) continue;
            return session;
        }
        return null;
    }

    public TestingSession newSession(ILaunch launch) throws CoreException {
        TestsRunnerProviderInfo testsRunnerProviderInfo = this.testsRunnersManager.getTestsRunnerProviderInfo(launch.getLaunchConfiguration());
        TestingSession previousSession = this.findActualPreviousSession(launch.getLaunchConfiguration(), testsRunnerProviderInfo);
        TestingSession newTestingSession = new TestingSession(launch, testsRunnerProviderInfo, previousSession);
        this.sessions.addFirst(newTestingSession);
        this.setActiveSession(newTestingSession);
        this.truncateHistory();
        return newTestingSession;
    }

    public List<? extends ITestingSession> getSessions() {
        return this.sessions;
    }

    public void setSessions(List<ITestingSession> newSessions) {
        this.sessions.clear();
        for (ITestingSession newSession : newSessions) {
            this.sessions.add((TestingSession)newSession);
        }
        this.truncateHistory();
    }

    public int getSessionsCount() {
        return this.sessions.size();
    }

    public ITestingSession getActiveSession() {
        return this.activeSession;
    }

    public void setActiveSession(ITestingSession newActiveSession) {
        if (this.activeSession != newActiveSession) {
            this.activeSession = (TestingSession)newActiveSession;
            for (ITestingSessionsManagerListener listener : this.listeners) {
                listener.sessionActivated(this.activeSession);
            }
        }
    }

    public void addListener(ITestingSessionsManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITestingSessionsManagerListener listener) {
        this.listeners.remove(listener);
    }

    public int getHistorySizeLimit() {
        return this.historySizeLimit;
    }

    public void setHistorySizeLimit(int historySizeLimit) {
        this.historySizeLimit = historySizeLimit;
        this.truncateHistory();
    }

    private void truncateHistory() {
        while (this.sessions.size() > this.historySizeLimit) {
            this.sessions.removeLast();
        }
        if (!this.sessions.contains(this.activeSession)) {
            TestingSession newActiveSession = this.sessions.isEmpty() ? null : this.sessions.getFirst();
            this.setActiveSession(newActiveSession);
        }
    }
}

