/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.ASTTypeUtil;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IField;
import org.eclipse.cdt.core.dom.ast.IQualifierType;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTAliasDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTElaboratedTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTEnumerationSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTUsingDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTVisibilityLabel;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBase;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPBinding;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassScope;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPClassType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPConstructor;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPField;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPReferenceType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPSpecialization;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPUsingDeclaration;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexName;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.core.parser.util.ObjectSet;
import org.eclipse.cdt.internal.core.dom.parser.ASTInternal;
import org.eclipse.cdt.internal.core.dom.parser.ASTQueries;
import org.eclipse.cdt.internal.core.dom.parser.ProblemBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBaseClause;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPClosureType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPField;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPClassSpecializationScope;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPDeferredClassInstance;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPInternalClassTypeMixinHost;
import org.eclipse.cdt.internal.core.dom.parser.cpp.OverloadableOperator;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPSemantics;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.SemanticUtil;
import org.eclipse.core.runtime.CoreException;

public class ClassTypeHelper {
    public static IBinding[] getFriends(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] members;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getFriends();
                }
                IASTNode[] declarations = host.getDeclarations();
                IASTNode node = declarations != null && declarations.length > 0 ? declarations[0] : null;
                return new IBinding[]{new ProblemBinding(node, 7, host.getNameCharArray())};
            }
        }
        ObjectSet<IBinding> resultSet = new ObjectSet<IBinding>(2);
        IASTDeclaration[] iASTDeclarationArray = members = host.getCompositeTypeSpecifier().getMembers();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPASTDeclSpecifier declSpec;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                declSpec = (ICPPASTDeclSpecifier)((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec.isFriend()) {
                    IASTDeclarator[] dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                    if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && dtors.length == 0) {
                        resultSet.put(((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding());
                    } else {
                        IASTDeclarator[] iASTDeclaratorArray = dtors;
                        int n3 = dtors.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            IASTDeclarator dtor = iASTDeclaratorArray[n4];
                            if (dtor != null) {
                                dtor = ASTQueries.findInnermostDeclarator(dtor);
                                resultSet.put(dtor.getName().resolveBinding());
                                ++n4;
                                continue;
                            }
                            break;
                        }
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition && (declSpec = (ICPPASTDeclSpecifier)((IASTFunctionDefinition)decl).getDeclSpecifier()).isFriend()) {
                IASTDeclarator dtor = ((IASTFunctionDefinition)decl).getDeclarator();
                dtor = ASTQueries.findInnermostDeclarator(dtor);
                resultSet.put(dtor.getName().resolveBinding());
            }
            ++n2;
        }
        return resultSet.keyArray(IBinding.class);
    }

    public static boolean isFriend(IBinding binding, ICPPClassType classType) {
        block6: {
            block5: {
                if (!(binding instanceof ICPPClassType)) break block5;
                IType type = (IType)((Object)binding);
                if (type.isSameType(classType)) {
                    return true;
                }
                IBinding[] iBindingArray = ClassTypeHelper.getFriends(classType, null);
                int n = iBindingArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IBinding friend = iBindingArray[n2];
                    if (friend instanceof ICPPClassType && type.isSameType((IType)((Object)friend))) {
                        return true;
                    }
                    ++n2;
                }
                break block6;
            }
            if (!(binding instanceof ICPPFunction)) break block6;
            ICPPFunctionType type = ((ICPPFunction)binding).getType();
            char[] name = binding.getNameCharArray();
            IBinding[] iBindingArray = ClassTypeHelper.getFriends(classType, null);
            int n = iBindingArray.length;
            int n3 = 0;
            while (n3 < n) {
                IBinding friend = iBindingArray[n3];
                if (friend instanceof ICPPFunction && CharArrayUtils.equals(name, friend.getNameCharArray()) && SemanticUtil.haveSameOwner(binding, friend) && type.isSameType(((ICPPFunction)friend).getType())) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    private static ICPPClassType getBackupDefinition(ICPPInternalClassTypeMixinHost host) {
        ICPPClassType b;
        ICPPClassScope scope = host.getCompositeScope();
        if (scope != null && !((b = scope.getClassType()) instanceof ICPPInternalClassTypeMixinHost)) {
            return b;
        }
        return null;
    }

    public static ICPPBase[] getBases(ICPPInternalClassTypeMixinHost host) {
        ICPPASTCompositeTypeSpecifier.ICPPASTBaseSpecifier[] baseSpecifiers;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getBases();
                }
                return ICPPBase.EMPTY_BASE_ARRAY;
            }
        }
        if ((baseSpecifiers = host.getCompositeTypeSpecifier().getBaseSpecifiers()).length == 0) {
            return ICPPBase.EMPTY_BASE_ARRAY;
        }
        ICPPBase[] bases = new ICPPBase[baseSpecifiers.length];
        int i = 0;
        while (i < baseSpecifiers.length) {
            bases[i] = new CPPBaseClause(baseSpecifiers[i]);
            ++i;
        }
        return bases;
    }

    public static ICPPField[] getDeclaredFields(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] decls;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getDeclaredFields();
                }
                return ICPPField.EMPTY_CPPFIELD_ARRAY;
            }
        }
        IBinding binding = null;
        ICPPField[] result = ICPPField.EMPTY_CPPFIELD_ARRAY;
        IASTDeclaration[] iASTDeclarationArray = decls = host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            if (decl instanceof IASTSimpleDeclaration) {
                IASTDeclarator[] dtors;
                IASTDeclarator[] iASTDeclaratorArray = dtors = ((IASTSimpleDeclaration)decl).getDeclarators();
                n3 = dtors.length;
                int n4 = 0;
                while (n4 < n3) {
                    IASTDeclarator dtor = iASTDeclaratorArray[n4];
                    binding = ASTQueries.findInnermostDeclarator(dtor).getName().resolveBinding();
                    if (binding instanceof ICPPField) {
                        result = ArrayUtil.append(result, (ICPPField)binding);
                    }
                    ++n4;
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n5 = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n5.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs;
                    IBinding[] iBindingArray = bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    int n6 = bs.length;
                    n3 = 0;
                    while (n3 < n6) {
                        IBinding element = iBindingArray[n3];
                        if (element instanceof ICPPField) {
                            result = ArrayUtil.append(result, (ICPPField)element);
                        }
                        ++n3;
                    }
                } else if (binding instanceof ICPPField) {
                    result = ArrayUtil.append(result, (ICPPField)binding);
                }
            }
            ++n2;
        }
        return ArrayUtil.trim(result);
    }

    public static ICPPBase[] getBases(ICPPClassType classType, IASTNode point) {
        if (classType instanceof ICPPClassSpecialization) {
            return ((ICPPClassSpecialization)classType).getBases(point);
        }
        return classType.getBases();
    }

    public static ICPPConstructor[] getConstructors(ICPPClassType classType, IASTNode point) {
        if (classType instanceof ICPPClassSpecialization) {
            return ((ICPPClassSpecialization)classType).getConstructors(point);
        }
        return classType.getConstructors();
    }

    public static ICPPField[] getDeclaredFields(ICPPClassType classType, IASTNode point) {
        if (classType instanceof ICPPClassSpecialization) {
            return ((ICPPClassSpecialization)classType).getDeclaredFields(point);
        }
        return classType.getDeclaredFields();
    }

    public static ICPPMethod[] getDeclaredMethods(ICPPClassType classType, IASTNode point) {
        if (classType instanceof ICPPClassSpecialization) {
            return ((ICPPClassSpecialization)classType).getDeclaredMethods(point);
        }
        return classType.getDeclaredMethods();
    }

    public static IBinding[] getFriends(ICPPClassType classType, IASTNode point) {
        if (classType instanceof ICPPClassSpecialization) {
            return ((ICPPClassSpecialization)classType).getFriends(point);
        }
        return classType.getFriends();
    }

    public static ICPPClassType[] getNestedClasses(ICPPClassType classType, IASTNode point) {
        if (classType instanceof ICPPClassSpecialization) {
            return ((ICPPClassSpecialization)classType).getNestedClasses(point);
        }
        return classType.getNestedClasses();
    }

    public static ICPPClassType[] getAllBases(ICPPClassType classType, IASTNode point) {
        HashSet<ICPPClassType> result = new HashSet<ICPPClassType>();
        result.add(classType);
        ClassTypeHelper.getAllBases(classType, result, point);
        result.remove(classType);
        return result.toArray(new ICPPClassType[result.size()]);
    }

    private static void getAllBases(ICPPClassType classType, HashSet<ICPPClassType> result, IASTNode point) {
        ICPPBase[] bases;
        ICPPBase[] iCPPBaseArray = bases = ClassTypeHelper.getBases(classType, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType baseClass;
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType && result.add(baseClass = (ICPPClassType)b)) {
                ClassTypeHelper.getAllBases(baseClass, result, point);
            }
            ++n2;
        }
    }

    public static boolean isSubclass(ICPPClassType subclass, ICPPClassType superclass, IASTNode point) {
        ICPPBase[] bases;
        ICPPBase[] iCPPBaseArray = bases = ClassTypeHelper.getBases(subclass, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                ICPPClassType baseClass = (ICPPClassType)b;
                if (baseClass.isSameType(superclass)) {
                    return true;
                }
                if (ClassTypeHelper.isSubclass(baseClass, superclass, point)) {
                    return true;
                }
            }
            ++n2;
        }
        return false;
    }

    public static ICPPMethod[] getAllDeclaredMethods(ICPPClassType ct, IASTNode point) {
        ICPPClassType[] bases;
        ICPPMethod[] methods = ClassTypeHelper.getDeclaredMethods(ct, point);
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(ct, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            methods = ArrayUtil.addAll(ICPPMethod.class, methods, ClassTypeHelper.getDeclaredMethods(base, point));
            ++n2;
        }
        return ArrayUtil.trim(ICPPMethod.class, methods);
    }

    public static ICPPMethod[] getMethods(ICPPClassType ct, IASTNode point) {
        ICPPClassType[] bases;
        ObjectSet<ICPPMethod> set = ClassTypeHelper.getOwnMethods(ct, point);
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(ct, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            set.addAll((ICPPMethod[])ClassTypeHelper.getDeclaredMethods(base, point));
            set.addAll((ICPPMethod[])ClassTypeHelper.getImplicitMethods(base, point));
            ++n2;
        }
        return set.keyArray(ICPPMethod.class);
    }

    public static ObjectSet<ICPPMethod> getOwnMethods(ICPPClassType classType, IASTNode point) {
        ObjectSet<ICPPMethod> set = new ObjectSet<ICPPMethod>(4);
        set.addAll(ClassTypeHelper.getDeclaredMethods(classType, point));
        set.addAll(ClassTypeHelper.getImplicitMethods(classType, point));
        return set;
    }

    public static ICPPMethod[] getImplicitMethods(ICPPClassType classType, IASTNode point) {
        return ClassTypeHelper.getImplicitMethods(classType.getCompositeScope(), point);
    }

    public static ICPPMethod[] getImplicitMethods(IScope scope, IASTNode point) {
        if (scope instanceof ICPPClassSpecializationScope) {
            return ((ICPPClassSpecializationScope)scope).getImplicitMethods(point);
        }
        if (scope instanceof ICPPClassScope) {
            return ((ICPPClassScope)scope).getImplicitMethods();
        }
        return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
    }

    public static ICPPMethod[] getDeclaredMethods(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] decls;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getDeclaredMethods();
                }
                return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
            }
        }
        IBinding binding = null;
        ICPPMethod[] result = ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        IASTDeclaration[] iASTDeclarationArray = decls = host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4;
            Object[] objectArray;
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IASTSimpleDeclaration sdecl = (IASTSimpleDeclaration)decl;
                if (!((ICPPASTDeclSpecifier)sdecl.getDeclSpecifier()).isFriend()) {
                    IASTDeclarator[] dtors = sdecl.getDeclarators();
                    objectArray = dtors;
                    n4 = dtors.length;
                    n3 = 0;
                    while (n3 < n4) {
                        IASTDeclarator dtor = objectArray[n3];
                        binding = ASTQueries.findInnermostDeclarator(dtor).getName().resolveBinding();
                        if (binding instanceof ICPPMethod) {
                            result = ArrayUtil.append(result, (ICPPMethod)binding);
                        }
                        ++n3;
                    }
                }
            } else if (decl instanceof IASTFunctionDefinition) {
                IASTFunctionDefinition fdef = (IASTFunctionDefinition)decl;
                if (!((ICPPASTDeclSpecifier)fdef.getDeclSpecifier()).isFriend()) {
                    IASTDeclarator dtor = fdef.getDeclarator();
                    binding = (dtor = ASTQueries.findInnermostDeclarator(dtor)).getName().resolveBinding();
                    if (binding instanceof ICPPMethod) {
                        result = ArrayUtil.append(result, (ICPPMethod)binding);
                    }
                }
            } else if (decl instanceof ICPPASTUsingDeclaration) {
                IASTName n5 = ((ICPPASTUsingDeclaration)decl).getName();
                binding = n5.resolveBinding();
                if (binding instanceof ICPPUsingDeclaration) {
                    IBinding[] bs = ((ICPPUsingDeclaration)binding).getDelegates();
                    objectArray = bs;
                    n4 = bs.length;
                    n3 = 0;
                    while (n3 < n4) {
                        Object element = objectArray[n3];
                        if (element instanceof ICPPMethod) {
                            result = ArrayUtil.append(result, (ICPPMethod)element);
                        }
                        ++n3;
                    }
                } else if (binding instanceof ICPPMethod) {
                    result = ArrayUtil.append(result, (ICPPMethod)binding);
                }
            }
            ++n2;
        }
        return ArrayUtil.trim(result);
    }

    public static ICPPConstructor[] getConstructors(ICPPInternalClassTypeMixinHost host) {
        ICPPClassScope scope = host.getCompositeScope();
        if (scope == null) {
            return ICPPConstructor.EMPTY_CONSTRUCTOR_ARRAY;
        }
        return scope.getConstructors();
    }

    public static ICPPClassType[] getNestedClasses(ICPPInternalClassTypeMixinHost host) {
        IASTDeclaration[] decls;
        if (host.getDefinition() == null) {
            host.checkForDefinition();
            if (host.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(host);
                if (backup != null) {
                    return backup.getNestedClasses();
                }
                return ICPPClassType.EMPTY_CLASS_ARRAY;
            }
        }
        ICPPClassType[] result = ICPPClassType.EMPTY_CLASS_ARRAY;
        IASTDeclaration[] iASTDeclarationArray = decls = host.getCompositeTypeSpecifier().getMembers();
        int n = decls.length;
        int n2 = 0;
        while (n2 < n) {
            IASTDeclaration decl = iASTDeclarationArray[n2];
            while (decl instanceof ICPPASTTemplateDeclaration) {
                decl = ((ICPPASTTemplateDeclaration)decl).getDeclaration();
            }
            if (decl instanceof IASTSimpleDeclaration) {
                IBinding binding = null;
                IASTDeclSpecifier declSpec = ((IASTSimpleDeclaration)decl).getDeclSpecifier();
                if (declSpec instanceof ICPPASTCompositeTypeSpecifier) {
                    binding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding();
                } else if (declSpec instanceof ICPPASTElaboratedTypeSpecifier && ((IASTSimpleDeclaration)decl).getDeclarators().length == 0) {
                    binding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding();
                }
                if (binding instanceof ICPPClassType) {
                    result = ArrayUtil.append(result, (ICPPClassType)binding);
                }
            }
            ++n2;
        }
        return ArrayUtil.trim(result);
    }

    public static IField[] getFields(ICPPClassType ct, IASTNode point) {
        ICPPClassType[] bases;
        IField[] fields = ClassTypeHelper.getDeclaredFields(ct, point);
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(ct, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            fields = ArrayUtil.addAll(IField.class, fields, ClassTypeHelper.getDeclaredFields(base, point));
            ++n2;
        }
        return ArrayUtil.trim(IField.class, fields);
    }

    public static IField findField(ICPPClassType ct, String name) {
        IBinding[] bindings = CPPSemantics.findBindings(ct.getCompositeScope(), name, true);
        IField field = null;
        IBinding[] iBindingArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            IBinding binding = iBindingArray[n2];
            if (binding instanceof IField) {
                if (field == null) {
                    field = (IField)binding;
                } else {
                    IASTNode[] decls = ASTInternal.getDeclarationsOfBinding(ct);
                    IASTNode node = decls != null && decls.length > 0 ? decls[0] : null;
                    return new CPPField.CPPFieldProblem(ct, node, 4, name.toCharArray());
                }
            }
            ++n2;
        }
        return field;
    }

    public static boolean isVirtual(ICPPMethod m) {
        if (m instanceof ICPPConstructor) {
            return false;
        }
        if (m.isVirtual()) {
            return true;
        }
        char[] mname = m.getNameCharArray();
        ICPPClassType mcl = m.getClassOwner();
        if (mcl != null) {
            ICPPMethod[] allMethods;
            ICPPFunctionType mft = m.getType();
            IASTNode point = null;
            ICPPMethod[] iCPPMethodArray = allMethods = ClassTypeHelper.getMethods(mcl, point);
            int n = allMethods.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPMethod method = iCPPMethodArray[n2];
                if (CharArrayUtils.equals(mname, method.getNameCharArray()) && ClassTypeHelper.functionTypesAllowOverride(mft, method.getType()) && method.isVirtual()) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private static boolean functionTypesAllowOverride(ICPPFunctionType a, ICPPFunctionType b) {
        if (a.isConst() != b.isConst() || a.isVolatile() != b.isVolatile() || a.takesVarArgs() != b.takesVarArgs()) {
            return false;
        }
        IType[] paramsA = a.getParameterTypes();
        IType[] paramsB = b.getParameterTypes();
        if (paramsA.length == 1 && paramsB.length == 0) {
            if (!SemanticUtil.isVoidType(paramsA[0])) {
                return false;
            }
        } else if (paramsB.length == 1 && paramsA.length == 0) {
            if (!SemanticUtil.isVoidType(paramsB[0])) {
                return false;
            }
        } else {
            if (paramsA.length != paramsB.length) {
                return false;
            }
            int i = 0;
            while (i < paramsA.length) {
                if (paramsA[i] == null || !paramsA[i].isSameType(paramsB[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public static boolean isOverrider(ICPPMethod source, ICPPMethod target) {
        ICPPClassType[] bases;
        if (source instanceof ICPPConstructor || target instanceof ICPPConstructor) {
            return false;
        }
        if (!ClassTypeHelper.isVirtual(target)) {
            return false;
        }
        if (!ClassTypeHelper.functionTypesAllowOverride(source.getType(), target.getType())) {
            return false;
        }
        ICPPClassType sourceClass = source.getClassOwner();
        ICPPClassType targetClass = target.getClassOwner();
        if (sourceClass == null || targetClass == null) {
            return false;
        }
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(sourceClass, null);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPClassType base = iCPPClassTypeArray[n2];
            if (base.isSameType(targetClass)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static ICPPMethod[] findOverridden(ICPPMethod method, IASTNode point) {
        ICPPBase[] bases;
        if (method instanceof ICPPConstructor) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        char[] mname = method.getNameCharArray();
        ICPPClassType mcl = method.getClassOwner();
        if (mcl == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
        HashMap<ICPPClassType, Boolean> virtualInClass = new HashMap<ICPPClassType, Boolean>();
        ICPPFunctionType methodType = method.getType();
        virtualInClass.put(mcl, method.isVirtual());
        ICPPBase[] iCPPBaseArray = bases = ClassTypeHelper.getBases(mcl, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPBase base = iCPPBaseArray[n2];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType) {
                ClassTypeHelper.findOverridden((ICPPClassType)b, point, mname, methodType, virtualInClass, result, 16);
            }
            ++n2;
        }
        Collections.reverse(result);
        return result.toArray(new ICPPMethod[result.size()]);
    }

    private static boolean findOverridden(ICPPClassType classType, IASTNode point, char[] methodName, ICPPFunctionType methodType, Map<ICPPClassType, Boolean> virtualInClass, List<ICPPMethod> result, int maxdepth) {
        ICPPBase[] bases;
        if (maxdepth <= 0) {
            return false;
        }
        Boolean visitedBefore = virtualInClass.get(classType);
        if (visitedBefore != null) {
            return visitedBefore;
        }
        ICPPMethod[] methods = ClassTypeHelper.getDeclaredMethods(classType, point);
        ICPPMethod candidate = null;
        boolean hasOverridden = false;
        ICPPMethod[] iCPPMethodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod method = iCPPMethodArray[n2];
            if (methodName[0] == '~' && method.isDestructor() || CharArrayUtils.equals(methodName, method.getNameCharArray()) && ClassTypeHelper.functionTypesAllowOverride(methodType, method.getType())) {
                candidate = method;
                hasOverridden = method.isVirtual();
                break;
            }
            ++n2;
        }
        virtualInClass.put(classType, hasOverridden);
        ICPPBase[] iCPPBaseArray = bases = ClassTypeHelper.getBases(classType, point);
        int n3 = bases.length;
        n = 0;
        while (n < n3) {
            ICPPBase base = iCPPBaseArray[n];
            IBinding b = base.getBaseClass();
            if (b instanceof ICPPClassType && ClassTypeHelper.findOverridden((ICPPClassType)b, point, methodName, methodType, virtualInClass, result, maxdepth - 1)) {
                hasOverridden = true;
            }
            ++n;
        }
        if (hasOverridden) {
            if (candidate != null) {
                result.add(candidate);
            }
            virtualInClass.put(classType, hasOverridden);
        }
        return hasOverridden;
    }

    public static ICPPMethod[] findOverriders(IIndex index, ICPPMethod method) throws CoreException {
        if (!ClassTypeHelper.isVirtual(method)) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        ICPPClassType mcl = method.getClassOwner();
        if (mcl == null) {
            return ICPPMethod.EMPTY_CPPMETHOD_ARRAY;
        }
        ICPPClassType[] subclasses = ClassTypeHelper.getSubClasses(index, mcl);
        return ClassTypeHelper.findOverriders(subclasses, method);
    }

    public static ICPPMethod[] findOverriders(ICPPClassType[] subclasses, ICPPMethod method) {
        char[] mname = method.getNameCharArray();
        ICPPFunctionType mft = method.getType();
        ArrayList<ICPPMethod> result = new ArrayList<ICPPMethod>();
        ICPPClassType[] iCPPClassTypeArray = subclasses;
        int n = subclasses.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod[] methods;
            ICPPClassType subClass = iCPPClassTypeArray[n2];
            ICPPMethod[] iCPPMethodArray = methods = subClass.getDeclaredMethods();
            int n3 = methods.length;
            int n4 = 0;
            while (n4 < n3) {
                ICPPMethod candidate = iCPPMethodArray[n4];
                if (CharArrayUtils.equals(mname, candidate.getNameCharArray()) && ClassTypeHelper.functionTypesAllowOverride(mft, candidate.getType())) {
                    result.add(candidate);
                }
                ++n4;
            }
            ++n2;
        }
        return result.toArray(new ICPPMethod[result.size()]);
    }

    private static ICPPClassType[] getSubClasses(IIndex index, ICPPClassType mcl) throws CoreException {
        LinkedList<ICPPBinding> result = new LinkedList<ICPPBinding>();
        HashSet<String> handled = new HashSet<String>();
        ClassTypeHelper.getSubClasses(index, mcl, result, handled);
        result.remove(0);
        return result.toArray(new ICPPClassType[result.size()]);
    }

    private static void getSubClasses(IIndex index, ICPPBinding classOrTypedef, List<ICPPBinding> result, HashSet<String> handled) throws CoreException {
        IIndexName[] names;
        if (!(classOrTypedef instanceof IType)) {
            return;
        }
        String key = ASTTypeUtil.getType((IType)((Object)classOrTypedef), true);
        if (!handled.add(key)) {
            return;
        }
        if (classOrTypedef instanceof ICPPClassType) {
            result.add(classOrTypedef);
        }
        IIndexName[] iIndexNameArray = names = index.findNames(classOrTypedef, 6);
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexBinding subClass;
            IIndexName subClassDef;
            IIndexName indexName = iIndexNameArray[n2];
            if (indexName.isBaseSpecifier() && (subClassDef = indexName.getEnclosingDefinition()) != null && (subClass = index.findBinding(subClassDef)) instanceof ICPPBinding) {
                ClassTypeHelper.getSubClasses(index, (ICPPBinding)((Object)subClass), result, handled);
            }
            ++n2;
        }
    }

    public static MethodKind getMethodKind(ICPPClassType classType, ICPPMethod method) {
        if (method instanceof ICPPConstructor) {
            List<IType> params = ClassTypeHelper.getTypesOfRequiredParameters(method);
            if (params.isEmpty()) {
                return MethodKind.DEFAULT_CTOR;
            }
            if (params.size() == 1) {
                IType t = SemanticUtil.getNestedType(params.get(0), 1);
                if (SemanticUtil.isVoidType(t)) {
                    return MethodKind.DEFAULT_CTOR;
                }
                ICPPReferenceType refToClass = ClassTypeHelper.getRefToClass(classType, t);
                if (refToClass != null) {
                    return refToClass.isRValueReference() ? MethodKind.MOVE_CTOR : MethodKind.COPY_CTOR;
                }
            }
            return MethodKind.OTHER;
        }
        if (method.isDestructor()) {
            return MethodKind.DTOR;
        }
        if (CharArrayUtils.equals(method.getNameCharArray(), OverloadableOperator.ASSIGN.toCharArray())) {
            IType t;
            ICPPReferenceType refToClass;
            List<IType> params = ClassTypeHelper.getTypesOfRequiredParameters(method);
            if (params.size() == 1 && (refToClass = ClassTypeHelper.getRefToClass(classType, t = params.get(0))) != null) {
                return refToClass.isRValueReference() ? MethodKind.MOVE_ASSIGNMENT_OP : MethodKind.COPY_ASSIGNMENT_OP;
            }
            return MethodKind.OTHER;
        }
        return MethodKind.OTHER;
    }

    private static List<IType> getTypesOfRequiredParameters(ICPPMethod method) {
        ICPPParameter[] parameters = method.getParameters();
        if (parameters.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<IType> types = new ArrayList<IType>(parameters.length);
        ICPPParameter[] iCPPParameterArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPParameter parameter = iCPPParameterArray[n2];
            if (!parameter.hasDefaultValue() && !parameter.isParameterPack()) {
                types.add(parameter.getType());
            }
            ++n2;
        }
        return types;
    }

    public static IType[] getInheritedExceptionSpecification(ICPPMethod implicitMethod, IASTNode point) {
        ICPPClassType[] bases;
        ICPPClassType owner = implicitMethod.getClassOwner();
        if (owner == null || ClassTypeHelper.getBases(owner, point).length == 0) {
            return null;
        }
        MethodKind kind = ClassTypeHelper.getMethodKind(owner, implicitMethod);
        if (kind == MethodKind.OTHER) {
            return null;
        }
        ArrayList<IType> inheritedTypeids = new ArrayList<IType>();
        ICPPClassType[] iCPPClassTypeArray = bases = ClassTypeHelper.getAllBases(owner, point);
        int n = bases.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod baseMethod;
            ICPPClassType base = iCPPClassTypeArray[n2];
            if (!(base instanceof ICPPDeferredClassInstance) && (baseMethod = ClassTypeHelper.getMethodInClass(base, kind, point)) != null) {
                IType[] baseExceptionSpec = baseMethod.getExceptionSpecification();
                if (baseExceptionSpec == null) {
                    return null;
                }
                IType[] iTypeArray = baseMethod.getExceptionSpecification();
                int n3 = iTypeArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType baseTypeId = iTypeArray[n4];
                    inheritedTypeids.add(baseTypeId);
                    ++n4;
                }
            }
            ++n2;
        }
        return inheritedTypeids.toArray(new IType[inheritedTypeids.size()]);
    }

    private static ICPPReferenceType getRefToClass(ICPPClassType classType, IType type) {
        while (type instanceof ITypedef) {
            type = ((ITypedef)type).getType();
        }
        if (type instanceof ICPPReferenceType) {
            ICPPReferenceType refType = (ICPPReferenceType)type;
            type = refType.getType();
            while (type instanceof ITypedef) {
                type = ((ITypedef)type).getType();
            }
            if (type instanceof IQualifierType && classType.isSameType(type = ((IQualifierType)type).getType())) {
                return refType;
            }
        }
        return null;
    }

    public static ICPPMethod getMethodInClass(ICPPClassType ct, MethodKind kind, IASTNode point) {
        switch (kind) {
            case DEFAULT_CTOR: 
            case COPY_CTOR: 
            case MOVE_CTOR: {
                ICPPConstructor[] iCPPConstructorArray = ClassTypeHelper.getConstructors(ct, point);
                int n = iCPPConstructorArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPConstructor ctor = iCPPConstructorArray[n2];
                    if (!ctor.isImplicit() && ClassTypeHelper.getMethodKind(ct, ctor) == kind) {
                        return ctor;
                    }
                    ++n2;
                }
                return null;
            }
            case COPY_ASSIGNMENT_OP: 
            case MOVE_ASSIGNMENT_OP: {
                ICPPMethod[] iCPPMethodArray = ClassTypeHelper.getDeclaredMethods(ct, point);
                int n = iCPPMethodArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ICPPMethod method = iCPPMethodArray[n3];
                    if (!(method instanceof ICPPConstructor) && ClassTypeHelper.getMethodKind(ct, method) == kind) {
                        return method;
                    }
                    ++n3;
                }
                return null;
            }
            case DTOR: {
                ICPPMethod[] iCPPMethodArray = ClassTypeHelper.getDeclaredMethods(ct, point);
                int n = iCPPMethodArray.length;
                int n4 = 0;
                while (n4 < n) {
                    ICPPMethod method = iCPPMethodArray[n4];
                    if (method.isDestructor()) {
                        return method;
                    }
                    ++n4;
                }
                return null;
            }
        }
        return null;
    }

    public static int getVisibility(ICPPInternalClassTypeMixinHost classType, IBinding member) {
        IASTName ownerName;
        IASTNode node;
        ICPPMethod[] implicitMethods;
        if (classType.getDefinition() == null) {
            classType.checkForDefinition();
            if (classType.getDefinition() == null) {
                ICPPClassType backup = ClassTypeHelper.getBackupDefinition(classType);
                if (backup != null) {
                    return backup.getVisibility(member);
                }
                if (classType instanceof ICPPClassSpecialization) {
                    ICPPClassType specialized = ((ICPPClassSpecialization)((Object)classType)).getSpecializedBinding();
                    if (!specialized.equals(member.getOwner())) {
                        if (!(member instanceof ICPPSpecialization)) {
                            throw ClassTypeHelper.invalidMember(specialized, member);
                        }
                        member = ((ICPPSpecialization)member).getSpecializedBinding();
                    }
                    return specialized.getVisibility(member);
                }
                return 1;
            }
        }
        if (member instanceof CPPClosureType) {
            return 1;
        }
        ICPPASTCompositeTypeSpecifier classDeclSpec = classType.getCompositeTypeSpecifier();
        int visibility = ClassTypeHelper.getVisibility(classDeclSpec, member);
        if (visibility >= 0) {
            return visibility;
        }
        ICPPMethod[] iCPPMethodArray = implicitMethods = ClassTypeHelper.getImplicitMethods(classType, null);
        int n = implicitMethods.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPMethod implicitMethod = iCPPMethodArray[n2];
            if (member.equals(implicitMethod)) {
                return 1;
            }
            ++n2;
        }
        if (member instanceof ICPPInternalBinding && (node = ((ICPPInternalBinding)member).getDefinition()) != null && (ownerName = CPPVisitor.findDeclarationOwnerDefinition(node, false)) != null && !ownerName.equals(classDeclSpec.getName()) && ownerName.getPropertyInParent() == ICPPASTCompositeTypeSpecifier.TYPE_NAME && (visibility = ClassTypeHelper.getVisibility(classDeclSpec = (ICPPASTCompositeTypeSpecifier)ownerName.getParent(), member)) >= 0) {
            return visibility;
        }
        throw ClassTypeHelper.invalidMember(classType, member);
    }

    /*
     * Unable to fully structure code
     */
    private static int getVisibility(ICPPASTCompositeTypeSpecifier classDeclSpec, IBinding member) {
        visibility = classDeclSpec.getKey() == 3 ? 3 : 1;
        var7_4 = hostMembers = classDeclSpec.getMembers();
        var6_5 = hostMembers.length;
        var5_6 = 0;
        while (var5_6 < var6_5) {
            block11: {
                hostMember = var7_4[var5_6];
                if (!(hostMember instanceof ICPPASTVisibilityLabel)) ** GOTO lbl11
                visibility = ((ICPPASTVisibilityLabel)hostMember).getVisibility();
                break block11;
lbl-1000:
                // 1 sources

                {
                    hostMember = ((ICPPASTTemplateDeclaration)hostMember).getDeclaration();
lbl11:
                    // 2 sources

                    ** while (hostMember instanceof ICPPASTTemplateDeclaration)
                }
lbl12:
                // 1 sources

                if (hostMember instanceof IASTSimpleDeclaration) {
                    memberDeclaration = (IASTSimpleDeclaration)hostMember;
                    var12_15 = memberDeclaration.getDeclarators();
                    var11_14 = var12_15.length;
                    var10_10 = 0;
                    while (var10_10 < var11_14) {
                        memberDeclarator = var12_15[var10_10];
                        memberBinding = ASTQueries.findInnermostDeclarator(memberDeclarator).getName().resolveBinding();
                        if (member.equals(memberBinding)) {
                            return visibility;
                        }
                        ++var10_10;
                    }
                    declSpec = memberDeclaration.getDeclSpecifier();
                    if (declSpec instanceof ICPPASTCompositeTypeSpecifier != false ? member.equals(memberBinding = ((ICPPASTCompositeTypeSpecifier)declSpec).getName().resolveBinding()) != false : (declSpec instanceof ICPPASTElaboratedTypeSpecifier != false && memberDeclaration.getDeclarators().length == 0 ? member.equals(memberBinding = ((ICPPASTElaboratedTypeSpecifier)declSpec).getName().resolveBinding()) != false : declSpec instanceof ICPPASTEnumerationSpecifier != false && member.equals(enumerationBinding = ((ICPPASTEnumerationSpecifier)declSpec).getName().resolveBinding()) != false)) {
                        return visibility;
                    }
                } else if (hostMember instanceof IASTFunctionDefinition) {
                    declarator = ((IASTFunctionDefinition)hostMember).getDeclarator();
                    functionBinding = (declarator = ASTQueries.findInnermostDeclarator(declarator)).getName().resolveBinding();
                    if (member.equals(functionBinding)) {
                        return visibility;
                    }
                } else if (hostMember instanceof ICPPASTAliasDeclaration != false ? member.equals(aliasBinding = ((ICPPASTAliasDeclaration)hostMember).getAlias().resolveBinding()) != false : (hostMember instanceof ICPPASTUsingDeclaration != false ? member.equals(usingBinding = ((ICPPASTUsingDeclaration)hostMember).getName().resolveBinding()) != false : hostMember instanceof ICPPASTNamespaceDefinition != false && member.equals(namespaceBinding = ((ICPPASTNamespaceDefinition)hostMember).getName().resolveBinding()) != false)) {
                    return visibility;
                }
            }
            ++var5_6;
        }
        return -1;
    }

    private static IllegalArgumentException invalidMember(IBinding classType, IBinding member) {
        String name = member.getName();
        if (name.isEmpty()) {
            name = "<anonymous>";
        }
        return new IllegalArgumentException(String.valueOf(name) + " is not a member of " + classType.getName());
    }

    public static enum MethodKind {
        DEFAULT_CTOR,
        COPY_CTOR,
        MOVE_CTOR,
        COPY_ASSIGNMENT_OP,
        MOVE_ASSIGNMENT_OP,
        DTOR,
        OTHER;

    }
}

