/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICModelStatus;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.model.CElement;
import org.eclipse.cdt.internal.core.model.CElementDelta;
import org.eclipse.cdt.internal.core.model.CModelManager;
import org.eclipse.cdt.internal.core.model.CModelStatus;
import org.eclipse.cdt.internal.core.model.CoreModelMessages;
import org.eclipse.cdt.internal.core.model.MultiOperation;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class CopyResourceElementsOperation
extends MultiOperation {
    protected ArrayList<ICElement> fCreatedElements;
    protected Map<ICProject, CElementDelta> fDeltasPerProject = new HashMap<ICProject, CElementDelta>(1);

    public CopyResourceElementsOperation(ICElement[] src, ICElement[] dst, boolean force) {
        super(src, dst, force);
    }

    private CElementDelta getDeltaFor(ICProject cProject) {
        CElementDelta delta = this.fDeltasPerProject.get(cProject);
        if (delta == null) {
            delta = new CElementDelta(cProject);
            this.fDeltasPerProject.put(cProject, delta);
        }
        return delta;
    }

    @Override
    protected String getMainTaskName() {
        return CoreModelMessages.getString("operation.copyResourceProgress");
    }

    protected void prepareDeltas(ICElement sourceElement, ICElement destinationElement) {
        ICProject destProject = destinationElement.getCProject();
        if (this.isMove()) {
            ICProject sourceProject = sourceElement.getCProject();
            this.getDeltaFor(sourceProject).movedFrom(sourceElement, destinationElement);
            this.getDeltaFor(destProject).movedTo(destinationElement, sourceElement);
        } else {
            this.getDeltaFor(destProject).added(destinationElement);
        }
    }

    protected void processDeltas() {
        for (CElementDelta elementDelta : this.fDeltasPerProject.values()) {
            this.addDelta(elementDelta);
        }
    }

    private void processResource(ICElement source, ICElement dest) throws CModelException {
        String newName = this.getNewNameFor(source);
        String destName = newName != null ? newName : source.getElementName();
        IFile sourceResource = (IFile)source.getResource();
        IContainer destFolder = (IContainer)dest.getResource();
        IFile destFile = destFolder.getFile((IPath)new Path(destName));
        if (!destFile.equals((Object)sourceResource)) {
            try {
                if (destFile.exists()) {
                    if (this.fForce) {
                        this.deleteResource((IResource)destFile, false);
                    } else {
                        throw new CModelException(new CModelStatus(977));
                    }
                }
                if (this.isMove()) {
                    sourceResource.move(destFile.getFullPath(), this.fForce, true, this.getSubProgressMonitor(1));
                } else {
                    sourceResource.copy(destFile.getFullPath(), this.fForce, this.getSubProgressMonitor(1));
                }
                this.hasModifiedResource = true;
            }
            catch (CModelException e) {
                throw e;
            }
            catch (CoreException e) {
                throw new CModelException(e);
            }
            ICElement cdest = CModelManager.getDefault().create(destFile, null);
            this.prepareDeltas(source, cdest);
            this.fCreatedElements.add(cdest);
        } else if (!this.fForce) {
            throw new CModelException(new CModelStatus(977));
        }
    }

    @Override
    protected void processElement(ICElement element) throws CModelException {
        ICElement dest = this.getDestinationParent(element);
        if (element.getElementType() > 60) {
            throw new CModelException(new CModelStatus(967, element));
        }
        this.processResource(element, dest);
    }

    @Override
    protected void processElements() throws CModelException {
        this.fCreatedElements = new ArrayList(this.fElementsToProcess.length);
        try {
            super.processElements();
        }
        finally {
            this.fResultElements = new ICElement[this.fCreatedElements.size()];
            this.fCreatedElements.toArray(this.fResultElements);
            this.processDeltas();
        }
    }

    @Override
    protected ICModelStatus verify() {
        ICModelStatus status = super.verify();
        if (!status.isOK()) {
            return status;
        }
        if (this.fRenamingsList != null && this.fRenamingsList.length != this.fElementsToProcess.length) {
            return new CModelStatus(980);
        }
        return CModelStatus.VERIFIED_OK;
    }

    @Override
    protected void verify(ICElement element) throws CModelException {
        if (element == null || !element.exists()) {
            this.error(969, element);
        } else if (element.isReadOnly() && (this.isRename() || this.isMove())) {
            this.error(976, element);
        } else {
            CElement dest = (CElement)this.getDestinationParent(element);
            this.verifyDestination(element, dest);
            if (this.fRenamings != null) {
                this.verifyRenaming(element);
            }
        }
    }
}

