/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command.commands;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IBreakpoints;
import org.eclipse.cdt.dsf.gdb.breakpoints.GDBDynamicPrintfUtils;
import org.eclipse.cdt.dsf.mi.service.command.commands.Adjustable;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIBreakInsertInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;

public class MIDPrintfInsert
extends MICommand<MIBreakInsertInfo> {
    public MIDPrintfInsert(IBreakpoints.IBreakpointsTargetDMContext ctx, boolean isTemporary, String condition, int ignoreCount, int tid, boolean disabled, boolean allowPending, String location, String printfStr) {
        super((IDMContext)ctx, "-dprintf-insert");
        int i = 0;
        if (isTemporary) {
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            i += 2;
        }
        if (ignoreCount > 0) {
            i += 2;
        }
        if (tid > 0) {
            i += 2;
        }
        if (disabled) {
            ++i;
        }
        if (allowPending) {
            ++i;
        }
        String[] opts = new String[i];
        i = 0;
        if (isTemporary) {
            opts[i] = "-t";
            ++i;
        }
        if (condition != null && condition.length() > 0) {
            opts[i] = "-c";
            opts[++i] = condition;
            ++i;
        }
        if (ignoreCount > 0) {
            opts[i] = "-i";
            opts[++i] = Integer.toString(ignoreCount);
            ++i;
        }
        if (tid > 0) {
            opts[i] = "-p";
            opts[++i] = Integer.toString(tid);
            ++i;
        }
        if (disabled) {
            opts[i] = "-d";
            ++i;
        }
        if (allowPending) {
            opts[i] = "-f";
            ++i;
        }
        if (opts.length > 0) {
            this.setOptions(opts);
        }
        this.setParameters(this.createParameters(location, printfStr));
    }

    private Adjustable[] createParameters(String location, String printfStr) {
        ArrayList<MICommand.MICommandAdjustable> paramsList = new ArrayList<MICommand.MICommandAdjustable>();
        paramsList.add(new MICommand.MIStandardParameterAdjustable(location));
        GDBDynamicPrintfUtils.GDBDynamicPrintfString parsedStr = new GDBDynamicPrintfUtils.GDBDynamicPrintfString(printfStr);
        if (parsedStr.isValid()) {
            paramsList.add(new DPrintfAdjustable(parsedStr.getString()));
            String[] stringArray = parsedStr.getArguments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                paramsList.add(new MICommand.MIStandardParameterAdjustable(arg));
                ++n2;
            }
        }
        return paramsList.toArray(new Adjustable[paramsList.size()]);
    }

    @Override
    public MIBreakInsertInfo getResult(MIOutput output) {
        return new MIBreakInsertInfo(output);
    }

    private class DPrintfAdjustable
    extends MICommand.MICommandAdjustable {
        public DPrintfAdjustable(String value) {
            super(value);
        }

        @Override
        public String getAdjustedValue() {
            return this.getValue();
        }
    }
}

