/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.xlc.core.scannerconfig;

import java.util.HashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.cdt.make.core.scannerconfig.IScannerInfoCollector2;
import org.eclipse.cdt.make.core.scannerconfig.ScannerInfoTypes;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.CCommandDSC;
import org.eclipse.cdt.make.internal.core.scannerconfig.util.TraceUtil;
import org.eclipse.cdt.make.xlc.core.activator.Activator;
import org.eclipse.cdt.make.xlc.core.scannerconfig.AbstractXLCBuildOutputParser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class XLCPerFileBuildOutputParser
extends AbstractXLCBuildOutputParser {
    @Override
    protected boolean processCommand(String[] tokens) {
        String filePath;
        int extensionsIndex;
        int compilerInvocationIndex;
        block27: {
            block26: {
                int k;
                block25: {
                    compilerInvocationIndex = this.findCompilerInvocation(tokens);
                    if (compilerInvocationIndex >= 0) break block25;
                    return false;
                }
                extensionsIndex = -1;
                boolean found = false;
                filePath = null;
                int automakeSrcIndex = this.findAutoMakeSourceIndex(tokens);
                if (automakeSrcIndex != -1 && (k = (filePath = this.getAutoMakeSourcePath(tokens[automakeSrcIndex])).lastIndexOf(46)) != -1 && filePath.length() - k < 5) {
                    String fileExtension = filePath.substring(k);
                    extensionsIndex = this.getFileExtensionsList().indexOf(fileExtension);
                    if (extensionsIndex != -1) {
                        found = true;
                    }
                }
                if (!found) {
                    int i = compilerInvocationIndex + 1;
                    while (i < tokens.length) {
                        String token = tokens[i];
                        int k2 = token.lastIndexOf(46);
                        if (k2 != -1 && token.length() - k2 < 5) {
                            String fileExtension = token.substring(k2);
                            extensionsIndex = this.getFileExtensionsList().indexOf(fileExtension);
                            if (extensionsIndex != -1) {
                                filePath = token;
                                found = true;
                                break;
                            }
                        }
                        ++i;
                    }
                }
                if (found) break block26;
                TraceUtil.outputTrace((String)"Error identifying file name :1", (String[])tokens, (String)TraceUtil.EOL);
                return false;
            }
            if (filePath.indexOf(this.getFileExtensions()[extensionsIndex]) != -1) break block27;
            TraceUtil.outputTrace((String)"Error identifying file name :2", (String[])tokens, (String)TraceUtil.EOL);
            return false;
        }
        try {
            if (this.getUtility() != null) {
                IPath pFilePath = this.fUtility.getAbsolutePath(filePath);
                String shortFileName = pFilePath.removeFileExtension().lastSegment();
                int i = compilerInvocationIndex + 1;
                while (i < tokens.length) {
                    String token = tokens[i];
                    if (token.equals("-include")) {
                        ++i;
                    } else if (token.equals("-imacros")) {
                        ++i;
                    } else if (token.equals(filePath)) {
                        tokens[i] = "LONG_NAME";
                    } else if (token.startsWith(shortFileName)) {
                        tokens[i] = token.replaceFirst(shortFileName, "SHORT_NAME");
                    }
                    ++i;
                }
                IFile file = null;
                IPath baseDirectory = this.fUtility.getBaseDirectory();
                if (baseDirectory.isPrefixOf(pFilePath)) {
                    IPath relPath = pFilePath.removeFirstSegments(baseDirectory.segmentCount());
                    file = this.getProject().getFile(relPath);
                } else {
                    file = this.getUtility().findFileInWorkspace(pFilePath);
                }
                CCommandDSC cmd = this.getUtility().getNewCCommandDSC(tokens, compilerInvocationIndex, extensionsIndex > 0);
                CopyOnWriteArrayList<CCommandDSC> cmdList = new CopyOnWriteArrayList<CCommandDSC>();
                cmdList.add(cmd);
                HashMap<ScannerInfoTypes, CopyOnWriteArrayList<CCommandDSC>> sc = new HashMap<ScannerInfoTypes, CopyOnWriteArrayList<CCommandDSC>>(1);
                sc.put(ScannerInfoTypes.COMPILER_COMMAND, cmdList);
                this.getCollector().contributeToScannerConfig((Object)file, sc);
                if (this.fCollector != null && this.fCollector instanceof IScannerInfoCollector2) {
                    IScannerInfoCollector2 collector = (IScannerInfoCollector2)this.fCollector;
                    try {
                        collector.updateScannerConfiguration(null);
                    }
                    catch (CoreException e) {
                        Activator.log(e);
                    }
                }
            }
            return true;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return false;
        }
    }

    protected String getAutoMakeSourcePath(String string) {
        int firstQuoteIndex = string.indexOf(39);
        int lastQuoteIndex = string.lastIndexOf(39);
        if (firstQuoteIndex != -1 && lastQuoteIndex != -1) {
            return string.substring(firstQuoteIndex, lastQuoteIndex);
        }
        int equalsIndex = string.indexOf(61);
        if (equalsIndex != -1 && equalsIndex < string.length()) {
            return string.substring(equalsIndex + 1);
        }
        return null;
    }

    protected int findAutoMakeSourceIndex(String[] tokens) {
        int i = 0;
        while (i < tokens.length) {
            String token = tokens[i].toLowerCase();
            if (token.indexOf("source=") != -1) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

