/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.rename;

import java.util.HashMap;
import org.eclipse.cdt.internal.ui.refactoring.rename.HeaderFileReferenceAdjuster;
import org.eclipse.cdt.internal.ui.refactoring.rename.RenameMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveArguments;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;

public class HeaderFileMoveParticipant
extends MoveParticipant {
    private IResource movedResource;
    private Change change;

    protected boolean initialize(Object element) {
        if (element instanceof IResource) {
            this.movedResource = (IResource)element;
            return true;
        }
        return false;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        MoveArguments args = this.getArguments();
        if (!args.getUpdateReferences()) {
            return null;
        }
        if (this.movedResource.isLinked()) {
            return null;
        }
        Object destinationResource = args.getDestination();
        if (!(destinationResource instanceof IContainer)) {
            return null;
        }
        final IContainer destination = (IContainer)destinationResource;
        IPath destinationLocation = destination.getLocation();
        if (destinationLocation.equals((Object)this.movedResource.getLocation().removeLastSegments(1))) {
            return null;
        }
        try {
            final HashMap<IFile, IFile> movedFiles = new HashMap<IFile, IFile>();
            if (this.movedResource instanceof IContainer) {
                final int prefixLength = this.movedResource.getFullPath().segmentCount() - 1;
                ((IContainer)this.movedResource).accept(new IResourceProxyVisitor(){

                    public boolean visit(IResourceProxy proxy) throws CoreException {
                        if (proxy.isLinked()) {
                            return false;
                        }
                        if (proxy.getType() == 1) {
                            IFile file = (IFile)proxy.requestResource();
                            movedFiles.put(file, destination.getFile(file.getFullPath().removeFirstSegments(prefixLength)));
                            return false;
                        }
                        return true;
                    }
                }, 0);
            } else if (this.movedResource instanceof IFile) {
                IFile file = (IFile)this.movedResource;
                movedFiles.put(file, destination.getFile((IPath)new Path(this.movedResource.getName())));
            }
            HeaderFileReferenceAdjuster includeAdjuster = new HeaderFileReferenceAdjuster(movedFiles);
            this.change = includeAdjuster.createChange(context, pm);
        }
        catch (CoreException e) {
            return RefactoringStatus.create((IStatus)e.getStatus());
        }
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.done();
        return this.change;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        pm.done();
        return null;
    }

    public String getName() {
        return RenameMessages.HeaderFileMoveParticipant_name;
    }
}

