/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.qt.core;

import java.util.Arrays;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.internal.core.index.CIndex;
import org.eclipse.cdt.internal.core.index.IIndexFragment;
import org.eclipse.cdt.qt.core.QtPlugin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class QtNature
implements IProjectNature {
    private static final String ID = "org.eclipse.cdt.qt.core.qtNature";
    private IProject project;

    public static boolean hasNature(IProject project) {
        try {
            return project.hasNature(ID);
        }
        catch (CoreException e) {
            QtPlugin.log(e);
            return false;
        }
    }

    public static void addNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (project.isOpen()) {
            if (QtNature.hasNature(project)) {
                return;
            }
            IProjectDescription desc = project.getDescription();
            String[] oldIds = desc.getNatureIds();
            String[] newIds = Arrays.copyOf(oldIds, oldIds.length + 1);
            newIds[oldIds.length] = ID;
            desc.setNatureIds(newIds);
            project.setDescription(desc, monitor);
        }
    }

    public void configure() throws CoreException {
        ICProject cProject = CCorePlugin.getDefault().getCoreModel().create(this.project);
        if (cProject == null) {
            return;
        }
        IIndex index = CCorePlugin.getIndexManager().getIndex(cProject);
        if (!(index instanceof CIndex)) {
            return;
        }
        IIndexFragment[] iIndexFragmentArray = ((CIndex)index).getFragments();
        int n = iIndexFragmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IIndexFragment fragment = iIndexFragmentArray[n2];
            IIndexLinkage[] iIndexLinkageArray = fragment.getLinkages();
            int n3 = iIndexLinkageArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IIndexLinkage linkage = iIndexLinkageArray[n4];
                if (linkage.getLinkageID() == 5) {
                    return;
                }
                ++n4;
            }
            ++n2;
        }
        CCorePlugin.log((int)1, (String)("Reindexing " + this.project.getName() + " because Qt nature has been added"));
        CCorePlugin.getIndexManager().reindex(cProject);
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

