/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ast.IASTCompletionNode;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexManager;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.ui.editor.CEditor;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.contentassist.Lazy;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ContentAssistInvocationContext;
import org.eclipse.cdt.ui.text.contentassist.ICEditorContentAssistInvocationContext;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.ui.IEditorPart;

public class CContentAssistInvocationContext
extends ContentAssistInvocationContext
implements ICEditorContentAssistInvocationContext {
    private final IEditorPart fEditor;
    private final boolean fIsCompletion;
    private final boolean fIsAutoActivated;
    private IIndex fIndex = null;
    private Lazy<Integer> fContextInfoPosition = new Lazy<Integer>(){

        @Override
        protected Integer calculateValue() {
            return CContentAssistInvocationContext.this.guessContextInformationPosition();
        }
    };
    private final Lazy<ITranslationUnit> fTU;
    private final Lazy<Integer> fParseOffset = new Lazy<Integer>(){

        @Override
        protected Integer calculateValue() {
            if (CContentAssistInvocationContext.this.fIsCompletion) {
                return CContentAssistInvocationContext.this.guessCompletionPosition(CContentAssistInvocationContext.this.getInvocationOffset());
            }
            int contextInfoPosition = (Integer)CContentAssistInvocationContext.this.fContextInfoPosition.value();
            if (contextInfoPosition > 0) {
                return CContentAssistInvocationContext.this.guessCompletionPosition(contextInfoPosition);
            }
            return -1;
        }
    };
    private final Lazy<IASTCompletionNode> fCN = new Lazy<IASTCompletionNode>(){

        @Override
        protected IASTCompletionNode calculateValue() {
            int offset = CContentAssistInvocationContext.this.getParseOffset();
            if (offset < 0) {
                return null;
            }
            ICProject proj = CContentAssistInvocationContext.this.getProject();
            if (proj == null) {
                return null;
            }
            try {
                IIndexManager manager = CCorePlugin.getIndexManager();
                CContentAssistInvocationContext.this.fIndex = manager.getIndex(proj, 17);
                try {
                    CContentAssistInvocationContext.this.fIndex.acquireReadLock();
                }
                catch (InterruptedException interruptedException) {
                    CContentAssistInvocationContext.this.fIndex = null;
                }
                boolean parseNonIndexed = CUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.cdt.ui.editor.UseStructuralMode");
                int flags = parseNonIndexed ? 2 : 6;
                return ((ITranslationUnit)CContentAssistInvocationContext.this.fTU.value()).getCompletionNode(CContentAssistInvocationContext.this.fIndex, flags |= 0x20, offset);
            }
            catch (CoreException e) {
                CUIPlugin.log(e);
                return null;
            }
        }
    };
    private final Lazy<Boolean> afterOpeningAngleBracket = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int parseOffset = CContentAssistInvocationContext.this.getParseOffset();
            int invocationOffset = CContentAssistInvocationContext.this.getInvocationOffset();
            CHeuristicScanner scanner = new CHeuristicScanner(CContentAssistInvocationContext.this.getDocument());
            int parenthesisOffset = scanner.findOpeningPeer(invocationOffset, parseOffset, '<', '>');
            if (parenthesisOffset != -1) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> afterOpeningParenthesis = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int invocationOffset = CContentAssistInvocationContext.this.getInvocationOffset();
            int parseOffset = CContentAssistInvocationContext.this.getParseOffset();
            int bound = Math.max(-1, parseOffset - 1);
            CHeuristicScanner scanner = new CHeuristicScanner(CContentAssistInvocationContext.this.getDocument());
            int parenthesisOffset = scanner.findOpeningPeer(invocationOffset, bound, '(', ')');
            if (parenthesisOffset != -1) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> inUsingDeclaration = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int offset;
            IDocument doc = CContentAssistInvocationContext.this.getDocument();
            CHeuristicScanner.TokenStream tokenStream = new CHeuristicScanner.TokenStream(doc, offset = Math.max(0, CContentAssistInvocationContext.this.getInvocationOffset() - 1));
            int token = tokenStream.previousToken();
            if (token == 2000) {
                token = tokenStream.previousToken();
            }
            while (token == 20) {
                token = tokenStream.previousToken();
                if (token == 1039) {
                    return true;
                }
                if (token != 2000) {
                    return false;
                }
                token = tokenStream.previousToken();
            }
            if (token == 1039) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<Boolean> followedBySemicolon = new Lazy<Boolean>(){

        @Override
        protected Boolean calculateValue() {
            int offset;
            IDocument doc = CContentAssistInvocationContext.this.getDocument();
            CHeuristicScanner.TokenStream tokenStream = new CHeuristicScanner.TokenStream(doc, offset = CContentAssistInvocationContext.this.getInvocationOffset());
            int token = tokenStream.nextToken();
            if (token == 7) {
                return true;
            }
            return false;
        }
    };
    private final Lazy<String> functionParameterDelimiter = new Lazy<String>(){

        @Override
        protected String calculateValue() {
            String propertyKey = "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_method_declaration_parameters";
            Map options = CContentAssistInvocationContext.this.getProject().getOptions(true);
            return ((String)options.get(propertyKey)).equals("insert") ? ", " : ",";
        }
    };
    private final Lazy<String> templateParameterDelimiter = new Lazy<String>(){

        @Override
        protected String calculateValue() {
            String propertyKey = "org.eclipse.cdt.core.formatter.insert_space_after_comma_in_template_parameters";
            Map options = CContentAssistInvocationContext.this.getProject().getOptions(true);
            return ((String)options.get(propertyKey)).equals("insert") ? ", " : ",";
        }
    };

    public CContentAssistInvocationContext(ITextViewer viewer, int offset, IEditorPart editor, boolean isCompletion, boolean isAutoActivated) {
        super(viewer, offset);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fIsCompletion = isCompletion;
        this.fIsAutoActivated = isAutoActivated;
        this.fTU = new Lazy<ITranslationUnit>(){

            @Override
            protected ITranslationUnit calculateValue() {
                return CUIPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(CContentAssistInvocationContext.this.fEditor.getEditorInput());
            }
        };
    }

    public CContentAssistInvocationContext(final ITranslationUnit unit, boolean isCompletion) {
        this.fTU = new Lazy<ITranslationUnit>(){

            @Override
            protected ITranslationUnit calculateValue() {
                return unit;
            }
        };
        this.fEditor = null;
        this.fIsCompletion = isCompletion;
        this.fIsAutoActivated = false;
    }

    @Override
    public ITranslationUnit getTranslationUnit() {
        return this.fTU.value();
    }

    @Override
    public ICProject getProject() {
        ITranslationUnit unit = this.getTranslationUnit();
        return unit == null ? null : unit.getCProject();
    }

    @Override
    public IASTCompletionNode getCompletionNode() {
        if (this.fEditor != null && this.fEditor instanceof CEditor) {
            CEditor editor = (CEditor)this.fEditor;
            if (!editor.shouldProcessLocalParsingCompletions()) {
                return null;
            }
            if (editor.isEnableScalablilityMode()) {
                if (editor.isParserBasedContentAssistDisabled()) {
                    return null;
                }
                if (this.isAutoActivated() && editor.isContentAssistAutoActivartionDisabled()) {
                    return null;
                }
            }
        }
        return this.fCN.value();
    }

    @Override
    public int getParseOffset() {
        return this.fParseOffset.value();
    }

    @Override
    public int getContextInformationOffset() {
        return this.fContextInfoPosition.value();
    }

    protected int guessCompletionPosition(int contextPosition) {
        int bound;
        CHeuristicScanner scanner = new CHeuristicScanner(this.getDocument());
        int pos = scanner.findNonWhitespaceBackward(contextPosition - 1, bound = Math.max(-1, contextPosition - 200));
        if (pos == -1) {
            return contextPosition;
        }
        int token = scanner.previousToken(pos, bound);
        if (token == 11) {
            int openingAngleBracketPos;
            int openingParenthesisPos = scanner.findOpeningPeer(pos, bound, '(', ')');
            if ((pos = Math.max(openingParenthesisPos, openingAngleBracketPos = scanner.findOpeningPeer(pos, bound, '<', '>'))) == -1) {
                return contextPosition;
            }
            token = scanner.previousToken(pos, bound);
        }
        if (token == 5 || token == 13) {
            if ((pos = scanner.findNonWhitespaceBackward(pos - 1, bound)) == -1) {
                return contextPosition;
            }
            token = scanner.previousToken(pos, bound);
            if (token == 14) {
                if ((pos = scanner.findOpeningPeer(pos - 1, '<', '>')) == -1) {
                    return contextPosition;
                }
                if ((pos = scanner.findNonWhitespaceBackward(pos - 1, bound)) == -1) {
                    return contextPosition;
                }
                token = scanner.previousToken(pos, bound);
            }
            if (token == 2000) {
                return pos + 1;
            }
        }
        return contextPosition;
    }

    protected int guessContextInformationPosition() {
        int angle;
        int paren;
        int nearestPeer;
        int contextPosition = this.getInvocationOffset();
        CHeuristicScanner scanner = new CHeuristicScanner(this.getDocument());
        int bound = Math.max(-1, contextPosition - 200);
        int pos = contextPosition - 1;
        while ((nearestPeer = Math.max(paren = scanner.findOpeningPeer(pos, bound, '(', ')'), angle = scanner.findOpeningPeer(pos, bound, '<', '>'))) != -1) {
            int token = scanner.previousToken(nearestPeer - 1, bound);
            if (token == 2000 || token == 14) {
                return nearestPeer + 1;
            }
            pos = nearestPeer - 1;
        }
        return -1;
    }

    @Override
    public IEditorPart getEditor() {
        return this.fEditor;
    }

    @Override
    public boolean isContextInformationStyle() {
        return !this.fIsCompletion || this.getParseOffset() != this.getInvocationOffset();
    }

    public boolean isAutoActivated() {
        return this.fIsAutoActivated;
    }

    @Override
    public void dispose() {
        if (this.fIndex != null) {
            this.fIndex.releaseReadLock();
        }
        super.dispose();
    }

    public boolean isAfterOpeningParenthesis() {
        return this.afterOpeningParenthesis.value();
    }

    public boolean isAfterOpeningAngleBracket() {
        return this.afterOpeningAngleBracket.value();
    }

    public boolean isInUsingDirective() {
        return this.inUsingDeclaration.value();
    }

    public boolean isFollowedBySemicolon() {
        return this.followedBySemicolon.value();
    }

    public String getFunctionParameterDelimiter() {
        return this.functionParameterDelimiter.value();
    }

    public String getTemplateParameterDelimiter() {
        return this.templateParameterDelimiter.value();
    }
}

