/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.docker.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.internal.docker.launcher.ILaunchConstants;
import org.eclipse.cdt.internal.docker.launcher.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.docker.ui.launch.ContainerLauncher;
import org.eclipse.linuxtools.docker.ui.launch.IContainerLaunchListener;

public class ContainerLaunchConfigurationDelegate
extends GdbLaunchDelegate
implements ILaunchConfigurationDelegate {
    private ContainerLauncher launcher = new ContainerLauncher();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPath commandPath = this.getCommandPath(configuration);
        if (commandPath != null) {
            if (mode.equals("run")) {
                String commandDir = commandPath.removeLastSegments(1).toString();
                StringBuffer b = new StringBuffer();
                b.append(commandPath.toString().trim());
                String arguments = this.getProgramArguments(configuration);
                if (arguments.trim().length() > 0) {
                    b.append(" ");
                    b.append(arguments);
                }
                String command = b.toString();
                String workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                Map envMap = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                Map<String, String> origEnv = null;
                boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                if (appendEnv) {
                    origEnv = System.getenv();
                }
                List additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null);
                String image = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                String connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
                boolean keepContainer = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
                boolean supportStdin = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
                this.launcher.launch("org.eclipse.cdt.docker.launcher", null, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, null, keepContainer, supportStdin);
            } else if (mode.equals("debug")) {
                String gdbserverPortNumber = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_PORT, "2345");
                List<String> ports = Arrays.asList(String.valueOf(gdbserverPortNumber) + "/tcp");
                String gdbserverCommand = configuration.getAttribute(ILaunchConstants.ATTR_GDBSERVER_COMMAND, "gdbserver");
                String commandArguments = ":" + gdbserverPortNumber + " " + this.spaceEscapify(commandPath.toString());
                String commandDir = commandPath.removeLastSegments(1).toString();
                StringBuffer b = new StringBuffer();
                b.append(String.valueOf(gdbserverCommand) + " " + commandArguments);
                String arguments = this.getProgramArguments(configuration);
                if (arguments.trim().length() > 0) {
                    b.append(" ");
                    b.append(arguments);
                }
                String command = b.toString();
                String workingDir = configuration.getAttribute("org.eclipse.cdt.launch.WORKING_DIRECTORY", null);
                Map envMap = configuration.getAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, null);
                Map<String, String> origEnv = null;
                boolean appendEnv = configuration.getAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, false);
                if (appendEnv) {
                    origEnv = System.getenv();
                }
                List additionalDirs = configuration.getAttribute(ILaunchConstants.ATTR_ADDITIONAL_DIRS, null);
                String image = configuration.getAttribute(ILaunchConstants.ATTR_IMAGE, null);
                String connectionUri = configuration.getAttribute(ILaunchConstants.ATTR_CONNECTION_URI, "");
                boolean keepContainer = configuration.getAttribute(ILaunchConstants.ATTR_KEEP_AFTER_LAUNCH, false);
                boolean supportStdin = configuration.getAttribute(ILaunchConstants.ATTR_STDIN_SUPPORT, false);
                StartGdbServerJob job = new StartGdbServerJob(Messages.Gdbserver_start);
                job.schedule();
                this.launcher.launch("org.eclipse.cdt.docker.launcher", (IContainerLaunchListener)job, connectionUri, image, command, commandDir, workingDir, additionalDirs, origEnv, envMap, ports, keepContainer, supportStdin);
                try {
                    job.join();
                }
                catch (InterruptedException interruptedException) {}
                if (job.getResult() == Status.OK_STATUS && job.getIpAddress() != null) {
                    ILaunchConfigurationWorkingCopy wc = configuration.getWorkingCopy();
                    wc.setAttribute("org.eclipse.cdt.dsf.gdb.REMOTE_TCP", true);
                    wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
                    wc.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", job.getIpAddress());
                    wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", gdbserverPortNumber);
                    wc.doSave();
                    try {
                        try {
                            super.launch(configuration, mode, launch, monitor);
                        }
                        catch (CoreException ex) {
                            this.launcher.cleanup(connectionUri, job.getContainerInfo());
                            throw ex;
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            }
        }
    }

    private String getProgramArguments(ILaunchConfiguration config) throws CoreException {
        String args = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_ARGUMENTS", "");
        if (args != null && args.length() > 0) {
            args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(args);
        }
        return args;
    }

    private IPath getCommandPath(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        if (projectName.length() > 0) {
            IProject project = CCorePlugin.getWorkspace().getRoot().getProject(projectName);
            if (project == null) {
                return null;
            }
            String name = configuration.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            if (name.length() == 0) {
                return null;
            }
            Path exePath = new Path(name);
            if (!exePath.isAbsolute()) {
                IPath location = project.getLocation();
                if (location == null) {
                    return null;
                }
                exePath = location.append(name);
                if (!exePath.toFile().exists()) {
                    IFile projFile = null;
                    try {
                        projFile = project.getFile(name);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    if (projFile == null || !projFile.exists()) {
                        return null;
                    }
                    exePath = projFile.getLocation();
                }
            }
            if (!exePath.toFile().exists()) {
                return null;
            }
            if (!exePath.toFile().isFile()) {
                return null;
            }
            return exePath;
        }
        return null;
    }

    private String spaceEscapify(String inputString) {
        if (inputString == null) {
            return null;
        }
        return inputString.replaceAll(" ", "\\\\ ");
    }

    protected String getPluginID() {
        return "org.eclipse.cdt.docker.launcher";
    }

    private class StartGdbServerJob
    extends Job
    implements IContainerLaunchListener {
        private boolean started;
        private boolean done;
        private IDockerContainerInfo info;

        public StartGdbServerJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(this.getName(), -1);
            while (!this.done) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (this.started && this.getIpAddress() != null) {
                    this.done = true;
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public void newOutput(String output) {
            if (output.contains(Messages.Gdbserver_up)) {
                this.started = true;
            }
        }

        public String getIpAddress() {
            if (this.info != null) {
                IDockerNetworkSettings networkSettings = this.info.networkSettings();
                return networkSettings.ipAddress();
            }
            return null;
        }

        public IDockerContainerInfo getContainerInfo() {
            return this.info;
        }

        public void done() {
            this.done = true;
        }

        public void containerInfo(IDockerContainerInfo info) {
            this.info = info;
        }
    }
}

