/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import org.eclipse.cdt.arduino.core.Board;
import org.eclipse.cdt.arduino.core.IArduinoBoardManager;
import org.eclipse.cdt.arduino.core.IArduinoRemoteConnection;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.arduino.core.internal.ArduinoProjectNature;
import org.eclipse.cdt.arduino.core.internal.Messages;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.extension.CConfigurationData;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IManagedProject;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedProject;
import org.eclipse.cdt.managedbuilder.internal.core.ToolChain;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionType;
import org.eclipse.remote.core.IRemoteServicesManager;
import org.osgi.framework.Bundle;

public class ArduinoProjectGenerator {
    public static final String BOARD_OPTION_ID = "org.eclipse.cdt.arduino.option.board";
    public static final String AVR_TOOLCHAIN_ID = "org.eclipse.cdt.arduino.toolChain.avr";
    private final IProject project;
    private IFile sourceFile;

    public ArduinoProjectGenerator(IProject project) {
        this.project = project;
    }

    public void setupArduinoProject(IProgressMonitor monitor) throws CoreException {
        IProjectDescription projDesc = this.project.getDescription();
        String[] oldIds = projDesc.getNatureIds();
        String[] newIds = new String[oldIds.length + 1];
        System.arraycopy(oldIds, 0, newIds, 0, oldIds.length);
        newIds[newIds.length - 1] = ArduinoProjectNature.ID;
        projDesc.setNatureIds(newIds);
        this.project.setDescription(projDesc, monitor);
        CCorePlugin.getDefault().createCDTProject(projDesc, this.project, monitor);
        ICProjectDescription cprojDesc = CCorePlugin.getDefault().createProjectDescription(this.project, false);
        ManagedBuildInfo info = ManagedBuildManager.createBuildInfo((IResource)this.project);
        ManagedProject mProj = new ManagedProject(cprojDesc);
        info.setManagedProject((IManagedProject)mProj);
        Board board = null;
        IRemoteServicesManager remoteManager = Activator.getService(IRemoteServicesManager.class);
        IRemoteConnectionType connectionType = remoteManager.getConnectionType("org.eclipse.cdt.arduino.core.connectionType");
        List connections = connectionType.getConnections();
        if (!connections.isEmpty()) {
            IRemoteConnection firstConnection = (IRemoteConnection)connections.iterator().next();
            IArduinoRemoteConnection firstArduino = (IArduinoRemoteConnection)firstConnection.getService(IArduinoRemoteConnection.class);
            board = firstArduino.getBoard();
        }
        if (board == null) {
            IArduinoBoardManager boardManager = Activator.getService(IArduinoBoardManager.class);
            board = boardManager.getBoard("uno");
        }
        ArduinoProjectGenerator.createBuildConfiguration(cprojDesc, board);
        CCorePlugin.getDefault().setProjectDescription(this.project, cprojDesc, true, monitor);
        try {
            Configuration fmConfig = new Configuration(Configuration.VERSION_2_3_22);
            URL templateDirURL = FileLocator.find((Bundle)Activator.getContext().getBundle(), (IPath)new Path("/templates"), null);
            fmConfig.setDirectoryForTemplateLoading(new File(FileLocator.toFileURL((URL)templateDirURL).toURI()));
            HashMap<String, String> fmModel = new HashMap<String, String>();
            fmModel.put("projectName", this.project.getName());
            ArduinoProjectGenerator.generateFile(fmModel, fmConfig.getTemplate("Makefile"), this.project.getFile("Makefile"));
            ArduinoProjectGenerator.generateFile(fmModel, fmConfig.getTemplate("arduino.mk"), this.project.getFile("arduino.mk"));
            this.sourceFile = this.project.getFile(String.valueOf(this.project.getName()) + ".cpp");
            ArduinoProjectGenerator.generateFile(fmModel, fmConfig.getTemplate("arduino.cpp"), this.sourceFile);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
        catch (URISyntaxException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
        catch (TemplateException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
        this.project.build(6, monitor);
    }

    private static void generateFile(Object model, Template template, final IFile outputFile) throws TemplateException, IOException, CoreException {
        final PipedInputStream in = new PipedInputStream();
        PipedOutputStream out = new PipedOutputStream(in);
        OutputStreamWriter writer = new OutputStreamWriter(out);
        Job job = new Job(Messages.ArduinoProjectGenerator_0){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    outputFile.create((InputStream)in, true, monitor);
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)outputFile.getProject());
        job.schedule();
        template.process(model, (Writer)writer);
        ((Writer)writer).close();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {}
        IStatus status = job.getResult();
        if (!status.isOK()) {
            throw new CoreException(status);
        }
    }

    public static ICConfigurationDescription createBuildConfiguration(ICProjectDescription projDesc, Board board) throws CoreException {
        ManagedProject managedProject = new ManagedProject(projDesc);
        String configId = ManagedBuildManager.calculateChildId((String)AVR_TOOLCHAIN_ID, null);
        IToolChain avrToolChain = ManagedBuildManager.getExtensionToolChain((String)AVR_TOOLCHAIN_ID);
        org.eclipse.cdt.managedbuilder.internal.core.Configuration newConfig = new org.eclipse.cdt.managedbuilder.internal.core.Configuration(managedProject, (ToolChain)avrToolChain, configId, board.getId());
        IToolChain newToolChain = newConfig.getToolChain();
        IOption newOption = newToolChain.getOptionBySuperClassId(BOARD_OPTION_ID);
        ManagedBuildManager.setOption((IConfiguration)newConfig, (IHoldsOptions)newToolChain, (IOption)newOption, (String)board.getId());
        CConfigurationData data = newConfig.getConfigurationData();
        return projDesc.createConfiguration("org.eclipse.cdt.managedbuilder.core.configurationDataProvider", data);
    }

    public static Board getBoard(IConfiguration configuration) throws CoreException {
        try {
            IToolChain toolChain = configuration.getToolChain();
            IOption boardOption = toolChain.getOptionBySuperClassId(BOARD_OPTION_ID);
            String boardId = boardOption.getStringValue();
            IArduinoBoardManager boardManager = Activator.getService(IArduinoBoardManager.class);
            Board board = boardManager.getBoard(boardId);
            if (board == null) {
                board = boardManager.getBoard("uno");
            }
            return board;
        }
        catch (BuildException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getId(), e.getLocalizedMessage(), (Throwable)e));
        }
    }

    public IFile getSourceFile() {
        return this.sourceFile;
    }
}

