/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import java.io.File;
import java.util.List;
import org.eclipse.cdt.arduino.core.ArduinoHome;
import org.eclipse.cdt.arduino.core.ArduinoProjectGenerator;
import org.eclipse.cdt.arduino.core.Board;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.language.settings.providers.GCCBuiltinSpecsDetector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class AvrLanguageSettingsProvider
extends GCCBuiltinSpecsDetector {
    public String getToolchainId() {
        return "org.eclipse.cdt.arduino.toolChain.avr";
    }

    protected String getToolOptions(String languageId) {
        String opts = super.getToolOptions(languageId);
        try {
            IConfiguration config = ManagedBuildManager.getConfigurationForDescription((ICConfigurationDescription)this.currentCfgDescription);
            Board board = ArduinoProjectGenerator.getBoard(config);
            String mcu = board.getMCU();
            if (mcu != null) {
                opts = String.valueOf(opts) + " -mmcu=" + mcu;
            }
        }
        catch (CoreException e) {
            Activator.getPlugin().getLog().log(e.getStatus());
        }
        return opts;
    }

    protected List<String> parseOptions(String line) {
        if (Platform.getOS().equals("win32") && line.startsWith(" /arduino/")) {
            File full = new File(ArduinoHome.getArduinoHome().getParentFile(), line.trim());
            return this.parseOptions(" " + full.getAbsolutePath());
        }
        return super.parseOptions(line);
    }

    public AvrLanguageSettingsProvider cloneShallow() throws CloneNotSupportedException {
        return (AvrLanguageSettingsProvider)super.cloneShallow();
    }

    public AvrLanguageSettingsProvider clone() throws CloneNotSupportedException {
        return (AvrLanguageSettingsProvider)super.clone();
    }
}

