/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.remote;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cdt.arduino.core.ArduinoHome;
import org.eclipse.cdt.arduino.core.Board;
import org.eclipse.cdt.arduino.core.IArduinoBoardManager;

public class ArduinoBoardManager
implements IArduinoBoardManager {
    private Map<String, Board> boards;

    @Override
    public Board getBoard(String id) {
        this.init();
        return this.boards.get(id);
    }

    @Override
    public Collection<Board> getBoards() {
        this.init();
        ArrayList<Board> sortedBoards = new ArrayList<Board>(this.boards.values());
        Collections.sort(sortedBoards, new Comparator<Board>(){

            @Override
            public int compare(Board arg0, Board arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return sortedBoards;
    }

    private void init() {
        if (this.boards != null) {
            return;
        }
        this.boards = new HashMap<String, Board>();
        File home = ArduinoHome.getArduinoHome();
        if (!home.isDirectory()) {
            return;
        }
        File archRoot = new File(home, "hardware/arduino");
        File[] fileArray = archRoot.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File archDir = fileArray[n2];
            File boardFile = new File(archDir, "boards.txt");
            this.loadBoardFile(archDir.getName(), boardFile);
            ++n2;
        }
    }

    private void loadBoardFile(String arch, File boardFile) {
        try {
            Properties boardProps = new Properties();
            boardProps.load(new FileInputStream(boardFile));
            Enumeration<?> i = boardProps.propertyNames();
            while (i.hasMoreElements()) {
                String propertyName = (String)i.nextElement();
                String[] names = propertyName.split("\\.");
                if (names.length != 2 || !names[1].equals("name")) continue;
                this.boards.put(names[0], new Board(names[0], boardProps));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

