/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal.remote;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.arduino.core.Board;
import org.eclipse.cdt.arduino.core.IArduinoBoardManager;
import org.eclipse.cdt.arduino.core.IArduinoRemoteConnection;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionChangeListener;
import org.eclipse.remote.core.IRemoteConnectionPropertyService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.RemoteConnectionChangeEvent;
import org.eclipse.remote.serial.core.SerialPortCommandShell;

public class ArduinoRemoteConnection
implements IRemoteConnectionPropertyService,
IRemoteCommandShellService,
IArduinoRemoteConnection,
IRemoteConnectionChangeListener {
    private final IArduinoBoardManager boardManager = Activator.getService(IArduinoBoardManager.class);
    private final IRemoteConnection remoteConnection;
    private SerialPort serialPort;
    private SerialPortCommandShell commandShell;
    private static final Map<IRemoteConnection, ArduinoRemoteConnection> connectionMap = new HashMap<IRemoteConnection, ArduinoRemoteConnection>();

    public ArduinoRemoteConnection(IRemoteConnection remoteConnection) {
        this.remoteConnection = remoteConnection;
        remoteConnection.addConnectionChangeListener((IRemoteConnectionChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionChanged(RemoteConnectionChangeEvent event) {
        if (event.getType() == 32) {
            Map<IRemoteConnection, ArduinoRemoteConnection> map = connectionMap;
            synchronized (map) {
                connectionMap.remove(event.getConnection());
            }
        }
    }

    public IRemoteConnection getRemoteConnection() {
        return this.remoteConnection;
    }

    public String getProperty(String key) {
        if ("os.name".equals(key)) {
            return "arduino";
        }
        if ("os.arch".equals(key)) {
            return "avr";
        }
        return null;
    }

    @Override
    public Board getBoard() {
        String boardId = this.remoteConnection.getAttribute("arduino.board");
        if (boardId == null) {
            boardId = "uno";
        }
        return this.boardManager.getBoard(boardId);
    }

    @Override
    public String getPortName() {
        return this.remoteConnection.getAttribute("ardiuno.portname");
    }

    public IRemoteProcess getCommandShell(int flags) throws IOException {
        if (this.serialPort != null && this.serialPort.isOpen()) {
            return null;
        }
        this.serialPort = new SerialPort(this.getPortName());
        this.commandShell = new SerialPortCommandShell(this.remoteConnection, this.serialPort);
        return this.commandShell;
    }

    @Override
    public void pause() {
        if (this.serialPort != null) {
            try {
                if (this.serialPort.isOpen()) {
                    this.serialPort.pause();
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    @Override
    public void resume() {
        if (this.serialPort != null) {
            try {
                if (this.serialPort.isOpen()) {
                    this.serialPort.resume();
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
    }

    public static class Factory
    implements IRemoteConnection.Service.Factory {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends IRemoteConnection.Service> T getService(IRemoteConnection remoteConnection, Class<T> service) {
            if (IArduinoRemoteConnection.class.equals(service)) {
                Map map = connectionMap;
                synchronized (map) {
                    ArduinoRemoteConnection connection = (ArduinoRemoteConnection)connectionMap.get(remoteConnection);
                    if (connection == null) {
                        connection = new ArduinoRemoteConnection(remoteConnection);
                        connectionMap.put(remoteConnection, connection);
                    }
                    return (T)connection;
                }
            }
            if (IRemoteConnectionPropertyService.class.equals(service) || IRemoteCommandShellService.class.equals(service)) {
                return (T)remoteConnection.getService(IArduinoRemoteConnection.class);
            }
            return null;
        }
    }
}

