/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.browser.opentype;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.core.browser.IndexTypeInfo;
import org.eclipse.cdt.core.browser.QualifiedTypeName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndex;
import org.eclipse.cdt.core.index.IIndexBinding;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.internal.core.browser.IndexModelUtil;
import org.eclipse.cdt.internal.ui.browser.opentype.OpenTypeMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.browser.typeinfo.TypeSelectionDialog;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ElementSelectionDialog
extends TypeSelectionDialog {
    private static final ISchedulingRule SINGLE_INSTANCE_RULE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private UpdateElementsJob fUpdateJob;
    private boolean fAllowEmptyPrefix = true;
    private boolean fAllowEmptyString = true;
    private ProgressMonitorPart fProgressMonitorPart;
    private String fHelpContextId;

    public ElementSelectionDialog(Shell parent) {
        super(parent);
        this.setHelpContextId("org.eclipse.cdt.ui.open_element_dialog_context");
        this.setMatchEmptyString(false);
        this.fUpdateJob = new UpdateElementsJob(OpenTypeMessages.ElementSelectionDialog_UpdateElementsJob_name);
        this.fUpdateJob.setRule(SINGLE_INSTANCE_RULE);
    }

    @Override
    public void create() {
        super.create();
        this.scheduleUpdate(this.getFilter());
    }

    @Override
    public boolean close() {
        this.fUpdateJob.cancel();
        return super.close();
    }

    public void setHelpContextId(String helpContextId) {
        this.fHelpContextId = helpContextId;
        this.setHelpAvailable(this.fHelpContextId != null);
    }

    public void setMatchEmptyString(boolean matchEmptyString) {
        super.setMatchEmptyString(matchEmptyString);
        this.fAllowEmptyString = matchEmptyString;
        if (matchEmptyString) {
            this.setAllowEmptyPrefix(true);
        }
    }

    public void setAllowEmptyPrefix(boolean allowEmptyPrefix) {
        this.fAllowEmptyPrefix = allowEmptyPrefix;
    }

    @Override
    protected boolean showLowLevelFilter() {
        return false;
    }

    public Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, this.fHelpContextId);
        return super.createDialogArea(parent);
    }

    protected Table createLowerList(Composite parent) {
        Table table = super.createLowerList(parent);
        this.createProgressMonitorPart(parent);
        return table;
    }

    private void createProgressMonitorPart(Composite parent) {
        this.fProgressMonitorPart = new ProgressMonitorPart(parent, (Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        gridData.horizontalIndent = 0;
        gridData.verticalAlignment = 1;
        this.fProgressMonitorPart.setLayoutData((Object)gridData);
        Label separator = new Label(parent.getParent(), 258);
        separator.setLayoutData((Object)new GridData(768));
        this.fUpdateJob.addJobChangeListener((IJobChangeListener)new UpdateJobListener((IProgressMonitor)this.fProgressMonitorPart));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ITypeInfo[] getElementsByPrefix(char[] prefix, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return null;
        }
        HashSet<IndexTypeInfo> types = new HashSet<IndexTypeInfo>();
        if (prefix == null) return types.toArray(new ITypeInfo[types.size()]);
        IndexFilter filter = new IndexFilter(){

            public boolean acceptBinding(IBinding binding) throws CoreException {
                if (ElementSelectionDialog.this.isVisibleType(IndexModelUtil.getElementType((IBinding)binding))) {
                    return IndexFilter.ALL_DECLARED.acceptBinding(binding);
                }
                return false;
            }
        };
        try {
            IIndex index = CCorePlugin.getIndexManager().getIndex(CoreModel.getDefault().getCModel().getCProjects(), 8);
            index.acquireReadLock();
            try {
                IIndexBinding[] bindings = index.findBindingsForPrefix(prefix, false, filter, monitor);
                int i = 0;
                while (i < bindings.length) {
                    if (i % 4096 == 0 && monitor.isCanceled()) {
                        return null;
                    }
                    IndexTypeInfo typeinfo = IndexTypeInfo.create((IIndex)index, (IIndexBinding)bindings[i]);
                    types.add(typeinfo);
                    ++i;
                }
                if (!this.isVisibleType(79)) return types.toArray(new ITypeInfo[types.size()]);
                IIndexMacro[] macros = index.findMacrosForPrefix(prefix, IndexFilter.ALL_DECLARED, monitor);
                int i2 = 0;
                while (i2 < macros.length) {
                    if (i2 % 4096 == 0 && monitor.isCanceled()) {
                        return null;
                    }
                    IndexTypeInfo typeinfo = IndexTypeInfo.create((IIndex)index, (IIndexMacro)macros[i2]);
                    types.add(typeinfo);
                    ++i2;
                }
                return types.toArray(new ITypeInfo[types.size()]);
            }
            finally {
                index.releaseReadLock();
            }
        }
        catch (InterruptedException | CoreException e) {
            CUIPlugin.log(e);
        }
        return types.toArray(new ITypeInfo[types.size()]);
    }

    @Deprecated
    public void setElements(Object[] elements) {
        throw new UnsupportedOperationException();
    }

    protected void handleElementsChanged() {
        this.updateOkState();
    }

    protected void handleEmptyList() {
        this.updateOkState();
    }

    @Override
    protected Text createFilterText(Composite parent) {
        final Text result = super.createFilterText(parent);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ElementSelectionDialog.this.scheduleUpdate(result.getText());
            }
        };
        result.addListener(24, listener);
        return result;
    }

    protected void scheduleUpdate(String filterText) {
        boolean needQuery;
        char[] newPrefix = this.toPrefix(filterText);
        char[] currentPrefix = this.fUpdateJob.getCurrentPrefix();
        boolean equivalentPrefix = this.isEquivalentPrefix(currentPrefix, newPrefix);
        boolean emptyQuery = newPrefix.length == 0 && !this.fAllowEmptyPrefix || filterText.length() == 0 && !this.fAllowEmptyString;
        int jobState = this.fUpdateJob.getState();
        boolean bl = needQuery = !equivalentPrefix || currentPrefix.length < newPrefix.length && currentPrefix.length < 5 && jobState == 4;
        if (emptyQuery) {
            newPrefix = null;
            boolean bl2 = needQuery = needQuery || currentPrefix != null;
        }
        if (needQuery || jobState == 2 || jobState == 1) {
            this.fUpdateJob.cancel();
            this.fUpdateJob.scheduleQuery(newPrefix);
        }
    }

    private char[] toPrefix(String userFilter) {
        QualifiedTypeName qualifiedName = new QualifiedTypeName(userFilter);
        if (qualifiedName.segmentCount() > 1) {
            userFilter = qualifiedName.lastSegment();
        }
        if (userFilter.endsWith("<")) {
            userFilter = userFilter.substring(0, userFilter.length() - 1);
        }
        int asterisk = userFilter.indexOf("*");
        int questionMark = userFilter.indexOf("?");
        int prefixEnd = asterisk < 0 ? questionMark : (questionMark < 0 ? asterisk : Math.min(asterisk, questionMark));
        return (prefixEnd == -1 ? userFilter : userFilter.substring(0, prefixEnd)).toCharArray();
    }

    private boolean isEquivalentPrefix(char[] currentPrefix, char[] newPrefix) {
        if (currentPrefix == null || currentPrefix.length > newPrefix.length) {
            return false;
        }
        if (newPrefix.length == currentPrefix.length) {
            return Arrays.equals(currentPrefix, newPrefix);
        }
        return new String(currentPrefix).equals(new String(newPrefix, 0, currentPrefix.length));
    }

    private class UpdateElementsJob
    extends Job {
        private volatile char[] fCurrentPrefix;

        public UpdateElementsJob(String name) {
            super(name);
            this.setSystem(true);
            this.setUser(false);
            this.setPriority(30);
        }

        public char[] getCurrentPrefix() {
            return this.fCurrentPrefix;
        }

        public void scheduleQuery(char[] prefix) {
            this.fCurrentPrefix = prefix;
            int delay = this.fCurrentPrefix == null ? 0 : (this.fCurrentPrefix.length < 5 ? 400 : 200);
            this.schedule(delay);
        }

        public IStatus run(final IProgressMonitor monitor) {
            Shell shell;
            monitor.beginTask(OpenTypeMessages.ElementSelectionDialog_UpdateElementsJob_inProgress, -1);
            final ITypeInfo[] elements = ElementSelectionDialog.this.getElementsByPrefix(this.fCurrentPrefix, monitor);
            if (elements != null && !monitor.isCanceled() && (shell = ElementSelectionDialog.this.getShell()) != null && !shell.isDisposed()) {
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        if (!shell.isDisposed() && !monitor.isCanceled()) {
                            ElementSelectionDialog.this.setListElements(elements);
                            ElementSelectionDialog.this.updateOkState();
                        }
                    }
                };
                shell.getDisplay().asyncExec(update);
                monitor.done();
                return Status.OK_STATUS;
            }
            return Status.CANCEL_STATUS;
        }
    }

    private final class UpdateJobListener
    extends JobChangeAdapter {
        boolean fDone;
        private IProgressMonitor fMonitor;

        private UpdateJobListener(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void done(IJobChangeEvent event) {
            this.fDone = true;
            final Shell shell = ElementSelectionDialog.this.getShell();
            if (shell != null && !shell.isDisposed()) {
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        if (!shell.isDisposed() && UpdateJobListener.this.fDone) {
                            UpdateJobListener.this.fMonitor.done();
                        }
                    }
                };
                shell.getDisplay().asyncExec(update);
            }
        }

        public void running(IJobChangeEvent event) {
            this.fDone = false;
            final Shell shell = ElementSelectionDialog.this.getShell();
            if (shell != null && !shell.isDisposed()) {
                Runnable update = new Runnable(){

                    @Override
                    public void run() {
                        if (!shell.isDisposed() && !UpdateJobListener.this.fDone) {
                            UpdateJobListener.this.fMonitor.beginTask(OpenTypeMessages.ElementSelectionDialog_UpdateElementsJob_inProgress, -1);
                        }
                    }
                };
                shell.getDisplay().asyncExec(update);
            }
        }
    }
}

