/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.togglefunction;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTCompositeTypeSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.IASTDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTParameterDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTSimpleDeclaration;
import org.eclipse.cdt.core.dom.ast.IASTStandardFunctionDeclarator;
import org.eclipse.cdt.core.dom.ast.IASTStatement;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IASTTypeId;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTCatchHandler;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTConstructorChainInitializer;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTDeclSpecifier;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTFunctionWithTryBlock;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTNamespaceDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTQualifiedName;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTSimpleTypeTemplateParameter;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateDeclaration;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPASTTemplateId;
import org.eclipse.cdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTCompoundStatement;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionDefinition;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTFunctionWithTryBlock;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTNamedTypeSpecifier;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTQualifiedName;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTSimpleDeclaration;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTemplateId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPASTTypeId;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPVisitor;
import org.eclipse.cdt.internal.ui.refactoring.ModificationCollector;
import org.eclipse.cdt.internal.ui.refactoring.utils.NodeHelper;

public class ToggleNodeHelper
extends NodeHelper {
    private static final String EMPTY_STRING = "";

    private static void removeParameterInitializations(IASTFunctionDeclarator funcDecl) {
        IASTNode[] iASTNodeArray = funcDecl.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof IASTParameterDeclaration) {
                IASTParameterDeclaration parameter = (IASTParameterDeclaration)child;
                parameter.getDeclarator().setInitializer(null);
            }
            ++n2;
        }
    }

    private static List<ICPPASTConstructorChainInitializer> getInitializerList(IASTFunctionDefinition definition) {
        ArrayList<ICPPASTConstructorChainInitializer> initalizers = new ArrayList<ICPPASTConstructorChainInitializer>();
        IASTNode[] iASTNodeArray = definition.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode node = iASTNodeArray[n2];
            if (node instanceof ICPPASTConstructorChainInitializer) {
                initalizers.add(((ICPPASTConstructorChainInitializer)node).copy(IASTNode.CopyStyle.withLocations));
            }
            ++n2;
        }
        return initalizers;
    }

    static IASTSimpleDeclaration createDeclarationFromDefinition(IASTFunctionDefinition oldDefinition) {
        IASTFunctionDeclarator newDeclarator = oldDefinition.getDeclarator().copy(IASTNode.CopyStyle.withLocations);
        IASTDeclSpecifier newDeclSpec = oldDefinition.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        CPPASTSimpleDeclaration newDeclaration = new CPPASTSimpleDeclaration(newDeclSpec);
        newDeclaration.addDeclarator((IASTDeclarator)newDeclarator);
        return newDeclaration;
    }

    static ICPPASTFunctionDefinition createFunctionSignatureWithEmptyBody(IASTDeclSpecifier newDeclSpec, IASTFunctionDeclarator newFuncDecl, IASTFunctionDefinition oldDefinition) {
        Object newFunc = null;
        newFuncDecl = ToggleNodeHelper.adjustParamNames(newFuncDecl, oldDefinition);
        newFunc = oldDefinition instanceof ICPPASTFunctionWithTryBlock ? new CPPASTFunctionWithTryBlock(newDeclSpec, newFuncDecl, (IASTStatement)new CPPASTCompoundStatement()) : new CPPASTFunctionDefinition(newDeclSpec, newFuncDecl, (IASTStatement)new CPPASTCompoundStatement());
        ToggleNodeHelper.copyInitializerList((ICPPASTFunctionDefinition)newFunc, oldDefinition);
        return newFunc;
    }

    private static IASTFunctionDeclarator adjustParamNames(IASTFunctionDeclarator newFuncDecl, IASTFunctionDefinition oldDefinition) {
        if (oldDefinition.getDeclarator() instanceof IASTStandardFunctionDeclarator) {
            IASTStandardFunctionDeclarator oldStdDec = (IASTStandardFunctionDeclarator)oldDefinition.getDeclarator();
            IASTParameterDeclaration[] definitionParams = oldStdDec.getParameters();
            IASTParameterDeclaration[] declarationParams = ((IASTStandardFunctionDeclarator)newFuncDecl).getParameters();
            int i = 0;
            while (i < declarationParams.length) {
                declarationParams[i].getDeclarator().setName(definitionParams[i].getDeclarator().getName().copy(IASTNode.CopyStyle.withLocations));
                ++i;
            }
        }
        return newFuncDecl;
    }

    private static void copyInitializerList(ICPPASTFunctionDefinition newFunc, IASTFunctionDefinition oldFunc) {
        for (ICPPASTConstructorChainInitializer initializer : ToggleNodeHelper.getInitializerList(oldFunc)) {
            initializer.setParent((IASTNode)newFunc);
            newFunc.addMemberInitializer(initializer);
        }
    }

    static IASTFunctionDefinition getQualifiedNameDefinition(IASTFunctionDefinition oldDefinition, IASTTranslationUnit definitionUnit, IASTNode nameSpace) {
        ICPPASTDeclSpecifier newDeclSpec = (ICPPASTDeclSpecifier)oldDefinition.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        newDeclSpec.setVirtual(false);
        newDeclSpec.setInline(true);
        newDeclSpec.setStorageClass(0);
        IASTFunctionDeclarator newDeclarator = oldDefinition.getDeclarator().copy(IASTNode.CopyStyle.withLocations);
        newDeclarator.setName((IASTName)ToggleNodeHelper.getQualifiedName(oldDefinition.getDeclarator(), nameSpace));
        ToggleNodeHelper.removeParameterInitializations(newDeclarator);
        ICPPASTFunctionDefinition newFunction = ToggleNodeHelper.createFunctionSignatureWithEmptyBody((IASTDeclSpecifier)newDeclSpec, newDeclarator, oldDefinition);
        return newFunction;
    }

    public static ICPPASTTemplateDeclaration getTemplateDeclaration(IASTFunctionDefinition oldFunction, IASTFunctionDefinition newFunction) {
        ArrayList<ICPPASTTemplateDeclaration> templateDeclarations = ToggleNodeHelper.getAllTemplateDeclaration((IASTNode)oldFunction);
        return ToggleNodeHelper.addTemplateDeclarationsInOrder(templateDeclarations, newFunction);
    }

    private static ICPPASTTemplateDeclaration addTemplateDeclarationsInOrder(ArrayList<ICPPASTTemplateDeclaration> templDecs, IASTFunctionDefinition newFunction) {
        ListIterator<ICPPASTTemplateDeclaration> iter1 = templDecs.listIterator();
        ICPPASTTemplateDeclaration child = null;
        while (iter1.hasNext()) {
            child = iter1.next();
            child.setDeclaration((IASTDeclaration)newFunction);
            ListIterator<ICPPASTTemplateDeclaration> iter2 = iter1;
            if (!iter2.hasNext()) continue;
            ICPPASTTemplateDeclaration parent = iter2.next();
            child.setParent((IASTNode)parent);
            parent.setDeclaration((IASTDeclaration)child);
            child = parent;
        }
        return child;
    }

    private static ArrayList<ICPPASTTemplateDeclaration> getAllTemplateDeclaration(IASTNode node) {
        ArrayList<ICPPASTTemplateDeclaration> templdecs = new ArrayList<ICPPASTTemplateDeclaration>();
        while (node.getParent() != null) {
            if (!((node = node.getParent()) instanceof ICPPASTTemplateDeclaration)) continue;
            templdecs.add((ICPPASTTemplateDeclaration)node.copy(IASTNode.CopyStyle.withLocations));
        }
        return templdecs;
    }

    static IASTFunctionDefinition createInClassDefinition(IASTFunctionDeclarator dec, IASTFunctionDefinition def, IASTTranslationUnit insertionAst) {
        IASTFunctionDeclarator declarator = dec.copy(IASTNode.CopyStyle.withLocations);
        IASTDeclSpecifier declSpec = def.getDeclSpecifier().copy(IASTNode.CopyStyle.withLocations);
        declSpec.setInline(false);
        if (declSpec instanceof ICPPASTDeclSpecifier && ToggleNodeHelper.isVirtual(dec)) {
            ((ICPPASTDeclSpecifier)declSpec).setVirtual(true);
        }
        declSpec.setStorageClass(ToggleNodeHelper.getStorageClass(dec));
        return ToggleNodeHelper.createFunctionSignatureWithEmptyBody(declSpec, declarator, def);
    }

    static boolean isVirtual(IASTFunctionDeclarator fdec) {
        if (fdec.getParent() instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration dec = (IASTSimpleDeclaration)fdec.getParent();
            return ((ICPPASTDeclSpecifier)dec.getDeclSpecifier()).isVirtual();
        }
        return false;
    }

    static int getStorageClass(IASTFunctionDeclarator fdec) {
        if (fdec.getParent() instanceof IASTSimpleDeclaration) {
            IASTSimpleDeclaration dec = (IASTSimpleDeclaration)fdec.getParent();
            return dec.getDeclSpecifier().getStorageClass();
        }
        return -1;
    }

    static IASTNode getParentRemovePoint(IASTFunctionDefinition definition) {
        IASTFunctionDefinition toremove = definition;
        while (toremove.getParent() != null && toremove.getParent() instanceof ICPPASTTemplateDeclaration) {
            toremove = toremove.getParent();
        }
        return toremove;
    }

    static ICPPASTQualifiedName getQualifiedName(IASTFunctionDeclarator declarator, IASTNode limiter) {
        Stack<IASTNode> nodes = ToggleNodeHelper.getQualifiedNames(declarator, limiter, (IASTNode)declarator);
        CPPASTQualifiedName qName = ToggleNodeHelper.reAssembleQualifiedName(nodes);
        qName.addName(declarator.getName().copy(IASTNode.CopyStyle.withLocations));
        return qName;
    }

    private static CPPASTQualifiedName reAssembleQualifiedName(Stack<IASTNode> nodes) {
        CPPASTQualifiedName qName = new CPPASTQualifiedName();
        while (!nodes.isEmpty()) {
            IASTNode nnode = nodes.pop();
            if (nnode instanceof IASTCompositeTypeSpecifier) {
                qName.addName(((IASTCompositeTypeSpecifier)nnode).getName());
                continue;
            }
            if (nnode instanceof ICPPASTNamespaceDefinition) {
                qName.addName(((ICPPASTNamespaceDefinition)nnode).getName());
                continue;
            }
            if (!(nnode instanceof ICPPASTTemplateId)) continue;
            qName.addName((IASTName)((ICPPASTTemplateId)nnode));
        }
        return qName;
    }

    private static Stack<IASTNode> getQualifiedNames(IASTFunctionDeclarator declarator, IASTNode limiter, IASTNode node) {
        IASTName lastName = declarator.getName();
        Stack<IASTNode> nodes = new Stack<IASTNode>();
        while (node.getParent() != null && node.getParent() != limiter) {
            if ((node = node.getParent()) instanceof IASTCompositeTypeSpecifier) {
                nodes.push((IASTNode)((IASTCompositeTypeSpecifier)node).copy(IASTNode.CopyStyle.withLocations));
                lastName = ((IASTCompositeTypeSpecifier)node).getName();
                continue;
            }
            if (node instanceof ICPPASTNamespaceDefinition) {
                nodes.push((IASTNode)((ICPPASTNamespaceDefinition)node).copy(IASTNode.CopyStyle.withLocations));
                lastName = ((ICPPASTNamespaceDefinition)node).getName();
                continue;
            }
            if (!ToggleNodeHelper.shouldAddTemplateBrackets(node)) continue;
            if (!nodes.isEmpty()) {
                nodes.pop();
            }
            ICPPASTTemplateId templateID = ToggleNodeHelper.getTemplateParameter(node, lastName);
            nodes.add((IASTNode)templateID);
        }
        return nodes;
    }

    private static boolean shouldAddTemplateBrackets(IASTNode node) {
        return node instanceof ICPPASTTemplateDeclaration && !(((ICPPASTTemplateDeclaration)node).getDeclaration() instanceof CPPASTFunctionDefinition);
    }

    private static ICPPASTTemplateId getTemplateParameter(IASTNode node, IASTName name) {
        CPPASTTemplateId templateID = new CPPASTTemplateId();
        templateID.setTemplateName(name.copy(IASTNode.CopyStyle.withLocations));
        IASTNode[] iASTNodeArray = node.getChildren();
        int n = iASTNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTNode child = iASTNodeArray[n2];
            if (child instanceof ICPPASTSimpleTypeTemplateParameter) {
                ICPPASTSimpleTypeTemplateParameter tempChild = (ICPPASTSimpleTypeTemplateParameter)child;
                CPPASTNamedTypeSpecifier namedTypeSpecifier = new CPPASTNamedTypeSpecifier();
                namedTypeSpecifier.setName(tempChild.getName().copy(IASTNode.CopyStyle.withLocations));
                CPPASTTypeId id = new CPPASTTypeId();
                id.setDeclSpecifier((IASTDeclSpecifier)namedTypeSpecifier);
                templateID.addTemplateArgument((IASTTypeId)id);
            }
            ++n2;
        }
        return templateID;
    }

    public static String getFilenameWithoutExtension(String filename) {
        int indexP = filename.lastIndexOf(46);
        int indexS = filename.lastIndexOf(47);
        return filename.substring(++indexS, indexP);
    }

    public static ICPPASTFunctionDefinition getFunctionDefinition(IASTNode declaration) {
        IASTNode node = declaration;
        while (node != null) {
            if (node instanceof ICPPASTTemplateDeclaration) {
                ICPPASTTemplateDeclaration templdec = (ICPPASTTemplateDeclaration)node;
                node = templdec.getDeclaration();
                continue;
            }
            if (node instanceof ICPPASTFunctionDefinition) {
                return (ICPPASTFunctionDefinition)node;
            }
            return null;
        }
        return null;
    }

    public static String getBody(IASTFunctionDefinition oldDefinition, IASTTranslationUnit ast, ModificationCollector modifications) {
        return String.valueOf(ToggleNodeHelper.getBodyOnly(oldDefinition, ast, modifications)) + ToggleNodeHelper.getCatchHandlers(oldDefinition, ast, modifications);
    }

    private static String getBodyOnly(IASTFunctionDefinition oldDefinition, IASTTranslationUnit ast, ModificationCollector modifications) {
        String leadingComments = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getLeadingCommentsFromNode((IASTNode)oldDefinition.getBody(), ast, modifications));
        String trailingComments = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getTrailingComments((IASTNode)oldDefinition.getBody(), ast, modifications));
        return String.valueOf(leadingComments) + oldDefinition.getBody().getRawSignature() + trailingComments;
    }

    private static String getCatchHandlers(IASTFunctionDefinition oldDefinition, IASTTranslationUnit ast, ModificationCollector modifications) {
        if (oldDefinition instanceof ICPPASTFunctionWithTryBlock) {
            ICPPASTCatchHandler[] oldCatches = ((ICPPASTFunctionWithTryBlock)oldDefinition).getCatchHandlers();
            String allCatchHandlers = EMPTY_STRING;
            int i = 0;
            while (i < oldCatches.length) {
                String lead = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getLeadingCommentsFromNode((IASTNode)oldCatches[i], ast, modifications));
                String trail = ToggleNodeHelper.getCommentsAsString(ToggleNodeHelper.getTrailingComments((IASTNode)oldCatches[i], ast, modifications));
                allCatchHandlers = String.valueOf(allCatchHandlers) + lead + oldCatches[i].getRawSignature() + trail;
                ++i;
            }
            return allCatchHandlers;
        }
        return EMPTY_STRING;
    }

    private static List<IASTComment> getLeadingCommentsFromNode(IASTNode existingNode, IASTTranslationUnit ast, ModificationCollector modifications) {
        ASTRewrite rw = modifications.rewriterForTranslationUnit(ast);
        return rw.getComments(existingNode, ASTRewrite.CommentPosition.leading);
    }

    private static List<IASTComment> getTrailingComments(IASTNode existingNode, IASTTranslationUnit ast, ModificationCollector modifications) {
        ASTRewrite rw = modifications.rewriterForTranslationUnit(ast);
        return rw.getComments(existingNode, ASTRewrite.CommentPosition.trailing);
    }

    public static IASTNode getParentTemplateDeclaration(IASTNode def) {
        if (def == null) {
            return null;
        }
        IASTNode lastSeen = def;
        for (IASTNode node = def.getParent(); node != null; node = node.getParent()) {
            if (node instanceof ICPPASTTemplateDeclaration || node instanceof IASTSimpleDeclaration) {
                lastSeen = node;
                continue;
            }
            return lastSeen;
        }
        return lastSeen;
    }

    private static String getCommentsAsString(List<IASTComment> commentList) {
        String comments = EMPTY_STRING;
        for (IASTComment c : commentList) {
            comments = String.valueOf(comments) + c.getRawSignature() + System.getProperty("line.separator");
        }
        return comments;
    }

    public static List<ICPPASTNamespaceDefinition> findSurroundingNamespaces(IASTNode node) {
        ArrayList<ICPPASTNamespaceDefinition> namespaces = new ArrayList<ICPPASTNamespaceDefinition>();
        ICPPASTNamespaceDefinition currentNamespace = (ICPPASTNamespaceDefinition)CPPVisitor.findAncestorWithType((IASTNode)node, ICPPASTNamespaceDefinition.class);
        while (currentNamespace != null) {
            namespaces.add(0, currentNamespace);
            currentNamespace = (ICPPASTNamespaceDefinition)CPPVisitor.findAncestorWithType((IASTNode)currentNamespace.getParent(), ICPPASTNamespaceDefinition.class);
        }
        return namespaces;
    }
}

