/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.application;

import org.eclipse.cdt.debug.application.Messages;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.Util;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.internal.actions.CommandAction;
import org.eclipse.ui.internal.handlers.IActionCommandMappingService;
import org.eclipse.ui.internal.ide.IDEInternalWorkbenchImages;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.services.IServiceLocator;

public class ApplicationActionBarAdvisor
extends ActionBarAdvisor {
    public static String COREFILE_COMMAND_ID = "org.eclipse.cdt.debug.application.command.debugCore";
    public static String NEW_EXECUTABLE_COMMAND_ID = "org.eclipse.cdt.debug.application.command.debugNewExecutable";
    public static String ATTACH_EXECUTABLE_COMMAND_ID = "org.eclipse.cdt.debug.application.command.debugAttachedExecutable";
    public static String REMOTE_EXECUTABLE_COMMAND_ID = "org.eclipse.cdt.debug.application.command.debugRemoteExecutable";
    private final IWorkbenchWindow window;
    private ActionFactory.IWorkbenchAction corefileAction;
    private ActionFactory.IWorkbenchAction newExecutableAction;
    private ActionFactory.IWorkbenchAction remoteExecutableAction;
    private ActionFactory.IWorkbenchAction attachExecutableAction;
    private ActionFactory.IWorkbenchAction quitAction;
    private ActionFactory.IWorkbenchAction openPreferencesAction;
    private ActionFactory.IWorkbenchAction editActionSetAction;
    private ActionFactory.IWorkbenchAction helpContentsAction;
    private ActionFactory.IWorkbenchAction helpSearchAction;
    private ActionFactory.IWorkbenchAction dynamicHelpAction;
    private ActionFactory.IWorkbenchAction aboutAction;
    private ActionFactory.IWorkbenchAction undoAction;
    private ActionFactory.IWorkbenchAction redoAction;
    private static final ActionFactory COREFILE = new ActionFactory("corefile", COREFILE_COMMAND_ID){

        public ActionFactory.IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction(this.getCommandId(), window);
            action.setId(this.getId());
            action.setText(Messages.CoreFileMenuName);
            action.setToolTipText(Messages.CoreFile_toolTip);
            return action;
        }
    };
    private static final ActionFactory NEW_EXECUTABLE = new ActionFactory("newexecutable", NEW_EXECUTABLE_COMMAND_ID){

        public ActionFactory.IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction(this.getCommandId(), window);
            action.setId(this.getId());
            action.setText(Messages.NewExecutableMenuName);
            action.setToolTipText(Messages.NewExecutable_toolTip);
            return action;
        }
    };
    private static final ActionFactory REMOTE_EXECUTABLE = new ActionFactory("remoteexecutable", REMOTE_EXECUTABLE_COMMAND_ID){

        public ActionFactory.IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction(this.getCommandId(), window);
            action.setId(this.getId());
            action.setText(Messages.RemoteExecutableMenuName);
            action.setToolTipText(Messages.RemoteExecutable_toolTip);
            return action;
        }
    };
    private static final ActionFactory ATTACH_EXECUTABLE = new ActionFactory("attachexecutable", ATTACH_EXECUTABLE_COMMAND_ID){

        public ActionFactory.IWorkbenchAction create(IWorkbenchWindow window) {
            if (window == null) {
                throw new IllegalArgumentException();
            }
            WorkbenchCommandAction action = new WorkbenchCommandAction(this.getCommandId(), window);
            action.setId(this.getId());
            action.setText(Messages.AttachedExecutableMenuName);
            action.setToolTipText(Messages.AttachedExecutable_toolTip);
            return action;
        }
    };

    public ApplicationActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
        this.window = configurer.getWindowConfigurer().getWindow();
    }

    private IWorkbenchWindow getWindow() {
        return this.window;
    }

    protected void makeActions(IWorkbenchWindow window) {
        this.quitAction = ActionFactory.QUIT.create(window);
        this.register((IAction)this.quitAction);
        this.newExecutableAction = NEW_EXECUTABLE.create(window);
        this.register((IAction)this.newExecutableAction);
        this.attachExecutableAction = ATTACH_EXECUTABLE.create(window);
        this.register((IAction)this.attachExecutableAction);
        this.remoteExecutableAction = REMOTE_EXECUTABLE.create(window);
        this.register((IAction)this.remoteExecutableAction);
        this.corefileAction = COREFILE.create(window);
        this.register((IAction)this.corefileAction);
        this.editActionSetAction = ActionFactory.EDIT_ACTION_SETS.create(window);
        this.register((IAction)this.editActionSetAction);
        this.helpContentsAction = ActionFactory.HELP_CONTENTS.create(window);
        this.register((IAction)this.helpContentsAction);
        this.helpSearchAction = ActionFactory.HELP_SEARCH.create(window);
        this.register((IAction)this.helpSearchAction);
        this.dynamicHelpAction = ActionFactory.DYNAMIC_HELP.create(window);
        this.register((IAction)this.dynamicHelpAction);
        this.undoAction = ActionFactory.UNDO.create(window);
        this.register((IAction)this.undoAction);
        this.redoAction = ActionFactory.REDO.create(window);
        this.register((IAction)this.redoAction);
        this.aboutAction = ActionFactory.ABOUT.create(window);
        this.aboutAction.setImageDescriptor(IDEInternalWorkbenchImages.getImageDescriptor((String)"IMG_OBJS_DEFAULT_PROD"));
        this.register((IAction)this.aboutAction);
        this.openPreferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.openPreferencesAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        menuBar.add((IContributionItem)this.createFileMenu());
        menuBar.add((IContributionItem)this.createEditMenu());
        menuBar.add((IContributionItem)new GroupMarker("additions"));
        menuBar.add((IContributionItem)this.createWindowMenu());
        menuBar.add((IContributionItem)this.createHelpMenu());
    }

    private MenuManager createFileMenu() {
        MenuManager menu = new MenuManager(Messages.FileMenuName, "file");
        menu.add((IContributionItem)new GroupMarker("fileStart"));
        ActionContributionItem newExecutableItem = new ActionContributionItem((IAction)this.newExecutableAction);
        menu.add((IContributionItem)newExecutableItem);
        ActionContributionItem remoteExecutableItem = new ActionContributionItem((IAction)this.remoteExecutableAction);
        menu.add((IContributionItem)remoteExecutableItem);
        ActionContributionItem attachExecutableItem = new ActionContributionItem((IAction)this.attachExecutableAction);
        menu.add((IContributionItem)attachExecutableItem);
        ActionContributionItem corefileItem = new ActionContributionItem((IAction)this.corefileAction);
        menu.add((IContributionItem)corefileItem);
        menu.add((IContributionItem)new Separator());
        ActionContributionItem quitItem = new ActionContributionItem((IAction)this.quitAction);
        quitItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)quitItem);
        menu.add((IContributionItem)new GroupMarker("fileEnd"));
        return menu;
    }

    private MenuManager createEditMenu() {
        MenuManager menu = new MenuManager(Messages.EditMenuName, "edit");
        menu.add((IContributionItem)new GroupMarker("editStart"));
        menu.add((IAction)this.undoAction);
        menu.add((IAction)this.redoAction);
        menu.add((IContributionItem)new GroupMarker("undo.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getCutItem());
        menu.add(this.getCopyItem());
        menu.add(this.getPasteItem());
        menu.add((IContributionItem)new GroupMarker("cut.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getDeleteItem());
        menu.add(this.getSelectAllItem());
        menu.add((IContributionItem)new Separator());
        menu.add(this.getFindItem());
        menu.add((IContributionItem)new GroupMarker("find.ext"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getBookmarkItem());
        menu.add(this.getTaskItem());
        menu.add((IContributionItem)new GroupMarker("add.ext"));
        menu.add((IContributionItem)new GroupMarker("editEnd"));
        menu.add((IContributionItem)new Separator("additions"));
        return menu;
    }

    private MenuManager createWindowMenu() {
        MenuManager menu = new MenuManager(Messages.WindowMenuName, "window");
        this.addPerspectiveActions(menu);
        Separator sep = new Separator("additions");
        sep.setVisible(!Util.isMac());
        menu.add((IContributionItem)sep);
        ActionContributionItem openPreferencesItem = new ActionContributionItem((IAction)this.openPreferencesAction);
        openPreferencesItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)openPreferencesItem);
        menu.add(ContributionItemFactory.OPEN_WINDOWS.create(this.getWindow()));
        return menu;
    }

    private MenuManager createHelpMenu() {
        MenuManager menu = new MenuManager(Messages.HelpMenuName, "help");
        menu.add((IContributionItem)new GroupMarker("group.intro.ext"));
        menu.add((IContributionItem)new GroupMarker("group.main"));
        menu.add((IAction)this.helpContentsAction);
        menu.add((IAction)this.helpSearchAction);
        menu.add((IAction)this.dynamicHelpAction);
        menu.add((IContributionItem)new GroupMarker("group.assist"));
        menu.add((IContributionItem)new GroupMarker("helpStart"));
        menu.add((IContributionItem)new GroupMarker("group.main.ext"));
        menu.add((IContributionItem)new GroupMarker("group.tutorials"));
        menu.add((IContributionItem)new GroupMarker("group.tools"));
        menu.add((IContributionItem)new GroupMarker("group.updates"));
        menu.add((IContributionItem)new GroupMarker("helpEnd"));
        menu.add((IContributionItem)new GroupMarker("additions"));
        menu.add((IContributionItem)new Separator("group.about"));
        ActionContributionItem aboutItem = new ActionContributionItem((IAction)this.aboutAction);
        aboutItem.setVisible(!Util.isMac());
        menu.add((IContributionItem)aboutItem);
        menu.add((IContributionItem)new GroupMarker("group.about.ext"));
        return menu;
    }

    private void addPerspectiveActions(MenuManager menu) {
        MenuManager showViewMenuMgr = new MenuManager(Messages.ShowViewMenuName, "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(this.getWindow());
        showViewMenuMgr.add(showViewMenu);
        menu.add((IContributionItem)showViewMenuMgr);
        menu.add((IContributionItem)new Separator());
        menu.add((IAction)this.editActionSetAction);
        menu.add(this.getResetPerspectiveItem());
    }

    private IContributionItem getItem(String actionId, String commandId, String image, String disabledImage, String label, String tooltip, String helpContextId) {
        ISharedImages sharedImages = this.getWindow().getWorkbench().getSharedImages();
        IActionCommandMappingService acms = (IActionCommandMappingService)this.getWindow().getService(IActionCommandMappingService.class);
        acms.map(actionId, commandId);
        CommandContributionItemParameter commandParm = new CommandContributionItemParameter((IServiceLocator)this.getWindow(), actionId, commandId, null, sharedImages.getImageDescriptor(image), sharedImages.getImageDescriptor(disabledImage), null, label, null, tooltip, 8, null, false);
        return new CommandContributionItem(commandParm);
    }

    private IContributionItem getResetPerspectiveItem() {
        return this.getItem(ActionFactory.RESET_PERSPECTIVE.getId(), ActionFactory.RESET_PERSPECTIVE.getCommandId(), null, null, Messages.ResetPerspective_text, Messages.ResetPerspective_toolTip, "org.eclipse.ui.reset_perspective_action_context");
    }

    private IContributionItem getCutItem() {
        return this.getItem(ActionFactory.CUT.getId(), ActionFactory.CUT.getCommandId(), "IMG_TOOL_CUT", "IMG_TOOL_CUT_DISABLED", Messages.Workbench_cut, Messages.Workbench_cutToolTip, null);
    }

    private IContributionItem getCopyItem() {
        return this.getItem(ActionFactory.COPY.getId(), ActionFactory.COPY.getCommandId(), "IMG_TOOL_COPY", "IMG_TOOL_COPY_DISABLED", Messages.Workbench_copy, Messages.Workbench_copyToolTip, null);
    }

    private IContributionItem getPasteItem() {
        return this.getItem(ActionFactory.PASTE.getId(), ActionFactory.PASTE.getCommandId(), "IMG_TOOL_PASTE", "IMG_TOOL_PASTE_DISABLED", Messages.Workbench_paste, Messages.Workbench_pasteToolTip, null);
    }

    private IContributionItem getSelectAllItem() {
        return this.getItem(ActionFactory.SELECT_ALL.getId(), ActionFactory.SELECT_ALL.getCommandId(), null, null, Messages.Workbench_selectAll, Messages.Workbench_selectAllToolTip, null);
    }

    private IContributionItem getFindItem() {
        return this.getItem(ActionFactory.FIND.getId(), ActionFactory.FIND.getCommandId(), null, null, Messages.Workbench_findReplace, Messages.Workbench_findReplaceToolTip, null);
    }

    private IContributionItem getBookmarkItem() {
        return this.getItem(IDEActionFactory.BOOKMARK.getId(), IDEActionFactory.BOOKMARK.getCommandId(), null, null, Messages.Workbench_addBookmark, Messages.Workbench_addBookmarkToolTip, null);
    }

    private IContributionItem getTaskItem() {
        return this.getItem(IDEActionFactory.ADD_TASK.getId(), IDEActionFactory.ADD_TASK.getCommandId(), null, null, Messages.Workbench_addTask, Messages.Workbench_addTaskToolTip, null);
    }

    private IContributionItem getDeleteItem() {
        return this.getItem(ActionFactory.DELETE.getId(), ActionFactory.DELETE.getCommandId(), "IMG_TOOL_DELETE", "IMG_TOOL_DELETE_DISABLED", Messages.Workbench_delete, Messages.Workbench_deleteToolTip, "org.eclipse.ui.delete_retarget_action_context");
    }

    private static class WorkbenchCommandAction
    extends CommandAction
    implements ActionFactory.IWorkbenchAction {
        public WorkbenchCommandAction(String commandIdIn, IWorkbenchWindow window) {
            super((IServiceLocator)window, commandIdIn);
        }
    }
}

