/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.arduino.core.internal;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.cdt.arduino.core.ArduinoHome;
import org.eclipse.cdt.arduino.core.ArduinoProjectGenerator;
import org.eclipse.cdt.arduino.core.Board;
import org.eclipse.cdt.arduino.core.internal.Activator;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.envvar.IBuildEnvironmentVariable;
import org.eclipse.cdt.managedbuilder.envvar.IConfigurationEnvironmentVariableSupplier;
import org.eclipse.cdt.managedbuilder.envvar.IEnvironmentVariableProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;

public class EnvVarSupplier
implements IConfigurationEnvironmentVariableSupplier {
    private EnvVar arduinoHome = new EnvVar();
    private EnvVar arduinoLibs;
    private EnvVar path;
    private static final String OUTPUT_DIR = "OUTPUT_DIR";
    private static final String BOARD = "BOARD";

    private String clean(String str) {
        return str.replaceAll("\\\\", "/");
    }

    public EnvVarSupplier() {
        this.arduinoHome.name = "ARDUINO_HOME";
        this.arduinoHome.value = this.clean(ArduinoHome.getArduinoHome().getAbsolutePath());
        this.arduinoLibs = new EnvVar();
        this.arduinoLibs.name = "ARDUINO_USER_LIBS";
        this.arduinoLibs.value = this.clean(String.valueOf(System.getProperty("user.home")) + "/Documents/Arduino/libraries");
        String avrDir = String.valueOf(ArduinoHome.getArduinoHome().toString()) + "/hardware/tools/avr/bin";
        String installDir = Platform.getInstallLocation().getURL().getPath();
        this.path = new EnvVar();
        this.path.name = "PATH";
        this.path.value = String.valueOf(avrDir) + File.pathSeparator + installDir;
        this.path.operation = 3;
        this.path.delimiter = File.pathSeparator;
    }

    private IBuildEnvironmentVariable getOutputDir(IConfiguration configuration) {
        EnvVar outputDir = new EnvVar();
        outputDir.name = OUTPUT_DIR;
        outputDir.value = "build/" + configuration.getName();
        return outputDir;
    }

    private IBuildEnvironmentVariable getBoard(IConfiguration configuration) {
        Board board;
        block3: {
            try {
                board = ArduinoProjectGenerator.getBoard(configuration);
                if (board != null) break block3;
                return null;
            }
            catch (CoreException e) {
                Activator.getPlugin().getLog().log(e.getStatus());
                return null;
            }
        }
        EnvVar boardVar = new EnvVar();
        boardVar.name = BOARD;
        boardVar.value = board.getId();
        return boardVar;
    }

    public IBuildEnvironmentVariable getVariable(String variableName, IConfiguration configuration, IEnvironmentVariableProvider provider) {
        if (variableName.equals(this.path.name)) {
            return this.path;
        }
        if (variableName.equals(this.arduinoHome.name)) {
            return this.arduinoHome;
        }
        if (variableName.equals(this.arduinoLibs.name)) {
            return this.arduinoLibs;
        }
        if (variableName.equals(OUTPUT_DIR)) {
            return this.getOutputDir(configuration);
        }
        if (variableName.equals(BOARD)) {
            return this.getBoard(configuration);
        }
        return null;
    }

    public IBuildEnvironmentVariable[] getVariables(IConfiguration configuration, IEnvironmentVariableProvider provider) {
        ArrayList<IBuildEnvironmentVariable> vars = new ArrayList<IBuildEnvironmentVariable>();
        vars.add(this.path);
        vars.add(this.arduinoHome);
        vars.add(this.arduinoLibs);
        if (configuration != null) {
            vars.add(this.getOutputDir(configuration));
            IBuildEnvironmentVariable boardVar = this.getBoard(configuration);
            if (boardVar != null) {
                vars.add(boardVar);
            }
        }
        return vars.toArray(new IBuildEnvironmentVariable[vars.size()]);
    }

    private static final class EnvVar
    implements IBuildEnvironmentVariable {
        String name;
        String value;
        int operation = 1;
        String delimiter = null;

        private EnvVar() {
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public int getOperation() {
            return this.operation;
        }

        public String getDelimiter() {
            return this.delimiter;
        }
    }
}

